/*	Copyright (c) 1993  Cogent Data Technologies, Inc. */
/*	All Rights Reserved */


static char prog_copyright[] = "Copyright 1993 Cogent Data Technologies";

#ident	"@(#)kit:src/em845.cf/Space.c	1.00"
#ident  "$Header: $"

#include <sys/types.h>
#include <sys/stream.h>
#include <sys/dlpi_ether.h>
#include <config.h>

/*
 *  The N_SAPS define determines how many protocol drivers can bind to a single
 *  E/M III board.  A TCP/IP environment requires a minimum of two (IP and ARP).
 *  Putting an excessively large value here would waste memory.  A value that
 *  is too small could prevent a system from supporting a desired protocol.
 */
#define	N_SAPS		8

#define	STREAMS_LOG	0

/*
 *  The IFNAME define determines the name of the the internet statistics
 *  structure for this driver and only has meaning if the inet package is
 *  installed.  It should match the interface prefix specified in the strcf(4)
 *  file and ifconfig(1M) command used in rc.inet.  The unit number of the
 *  interface will match the board number (i.e emA0, emA1, emA2) and is not
 *  defined here.
 */
#define	IFNAME	"emA"

/********************** STOP!  DON'T TOUCH THAT DIAL ************************
 *
 *  The following values are set by the kernel build utilities and should not
 *  be modified by mere motals.
 */
int		emAboards = EMA_CNTLS;
int		emAstrlog = STREAMS_LOG;
char		*emA_ifname = IFNAME;
DL_sap_t	emAsaps[ N_SAPS * EMA_CNTLS ];
DL_bdconfig_t	emAconfig[ EMA_CNTLS ] = {
#ifdef EMA_0
	{
		EMA_CMAJOR_0,		/* Major number			*/
		EMA_0_SIOA,		/* Start of base I/O address	*/
		EMA_0_EIOA,		/* End of base I/O address	*/
		EMA_0_SCMA,		/* Start of base memory address	*/
		EMA_0_ECMA,		/* End of base memory address	*/
		EMA_0_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMA_1
	{
		EMA_CMAJOR_1,		/* Major number			*/
		EMA_1_SIOA,		/* Start of base I/O address	*/
		EMA_1_EIOA,		/* End of base I/O address	*/
		EMA_1_SCMA,		/* Start of base memory address	*/
		EMA_1_ECMA,		/* End of base memory address	*/
		EMA_1_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMA_2
	{
		EMA_CMAJOR_2,		/* Major number			*/
		EMA_2_SIOA,		/* Start of base I/O address	*/
		EMA_2_EIOA,		/* End of base I/O address	*/
		EMA_2_SCMA,		/* Start of base memory address	*/
		EMA_2_ECMA,		/* End of base memory address	*/
		EMA_2_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMA_3
	{
		EMA_CMAJOR_3,		/* Major number			*/
		EMA_3_SIOA,		/* Start of base I/O address	*/
		EMA_3_EIOA,		/* End of base I/O address	*/
		EMA_3_SCMA,		/* Start of base memory address	*/
		EMA_3_ECMA,		/* End of base memory address	*/
		EMA_3_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMA_4
	{
		EMA_CMAJOR_4,		/* Major number			*/
		EMA_4_SIOA,		/* Start of base I/O address	*/
		EMA_4_EIOA,		/* End of base I/O address	*/
		EMA_4_SCMA,		/* Start of base memory address	*/
		EMA_4_ECMA,		/* End of base memory address	*/
		EMA_4_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMA_5
	{
		EMA_CMAJOR_5,		/* Major number			*/
		EMA_5_SIOA,		/* Start of base I/O address	*/
		EMA_5_EIOA,		/* End of base I/O address	*/
		EMA_5_SCMA,		/* Start of base memory address	*/
		EMA_5_ECMA,		/* End of base memory address	*/
		EMA_5_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMA_6
	{
		EMA_CMAJOR_6,		/* Major number			*/
		EMA_6_SIOA,		/* Start of base I/O address	*/
		EMA_6_EIOA,		/* End of base I/O address	*/
		EMA_6_SCMA,		/* Start of base memory address	*/
		EMA_6_ECMA,		/* End of base memory address	*/
		EMA_6_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMA_7
	{
		EMA_CMAJOR_7,		/* Major number			*/
		EMA_7_SIOA,		/* Start of base I/O address	*/
		EMA_7_EIOA,		/* End of base I/O address	*/
		EMA_7_SCMA,		/* Start of base memory address	*/
		EMA_7_ECMA,		/* End of base memory address	*/
		EMA_7_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
};

#ifdef IP
int	emAinetstats = 1;
#else
int	emAinetstats = 0;
#endif

int	emAbus_t_on = 150;
