#ifndef _IO_DLPI_ETHER_DLPI_EMC_H	/* wrapper symbol for kernel use */
#define _IO_DLPI_ETHER_DLPI_EMC_H	/* subject to change without notice */

#ident	"@(#)kit:eth/src/dlpi_935.h	1.00"
#ident  "$Header: $"

/*	Copyright (c) 1993  Cogent Data Technologies			*/
/*	All Rights Reserved						*/
/*									*/
/*									*/
/*      eMASTER+ ATS DLPI streams device driver				*/
/*									*/
/*      Initiate version:       1.0             			*/
/*      Date:                   Sept. 24, 1993   			*/
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/*      Modification log:                                               */
/*                                                                      */
/* -------------------------------------------------------------------- */

/*
 *  Device dependent symbol names.
 */

/*
 *  STREAMS structures
 */
#define	DL_NAME		"emC"
#define	DLdevflag	emCdevflag
#define	DLrminfo	emCrminfo
#define	DLwminfo	emCwminfo
#define	DLrinit		emCrinit
#define	DLwinit		emCwinit

/*
 *  Functions
 */
#define DLopen		emCopen
#define	DLclose		emCclose
#define DLrput		emCrput
#define	DLwput		emCwput
#define	DLioctl		emCioctl
#define	DLinfo		emCinfo
#define	DLloopback	emCloopback
#define	DLmk_ud_ind	emCmk_ud_ind
#define	DLxmit_packet	emCxmit_packet
#define	DLintr		emCintr
#define	DLinfo_req	emCinfo_req
#define	DLcmds		emCcmds
#define	DLprint_eaddr	emCprint_eaddr
#define	DLbind_req	emCbind_req
#define	DLrsrv		emCrsrv
#define	DLunbind_req	emCunbind_req
#define	DLunitdata_req	emCunitdata_req
#define	DLerror_ack	emCerror_ack
#define	DLuderror_ind	emCuderror_ind
#define	DLpromisc_off	emCpromisc_off
#define	DLpromisc_on	emCpromisc_on
#define	DLset_eaddr	emCset_eaddr
#define	DLadd_multicast	emCadd_multicast
#define	DLset_multicast	emCset_multicast
#define	DLdel_multicast	emCdel_multicast
#define	DLdisable	emCdisable
#define	DLenable	emCenable
#define	DLreset		emCreset
#define	DLis_multicast	emCis_multicast
#define	DLget_multicast	emCget_multicast
#define DLrecv		emCrecv
#define DLproc_llc	emCproc_llc
#define DLform_80223	emCform_80223
#define DLmk_test_con	emCmk_test_con
#define DLinsert_sap	emCinsert_sap
#define DLsubsbind_req	emCsubsbind_req
#define DLtest_req	emCtest_req
#define DLremove_sap	emCremove_sap
#define DLis_equalsnap	emCis_equalsnap
#define DLform_snap	emCform_snap
#define DLis_broadcast	emCis_broadcast
#define DLis_us		emCis_us
#define DLis_validsnap	emCis_validsnap

#define DLbdspecioctl	emCbdspecioctl
#define DLbdspecclose	emCbdspecclose

/*
 *  wrapper functions
 */
#define DLinit		emCinit
#define DLuninit	emCuninit
#define DL_attach_info	emC_attach_info
/*
 *  Implementation structures and variables
 */
#define DL_ifname	emC_ifname
#define DLprint_eaddr	emCprint_eaddr
#define DLboards	emCboards
#define DLconfig	emCconfig
#define DLsaps		emCsaps
#define DLstrlog	emCstrlog
#define DLifstats	emCifstats
#define	DLinetstats	emCinetstats
#define	DLid_string	emCid_string
#define	DLcopyright	emCcopyright
#define	DLbus_t_on	emCbus_t_on
#define	em_debug	emCdebug

/*
 *  Flow control defines
 */
#define DL_MIN_PACKET		0
#define DL_MAX_PACKET		1500
#define DL_MAX_PACKET_LLC	(DL_MAX_PACKET - 3)
#define DL_MAX_PACKET_SNAP	(DL_MAX_PACKET_LLC - 5)
#define	DL_HIWATER		(40 * DL_MAX_PACKET)
#define	DL_LOWATER		(20 * DL_MAX_PACKET)

#define	USER_MAX_SIZE		1500
#define	USER_MIN_SIZE		46

/* Inline asm routine for block moves */
#ifndef lint
#ifndef C_PIO

asm	void mybcopy(src, dest, count)
{
%mem	src, dest, count;lab	r_1;
	movl	count, %ecx
	movl	dest, %eax
	push	%edi
	push	%esi
	movl	%eax, %edi	/* %edi = destination */
	movl	src, %eax  	
	movl	%eax, %esi	/* %esi = source */
	testw	$1, %cx		/* bit 0 set? */
	jz	r_1
	movsb
	dec	%ecx
r_1:
	shrl	$1, %ecx	/* cx <- cx / 2 */
	rep		
	movsw
	pop	%esi
	pop	%edi
}

#endif	/* ifndef C_PIO */
#endif	/* ifndef lint */

#endif	/* _IO_DLPI_ETHER_DLPI_EMC_H */
