/*	Copyright (c) 1993  Cogent Data Technologies	*/
/*	All Rights Reserved	*/


static char prog_copyright[] = "Copyright 1993 Cogent Data Technologies.";

#ident	"@(#)kit:src/em727.cf/Space.c	1.00"
#ident  "$Header: $"

#include <sys/types.h>
#include <sys/stream.h>
#include <sys/dlpi_ether.h>
#include <config.h>

/*
 *  The N_SAPS define determines how many protocol drivers can bind to a single
 *  E/M II board.  A TCP/IP environment requires a minimum of two (IP and ARP).
 *  Putting an excessively large value here would waste memory.  A value that
 *  is too small could prevent a system from supporting a desired protocol.
 */
#define	N_SAPS		8

/*
 *  The STREAMS_LOG define determines if STREAMS tracing will be done in the
 *  driver.  A non-zero value will allow the strace(1M) command to follow
 *  activity in the driver.  The driver ID used in the strace(1M) command is
 *  equal to the ENET_ID value (generally 2101).
 *
 *  NOTE:  STREAMS tracing can greatly reduce the performance of the driver
 *         and should only be used for trouble shooting.
 */
#define	STREAMS_LOG	0

/*
 *  The IFNAME define determines the name of the the internet statistics
 *  structure for this driver and only has meaning if the inet package is
 *  installed.  It should match the interface prefix specified in the strcf(4)
 *  file and ifconfig(1M) command used in rc.inet.  The unit number of the
 *  interface will match the board number (i.e emB0, emB1, emB2) and is not
 *  defined here.
 */
#define	IFNAME	"emB"

/********************** STOP!  DON'T TOUCH THAT DIAL ************************
 *
 *  The following values are set by the kernel build utilities and should not
 *  be modified by mere motals.
 */
int		emBboards = EMB_CNTLS;
int		emBstrlog = STREAMS_LOG;
char		*emB_ifname = IFNAME;
DL_sap_t	emBsaps[ N_SAPS * EMB_CNTLS ];
DL_bdconfig_t	emBconfig[ EMB_CNTLS ] = {
#ifdef EMB_0
	{
		EMB_CMAJOR_0,		/* Major number			*/
		EMB_0_SIOA,		/* Start of base I/O address	*/
		EMB_0_EIOA,		/* End of base I/O address	*/
		EMB_0_SCMA,		/* Start of base memory address	*/
		EMB_0_ECMA,		/* End of base memory address	*/
		EMB_0_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMB_1
	{
		EMB_CMAJOR_1,		/* Major number			*/
		EMB_1_SIOA,		/* Start of base I/O address	*/
		EMB_1_EIOA,		/* End of base I/O address	*/
		EMB_1_SCMA,		/* Start of base memory address	*/
		EMB_1_ECMA,		/* End of base memory address	*/
		EMB_1_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMB_2
	{
		EMB_CMAJOR_2,		/* Major number			*/
		EMB_2_SIOA,		/* Start of base I/O address	*/
		EMB_2_EIOA,		/* End of base I/O address	*/
		EMB_2_SCMA,		/* Start of base memory address	*/
		EMB_2_ECMA,		/* End of base memory address	*/
		EMB_2_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMB_3
	{
		EMB_CMAJOR_3,		/* Major number			*/
		EMB_3_SIOA,		/* Start of base I/O address	*/
		EMB_3_EIOA,		/* End of base I/O address	*/
		EMB_3_SCMA,		/* Start of base memory address	*/
		EMB_3_ECMA,		/* End of base memory address	*/
		EMB_3_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
};

int	emBdma_chan[ EMB_CNTLS ] = {
#ifdef EMB_0
		EMB_0_CHAN,
#endif
#ifdef EMB_1
		EMB_1_CHAN,
#endif
#ifdef EMB_2
		EMB_2_CHAN,
#endif
#ifdef EMB_3
		EMB_3_CHAN
#endif
};

#ifdef IP
int	emBinetstats = 1;
#else
int	emBinetstats = 0;
#endif

int	emBbus_t_on = 150;
int	busrate = 1;
