/*	Copyright (c) 1993  Cogent Data Technologies, Inc. */
/*	All Rights Reserved */


static char prog_copyright[] = "Copyright 1993 Cogent Data Technologies";

#ident	"@(#)kit:src/em935.cf/Space.c	1.00"
#ident  "$Header: $"

#include <sys/types.h>
#include <sys/stream.h>
#include <sys/dlpi_ether.h>
#include <config.h>

/*
 *  The N_SAPS define determines how many protocol drivers can bind to a single
 *  E/M III board.  A TCP/IP environment requires a minimum of two (IP and ARP).
 *  Putting an excessively large value here would waste memory.  A value that
 *  is too small could prevent a system from supporting a desired protocol.
 */
#define	N_SAPS		8

#define	STREAMS_LOG	0

/*
 *  The IFNAME define determines the name of the the internet statistics
 *  structure for this driver and only has meaning if the inet package is
 *  installed.  It should match the interface prefix specified in the strcf(4)
 *  file and ifconfig(1M) command used in rc.inet.  The unit number of the
 *  interface will match the board number (i.e emC0, emC1, emC2) and is not
 *  defined here.
 */
#define	IFNAME	"emC"

/********************** STOP!  DON'T TOUCH THAT DIAL ************************
 *
 *  The following values are set by the kernel build utilities and should not
 *  be modified by mere motals.
 */
int		emCboards = EMC_CNTLS;
int		emCstrlog = STREAMS_LOG;
char		*emC_ifname = IFNAME;
DL_sap_t	emCsaps[ N_SAPS * EMC_CNTLS ];
DL_bdconfig_t	emCconfig[ EMC_CNTLS ] = {
#ifdef EMC_0
	{
		EMC_CMAJOR_0,		/* Major number			*/
		EMC_0_SIOA,		/* Start of base I/O address	*/
		EMC_0_EIOA,		/* End of base I/O address	*/
		EMC_0_SCMA,		/* Start of base memory address	*/
		EMC_0_ECMA,		/* End of base memory address	*/
		EMC_0_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMC_1
	{
		EMC_CMAJOR_1,		/* Major number			*/
		EMC_1_SIOA,		/* Start of base I/O address	*/
		EMC_1_EIOA,		/* End of base I/O address	*/
		EMC_1_SCMA,		/* Start of base memory address	*/
		EMC_1_ECMA,		/* End of base memory address	*/
		EMC_1_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMC_2
	{
		EMC_CMAJOR_2,		/* Major number			*/
		EMC_2_SIOA,		/* Start of base I/O address	*/
		EMC_2_EIOA,		/* End of base I/O address	*/
		EMC_2_SCMA,		/* Start of base memory address	*/
		EMC_2_ECMA,		/* End of base memory address	*/
		EMC_2_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMC_3
	{
		EMC_CMAJOR_3,		/* Major number			*/
		EMC_3_SIOA,		/* Start of base I/O address	*/
		EMC_3_EIOA,		/* End of base I/O address	*/
		EMC_3_SCMA,		/* Start of base memory address	*/
		EMC_3_ECMA,		/* End of base memory address	*/
		EMC_3_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMC_4
	{
		EMC_CMAJOR_4,		/* Major number			*/
		EMC_4_SIOA,		/* Start of base I/O address	*/
		EMC_4_EIOA,		/* End of base I/O address	*/
		EMC_4_SCMA,		/* Start of base memory address	*/
		EMC_4_ECMA,		/* End of base memory address	*/
		EMC_4_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMC_5
	{
		EMC_CMAJOR_5,		/* Major number			*/
		EMC_5_SIOA,		/* Start of base I/O address	*/
		EMC_5_EIOA,		/* End of base I/O address	*/
		EMC_5_SCMA,		/* Start of base memory address	*/
		EMC_5_ECMA,		/* End of base memory address	*/
		EMC_5_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMC_6
	{
		EMC_CMAJOR_6,		/* Major number			*/
		EMC_6_SIOA,		/* Start of base I/O address	*/
		EMC_6_EIOA,		/* End of base I/O address	*/
		EMC_6_SCMA,		/* Start of base memory address	*/
		EMC_6_ECMA,		/* End of base memory address	*/
		EMC_6_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef EMC_7
	{
		EMC_CMAJOR_7,		/* Major number			*/
		EMC_7_SIOA,		/* Start of base I/O address	*/
		EMC_7_EIOA,		/* End of base I/O address	*/
		EMC_7_SCMA,		/* Start of base memory address	*/
		EMC_7_ECMA,		/* End of base memory address	*/
		EMC_7_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
};

#ifdef IP
int	emCinetstats = 1;
#else
int	emCinetstats = 0;
#endif

int	emCbus_t_on = 100;
