/*
@echo off
cls
echo.
echo.
echo ERROR:
echo REXX support not installed
echo You must have REXX support installed to run this
echo program.
echo.
exit
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
/*-- get the command line --*/
parse arg destdir

/*-- do main screen --*/
call SysCls
say
say '                   ELSA Image Viewer Installation'
say

UseDestDir = 0 
if destdir \= "" then do
   destdrive = filespec("drive", destdir);
   destpath  = filespec("path", destdir);
   UseDestDir = 1
end

/*call SysCls*/
lang = SysIni("USER" , "PM_National" , "iCountry" )
SubDir = "eng"
SearchFile1 = "elsae.hlp"
SearchFile2 = "elsad.hlp"
bDeu = "0"
if lang \= "49" then
   do
     SubDir = "deu"
     SearchFile1 = "elsad.hlp"
     SearchFile2 = "elsae.hlp"
     bDeu = "1 "
   end

/* Go search for the OS2.INI file, this will be our bootdrive */
testos2path = SysSearchPath('PATH', 'OS2.INI');
BootDrive = FILESPEC("drive", testos2path);

if UseDestDir = 0 then do
   say 'searching ELSA Folder/directory....'
   result = SysFileTree(BootDrive||"\"||SearchFile1, files, "SBO" );
   if result = 1 then do
      result = SysFileTree(BootDrive||"\"||SearchFile2, files, "SBO" );
      if result = 1 then do
         say "Can't find a ELSA Utilities Folder."
         say "Please correct the problem before"
         exit
      end
   end
   ELSAPath = FILESPEC("drive", files.1)||FILESPEC("path", files.1);
   if files.0 > 1 then do
      say "Warning : found multiple ELSA files."
      say "          The "||ELSAPath||" will be used."
      say
      say '          Or use install with a parameter'
      say '             x:\dir' 
      say '             x: is the drive letter'
      say '             dir is the path where to install'
      say
   end   
end
else do
   ELSAPath = translate(destdir) ;
   CurPath = directory();
   UserDir = directory(ELSAPath);

   if SysDriveInfo(destdrive) = "" then do 
      say "Drive "||destdrive||" does't exist"
      say "Installation cancelled"
      exit
   end
   if UserDir \= ELSAPath then do
      "@"||destdrive
      "@cd \";
      result = SysMkDir( ELSAPath );
      if result \= 0 then do
         say "Can't create destination directory"
         say "Installation cancelled"
         call directory CurPath
         exit
      end
   end
   result = directory(CurPath);
   if result \= CurPath then do
        exit
   end
   ELSAPath = destdir||"\"
end
/*-- do main screen --*/
say
say 'The ELSA Image Viewer will be installed with the following settings:'
say
say 'Directory: "'ELSAPath'"'
say
say 'Okay to continue(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then do
   say
   say ' Installation cancelled.'
   exit
end
   
"@copy "||SubDir||"\*.* "||ELSAPath||"*.* 1>NUL"
"@copy cpview.ico "||ELSAPath||"*.* 1>NUL"

result = SysOpenObject("<ELSA>",'Default', 'False');
if result = 1 then do
   result = SysCreateObject("WPProgram", "CPView", "<ELSA>",,
       "EXENAME="||ELSAPath||"cpview.EXE;STARTUPDIR="||ELSAPath||"ICONFILE="||ELSAPath||"cpview.ico",,
       "replace");
   if result = 0 then do
      say "create object CPView failed"
   end
end
else do
   say 'Open object ELSA Utilities failed.'
   exit
end
say 'Installation was successful'





