#include <stdio.h>
#include "..\fblib\fb.h"
long rtab[636], gtab[636], btab[636], wtab[636];

main(argc, argv)
char **argv;
{
	register long *pr, *pg, *pb, *pw;
	register double dv, thresh;
	register int v, i, j, k;

	pr = (long *)VRAM;
	pg = pr + 450;
	pb = pr + 450*HSIZE;
	pw = pb + 450;
	thresh = 636.0/256.0;
	dv = 0.0;
	v = 255;

	fb_init();
	do_cmap();
	fb_clear_screen();

	for(i = 0; i < 636; i++){
		rtab[i] = v<<24;
		gtab[i] = v<<16;
		btab[i] = v<<8;
		wtab[i] = rtab[i]|gtab[i]|btab[i];
		dv += 1.0;
		if(dv >= thresh){
			v--;
			if(v < 0) v = 0;
			dv -= thresh;
		}
	}
	for(i = 0; i < 450; i++){
		for(j = 255-((wtab[i]>>8) & 0xff), k = j+450; j < k; j++){
			*pr++ = rtab[j];
			*pg++ = gtab[j];
			*pb++ = btab[j];
			*pw++ = wtab[j];
		}
		pr += HSIZE-450;
		pg += HSIZE-450;
		pb += HSIZE-450;
		pw += HSIZE-450;
	}
	show_cmap();
	exit(0);
}


struct ccm {
	char c_fluff;
	char c_blue;
	char c_green;
	char c_red;
} clist[900];

do_cmap()
{
	long si;
	short n_ent, i, ci, cd;

	/* There are 6 transitions in the color wheel, and 900 colors
	 * to do them in
	 */
	ci = 0;
	cd = 149;
	for(i = 0; i < 150; i++, ci++, cd--){
		if(i == 149){
			ci = 149;
			cd = 0;
		}
		clist[i].c_red = 255;
		clist[i].c_green = ((float)(ci)/149.0)*255.0;
		clist[i].c_blue = 0;

		clist[i+150].c_red = ((float)(cd)/149.0)*255.0;
		clist[i+150].c_green = 255;
		clist[i+150].c_blue = 0;

		clist[i+300].c_red = 0;
		clist[i+300].c_green = 255;
		clist[i+300].c_blue = ((float)(ci)/149.0)*255.0;

		clist[i+450].c_red = 0;
		clist[i+450].c_green = ((float)(cd)/149.0)*255.0;
		clist[i+450].c_blue = 255;

		clist[i+600].c_red = ((float)(ci)/149.0)*255.0;
		clist[i+600].c_green = 0;
		clist[i+600].c_blue = 255;

		clist[i+750].c_red = 255;
		clist[i+750].c_green = 0;
		clist[i+750].c_blue = ((float)(cd)/149.0)*255.0;
	}
}
show_cmap()
{
	register long *pp, *pc, v;
	register int i, j;

	pp = (long *)(VRAM) + 900;
	pc = (long *)(&clist[0]);
	for(i = 0; i < 900; i++, pp += 900){
		v = *pc++;
		for(j = 0; j < HSIZE-900; j++){
			*pp++ = v;
		}
	}
}
