
#include <stdio.h>
#include "..\fblib\fb.h"

short xa[1300], ya[1030];

main(argc, argv)
char **argv;
{
	register int i, j, k, ns, dist, x, y, c, nl;

	ns = 1;
	nl = 16;
	while(--argc > 0){
		argv++;
		if(**argv != '-')
			break;
		switch((int)(argv[0][1])){
		case 'l':
			if(argc > 1){
				argv++;
				argc--;
				nl = atoi(*argv);
			}
			break;
		case 'n':
			if(argc > 1){
				argv++;
				argc--;
				ns = atoi(*argv);
			}
			break;

		default:
			fprintf(stderr, "Usage: sweep [-l lines] [-n nsweeps]\n");
			exit(1);
		}
	}


	if(nl > 1024 || nl < 0)
		nl = 16;

	dist = 1024/nl;
	for(i = 0, j = 0; j < 1152; j += dist, i++){
		xa[i] = j;
		if(j < 900)
			ya[i] = j;
	}
	
	fb_init();
	do_cmap();
	fb_clear_screen();

	/* i has number of x's, nl has number of y's */
	nl = 1024/dist;
	while(ns-- > 0){
		x = (rand() % 1100) + 40;
		y = (rand() % 800) + 40;
		c = (rand()%384) + 2;
		fb_color(c);
		/* Do the x's */
		for(k = 0; k < i; k++){
			fb_move(x, y);
			fb_line(xa[k], 0);
		}
		for(k = 0; k < nl; k++){
			fb_move(x, y);
			fb_line(1151, ya[k]);
		}
		for(k = i-1; k >= 0; k--){
			fb_move(x, y);
			fb_line(xa[k], 899);
		}
		for(k = nl-1; k >= 0; k--){
			fb_move(x, y);
			fb_line(0, ya[k]);
		}
	}
	exit(0);
}

color_map_t clist[386];

do_cmap()
{
	long si;
	short n_ent, i, ci, cd;

	/* Make a color wheel
	 * Color index 0 is always black
	 * Color index 1 is always white
	 */

	clist[0].c_red = clist[0].c_green = clist[0].c_blue = 0.0;
	clist[1].c_red = clist[1].c_green = clist[1].c_blue = 1.0;

	/* There are 6 transitions in the color wheel, and 384 colors
	 * to do them in
	 */
	ci = 0;
	cd = 63;
	for(i = 2; i < 64+2; i++, ci++, cd--){
		if(i == 64+2-1){
			ci = 63;
			cd = 0;
		}
		clist[i].c_red = 1.0;
		clist[i].c_green = (float)(ci)/63;
		clist[i].c_blue = 0.0;

		clist[i+64].c_red = (float)(cd)/63.0;
		clist[i+64].c_green = 1.0;
		clist[i+64].c_blue = 0.0;

		clist[i+128].c_red = 0.0;
		clist[i+128].c_green = 1.0;
		clist[i+128].c_blue = (float)(ci)/63.0;

		clist[i+192].c_red = 0.0;
		clist[i+192].c_green = (float)(cd)/63.0;
		clist[i+192].c_blue = 1.0;

		clist[i+256].c_red = (float)(ci)/63.0;
		clist[i+256].c_green = 0.0;
		clist[i+256].c_blue = 1.0;

		clist[i+320].c_red = 1.0;
		clist[i+320].c_green = 0.0;
		clist[i+320].c_blue = (float)(cd)/63.0;
	}
	if(fb_set_color_map(386, 0, clist))
		fprintf(stderr, "error setting map\n");
}

