#include <stdio.h>
/*	#include <pwd.h>	*/
#define	SWAPBYTES
#include "xfont.h"
#include "vgadefs.h"
#define	VGAMAXFONT	32
/*
 * Structure that holds info about fonts
 */
struct	vgafont	{
	FontData	*ff_fontp;	/* Pointer to X font header */
	uchar		*ff_data;	/* Pointer to the data */
	char		**ff_slp;	/* Pointers to each scanline */
	short		*ff_leftarray;	/* X coord of each char in font */
	short		*ff_width;	/* Width of each char in font */
	short		ff_maxwid;	/* Widest character */
	short		ff_bwidth;	/* Width in bytes of scanline */
};
typedef struct vgafont	VGAFONT;

VGAFONT *_VGA_FONT_TAB[VGAMAXFONT], *_VGA_CURFONT;
int	_VGA_NFONT = 0;

#define	CHARPERFONT	256

struct	passwd *getpwnam();

char *fontpath = NULL;

vga_loadfont(f)
char *f;
{
	FILE *fp;
	FontData *font;
	BitMap *bp;
	int fontsize, leftsize, tabsize = (CHARPERFONT+1)*(sizeof (short));
	char **lp;
	uchar *fdata;
	short *leftarea, *leftarray;
	register int i, j, find;
	VGAFONT *ff;
	char fname[256], *s, *p, *fpath, *getenv(), *strchr();
	struct passwd *pw;

	/* See if room for this font */
	find = -1;
	for(i = 0; i < VGAMAXFONT; i++){
		if(_VGA_FONT_TAB[i] == (VGAFONT *)NULL){
			find = i;
			break;
		}
	}
	if(find == -1){
		return(-10);
	}
	/* Determine X font lookup path */
	if(fontpath == NULL){
		s = getenv("XFONTPATH");
		if(s && (fontpath = (char *)malloc(strlen(s)+1))){
			strcpy(fontpath, s);
		}
	}
	if((fpath = fontpath) == NULL){
		fpath = fontpath = DEFAULT_FONT_PATH;
	}

	/* First, try specified font, then try in special directory (s) */
	fp = fopen(f, "rb");
	while(fp == (FILE *)NULL){
		if((s = strchr(fpath, ':')) != NULL)
			*s = '\0';
		if(*fpath == '\0'){
			if(s)
				*s = ':';
#ifdef TILDE
			endpwent();
#endif
			return(-2);
		}
#ifdef TILDE
		if(*fpath == '~'){
			fpath++;
			if(*fpath != '/'){		/* ~user case */
				p = strchr(fpath+1, '/');
				if(p)
					*p = '\0';
				pw = getpwnam(fpath);
				if(pw == (struct passwd *)NULL)
					goto nextcomp;
				if(p)
					*p = '/';
				fpath = p;
				p = pw->pw_dir;
			} else	{
				if((p = getenv("HOME")) == NULL){
					goto nextcomp;
				}
			}
			sprintf(fname, "%s%s%s/%s", p, *fpath == '/' ? "" : "/",
				fpath, f);
		} else
#endif
			sprintf(fname, "%s/%s", fpath, f);
		if((fp = fopen(fname, "rb")) == NULL){
			strcat(fname, DEFAULT_FONT_SUFFIX);
			fp = fopen(fname, "rb");
		}
nextcomp:
		if(s){
			*s = ':';
			fpath = ++s;
		} else	break;
	}
#ifdef TILDE
	endpwent();
#endif
	if(fp == (FILE *)NULL){
		return(-1);
	}
	font = (FontData *)malloc(sizeof (FontData));
	if(font == (FontData *)NULL){
		fclose(fp);
		return(-3);
	}
	if(fread(font, sizeof (FontData), 1, fp) != 1){
		fclose(fp);
		free(font);
		return(-4);
	}
	if((ff = (VGAFONT *)malloc(sizeof (VGAFONT))) == (VGAFONT *)NULL){
		return(-4);
	}
	/* Isn't this a kick? Only swap shorts on NON braindead machines! */
#ifndef SWAPBYTES
	swapshorts(font, (sizeof (FontData)) >> 1);
#endif
	bp = (BitMap *)font->f_characters;
	ff->ff_bwidth = ((bp->bm_width+(BROUND-1))/BROUND) * (BROUND/8);
	fontsize = ff->ff_bwidth * bp->bm_height;
	fdata = (uchar *)malloc(fontsize);
	if(fdata == (uchar *)NULL){
		fclose(fp);
		free(font);
		free(ff);
		return(-5);
	}
	fseek(fp, (long)((unsigned short)(bp->bm_address[0])), 0);
	if(fread(fdata, 1, fontsize, fp) != fontsize){
		fclose(fp);
		free(font);
		free(fdata);
		free(ff);
		return(-6);
	}
#ifndef SWAPBYTES
	swapshorts(fdata, fontsize>>1);
#endif
	leftarea = (short *)malloc(tabsize);
	if(leftarea == (short *)NULL){
		fclose(fp);
		free(fdata);
		free(ff);
		free(font);
		return(-7);
	}
	leftarray = (short *)malloc(tabsize);
	if(leftarray == (short *)NULL){
		fclose(fp);
		free(fdata);
		free(leftarea);
		free(ff);
		free(font);
		return(-8);
	}
	for(i = tabsize/(sizeof (short)); i > 0; i--)
		leftarray[i] = 0;
	if(font->f_fixedWidth == 0){		/* Proportional font */
		leftsize = (font->f_lastChar-font->f_firstChar+2) * sizeof (short);
		fseek(fp, (long)((unsigned short)(font->f_leftArray[0])), 0);
		if(fread(&(leftarray[font->f_firstChar]), 1, leftsize, fp) !=
			leftsize){
			fclose(fp);
			free(font);
			free(fdata);
			free(leftarea);
			free(leftarray);
			free(ff);
			return(-8);
		}
#ifndef SWAPBYTES
		swapshorts(&(leftarray[font->f_firstChar]), leftsize>>1);
#endif
	} else	{
		j = 0;
		for(i = font->f_firstChar; i <= font->f_lastChar+1; i++){
			leftarray[i] = j;
			j += font->f_fixedWidth;
		}
	}
	fclose(fp);
	lp = (char **)malloc(bp->bm_height * (sizeof (char *)));
	if(lp == (char **)NULL){
		free(fdata);
		free(leftarea);
		free(leftarray);
		free(ff);
		free(font);
		return(-9);
	}
	j = ff->ff_bwidth;
	/* I don't think I use the lp[] array (yet), but it could be
	 * useful later.
	 */
	for(i = 0; i < bp->bm_height; i++)
		lp[i] = ((char *)fdata) + i*j;
	ff->ff_maxwid = 0;
	for(i = font->f_firstChar; i <= font->f_lastChar; i++){
		j = leftarray[i+1] - leftarray[i];
		if(j < 0)
			j = 0;
		leftarea[i] = j;
		if(j > ff->ff_maxwid)
			ff->ff_maxwid = j;
	}
	ff->ff_fontp = font;
	ff->ff_leftarray = leftarray;
	ff->ff_width = leftarea;
	ff->ff_slp = lp;
	ff->ff_data = fdata;
	fixfont(ff);		/* machine dependent hack */
#ifdef DEBUG
	fprintf(stderr, "Font %s:\n", f);
	fprintf(stderr, "fontp=0x%x leftarray=0x%x width=0x%x slp=0x%x data=0x%x\n",
		ff->ff_fontp, ff->ff_leftarray, ff->ff_width, ff->ff_slp, ff->ff_data);
	fprintf(stderr, "CHAR	LEFT	WIDTH  (Max=%d)\n", ff->ff_maxwid);
	for(i = font->f_firstChar; i <= font->f_lastChar; i++)
		fprintf(stderr, "%4d	%5d	%4d\n",
			i, leftarray[i], leftarea[i]);
	fprintf(stderr, "Line pointers (each line %d bytes long):\n",
		ff->ff_bwidth);
	for(i = 0; i < bp->bm_height; i++){
		fprintf(stderr, "%2d: 0x%x\n", i, lp[i]);
	}
#endif
	_VGA_FONT_TAB[find] = ff;
	return(find);
}
vga_unloadfont(n)
int n;
{
	VGAFONT *ff;

	if(n < 0 || n >= VGAMAXFONT || _VGA_FONT_TAB[n] == (VGAFONT *)NULL)
		return(-1);
	ff = _VGA_FONT_TAB[n];
	free(ff->ff_data);
	free(ff->ff_slp);
	free(ff->ff_leftarray);
	free(ff->ff_width);
	free(ff->ff_fontp);
	free(ff);
	_VGA_FONT_TAB[n] = (VGAFONT *)NULL;
	return(0);
}

short	bmask[] = {
	0x80, 0x40, 0x20, 0x10,
	0x08, 0x04, 0x02, 0x01
};

vga_cwidth(c)
int c;
{
	register VGAFONT *ff = _VGA_CURFONT;

	if(ff == (VGAFONT *)NULL)
		return(-1);
	if(c > ff->ff_fontp->f_lastChar || c < ff->ff_fontp->f_firstChar)
		c = 0;
	return(ff->ff_width[c]);
}

/*
 * Put character at index 'c', font 'n' at 'x', 'y' on screen.
 * x, y is the lower left corner of the character cell, IE y is the
 * baseline (decenders will fall below y), and x is the leftmost
 * position of the character
 */
vga_outc(c)
int c;
{
	register VGAFONT *ff;
	register uchar *oop, *iip;
	register int iibit, oobit, jj, j;
	register uchar *op, *ip;
	register int ibit, obit, i;

	ff = _VGA_CURFONT;
	if(ff == NULL)
		return(-1);
	/*
	 * First task is to get a pointer to the upper LEFT corner
	 * of where we are putting this character cell
	 * We get this by taking the supplied y value, and SUBTRACTING
	 * the baseline value of the font
	 */
	i = _FB_YPOS - ff->ff_fontp->f_baseline;
/*fprintf(stderr, "char 0x%02x; x=%d y=%d ", c, _FB_XPOS, _FB_YPOS);*/
	/*
	 * Make sure we don't go off top of bitmap
	 */
	if(i < 0)
		i = 0;
	op = VRAM + (i * HSIZE) + _FB_XPOS;
	/*
	 * Determine variables for the input character
	 */
	if(c > ff->ff_fontp->f_lastChar || c < ff->ff_fontp->f_firstChar)
		c = 0;
	i = ff->ff_leftarray[c];
	ip = ff->ff_data + (i>>3);
	ibit = i & 7;
	j = ff->ff_width[c];
/*fprintf(stderr, "   leftpos=%d  fdata=0x%x ip=0x%x ibit=%d width=%d\n", i, ff->ff_data, ip, ibit, j);*/

	/*
	 * Determine if bitmap bm is long enough to hold this character
	 */
	i = ((BitMap *)(ff->ff_fontp->f_characters))->bm_height;
	if(_FB_YPOS + (i - ff->ff_fontp->f_baseline) > 200){
		i = 200 - (_FB_YPOS - ff->ff_fontp->f_baseline);
	}
	if(_FB_XPOS + j > HSIZE){
		/* Too wide, only go as far as we can */
		j = HSIZE - _FB_XPOS;
	}
	/*
	 * Got all the parameters, do the "blit"
	 */
	while(i-- > 0){
		iibit = ibit;
		iip = ip;
		oop = op;
		for(jj = 0; jj < j; jj++, oop++){
			if(*iip & bmask[iibit]){
				switch(_FB_ROP){
				case ROP_STORE:
					*oop = _FB_COLOR;
					break;
				case ROP_OR:
					*oop |= _FB_COLOR;
					break;
				case ROP_XOR:
					*oop ^= _FB_COLOR;
					break;
				case ROP_CLEAR:
					*oop &= ~(_FB_COLOR);
					break;
				}
			}
			if(++iibit == 8){
				iibit = 0;
				iip++;
			}
		}
		op += HSIZE;
		ip += ff->ff_bwidth;
	}
	/* Return the width (possible adjusted) of the character */
	_FB_XPOS += j;
	return(j);
}
vga_space()
{
	register VGAFONT *ff = _VGA_CURFONT;

	if(ff == (VGAFONT *)NULL)
		return(-1);
	return(ff->ff_width[ff->ff_fontp->f_spaceIndex + ff->ff_fontp->f_firstChar]);
}

vga_setfont(n)
int n;
{
	if(n >= VGAMAXFONT || n < 0 || _VGA_FONT_TAB[n] == (struct vgafont *)NULL)
		return(-1);
	_VGA_CURFONT = _VGA_FONT_TAB[n];
	return(0);
}

vga_string(s, n)
register char *s;
register int n;
{
	register int l;

	l = 0;
	while(n-- > 0){
		l += vga_outc(*s);
		s++;
	}
	return(l);
}

vga_extent(s, n)
register char *s;
register int n;
{
	register int l;

	l = 0;
	while(n-- > 0){
		l += vga_cwidth(*s);
		s++;
	}
	return(l);
}


swapshorts(sp, n)
register unsigned short *sp;
register n;
{
	while(n-- > 0){
		*sp = ((*sp>>8) | ((*sp & 0xff)<< 8));
		sp++;
	}
}
static short ReverseBitsInByte[256] = {
0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0, 0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8, 0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4, 0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec, 0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2, 0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea, 0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6, 0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee, 0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1, 0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9, 0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5, 0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed, 0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3, 0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb, 0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7, 0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef, 0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff,
};

#define ReverseBitsInShort(s) ((ReverseBitsInByte[(unsigned char)(s)]<<8)|ReverseBitsInByte[(unsigned char)((s)>>8)])

fixfont(ff)
VGAFONT *ff;
{
	register unsigned short *s;
	register int n, ns;

	n = ff->ff_bwidth * (((BitMap *)(ff->ff_fontp->f_characters))->bm_height);
	n /= (sizeof (short));
	ns = n;
	for(s = (unsigned short *)ff->ff_data; n > 0; n--, s++)
		*s = ReverseBitsInShort(*s);
#ifdef SWAPBYTES
	/* This is a shocker... we swap the bytes AFTER we reorder the bits;
	 * this is because the font bit data is already byteswapped when
	 * x-fonts gives it to us.  Now, after we reorder the bits,
	 * we need the font data in a "byte" oriented format, IE we will
	 * be accessing the data via char pointers, not short pointers,
	 * so we want to un-do the braindamage.  It's sick, but so is
	 * the intel/vax arch.  No apologies for this awful code here!
	 */
	swapshorts(ff->ff_data, ns);
#endif
}
