/*
 * vga_init - initialize vga routines.  Performs basic
 * initializations of color map and positions
 *
 * 11/18/90 - Copyright (c) 1990, Hauppauge Computer Works
 *
 */
#include <sys/types.h>
#ifdef SCO
#include "console.h"
#define	SETVGAMODE	SW_VGA13
#define	SETNORMMODE	SW_VGA80x25
#else
#define MODESWITCH	('x' << 8)	/* Upper byte of mode switch ioctl's */
#define	SETVGAMODE	(MODESWITCH|30)
#define	SETNORMMODE	(MODESWITCH|7)
#endif
#include "vgadefs.h"

#define	NULL	0

vga_init()
{

	if(ioctl(0, SETVGAMODE, 0) == -1)
		return(-1);
	vga_cmap();
	mod_colreg(0);

	/* Position to 0,0 */
	_FB_XPOS = 0;
	_FB_YPOS = 0;

	/* Color to WHITE */
	_FB_COLOR = VGA_WHITE;
	return(0);
}

vga_term()
{
	mod_colreg(1);
	if(ioctl(0, SETNORMMODE, 0) == -1)
		return(-1);
	return(0);
}

static char savcol[256][3];

mod_colreg(how)
{
	register int r, g, b, i;
	register struct cmap *cmap;

	cmap = _FB_CMAP;

	if(how == 0){
		outp(0x3c7, 0);
		for(i = 0; i < 256; i++){
			savcol[i][0] = inp(0x3c9) & 0xff;
			savcol[i][1] = inp(0x3c9) & 0xff;
			savcol[i][2] = inp(0x3c9) & 0xff;
		}
		outp(0x3c8, 0);
		for(i = 0; i < 256; i++, cmap++){
			outp(0x3c9, cmap->c_red);
			outp(0x3c9, cmap->c_green);
			outp(0x3c9, cmap->c_blue);
/*
printf("r:%3d g:%3d b:%3d\n", cmap->c_red, cmap->c_green, cmap->c_blue);
*/
		}
	} else	{
		outp(0x3c8, 0);
		for(i = 0; i < 256; i++){
			outp(0x3c9, savcol[i][0]);
			outp(0x3c9, savcol[i][1]);
			outp(0x3c9, savcol[i][2]);
		}
	}
}

new_colreg(cp, n)
register struct cmap *cp;
{
	register int i;
	register unsigned char *p;

	p = (unsigned char *)(0xf70003da);
	while((*p & 0x08) == 0)
		;
	p = (unsigned char *)(0xf70003c8);
	*p = 0;		/* outp(0x3c8, 0) */
	p++;
	for(i = 0; i < n; i++, cp++){
		*p = cp->c_red; 	/* outp(0x3c9, cp->c_red); */
		*p = cp->c_green;	/* outp(0x3c9, cp->c_green); */
		*p = cp->c_blue;	/* outp(0x3c9, cp->c_blue); */
	}
}
inp(addr)
register int addr;
{
	register unsigned char *p;
	p = (unsigned char *)(0xf7000000+addr);
	addr = *p & 0xff;
	return(addr);
}

outp(addr, value)
register int addr, value;
{
	register unsigned char *p;

	p = (unsigned char *)(0xf7000000+addr);
	*p = value;
}

#define	NTRANS	42
#define	NTRANM1	41
static short csat[NTRANS];

vga_cmap()
{
	long si;
	short n_ent, i, ci, cd;
	double cv, inc;

	cv = 0.0;
	inc = 63.0/(double)(NTRANS);
	for(i = 0; i < NTRANM1; i++){
		csat[i] = (short)(cv);
		cv = cv + inc;
	}
	csat[NTRANM1] = 63;

	/* Make a color wheel
	 * Color index 0 is always black
	 * Color index 1 is always white
	 */

	_FB_DEF_CMAP[0].c_red = _FB_DEF_CMAP[0].c_green = _FB_DEF_CMAP[0].c_blue = csat[0];
	_FB_DEF_CMAP[1].c_red = _FB_DEF_CMAP[1].c_green = _FB_DEF_CMAP[1].c_blue = csat[NTRANM1];
	_FB_DEF_CMAP[254].c_red = _FB_DEF_CMAP[254].c_green = _FB_DEF_CMAP[254].c_blue = csat[NTRANM1];
	_FB_DEF_CMAP[255].c_red = _FB_DEF_CMAP[255].c_green = _FB_DEF_CMAP[255].c_blue = csat[NTRANM1];

	/* There are 6 transitions in the color wheel, and 254 colors
	 * to do them in
	 */
	ci = 0;
	cd = NTRANM1;
	for(i = 2; i < NTRANS+2; i++, ci++, cd--){
		if(i == NTRANS+2-1){
			ci = NTRANM1;
			cd = 0;
		}
		_FB_DEF_CMAP[i].c_red = csat[NTRANM1];
		_FB_DEF_CMAP[i].c_green = csat[ci];
		_FB_DEF_CMAP[i].c_blue = csat[0];

		_FB_DEF_CMAP[i+NTRANS].c_red = csat[cd];
		_FB_DEF_CMAP[i+NTRANS].c_green = csat[NTRANM1];
		_FB_DEF_CMAP[i+NTRANS].c_blue = csat[0];

		_FB_DEF_CMAP[i+(2*NTRANS)].c_red = csat[0];
		_FB_DEF_CMAP[i+(2*NTRANS)].c_green = csat[NTRANM1];
		_FB_DEF_CMAP[i+(2*NTRANS)].c_blue = csat[ci];

		_FB_DEF_CMAP[i+(3*NTRANS)].c_red = csat[0];
		_FB_DEF_CMAP[i+(3*NTRANS)].c_green = csat[cd];
		_FB_DEF_CMAP[i+(3*NTRANS)].c_blue = csat[NTRANM1];

		_FB_DEF_CMAP[i+(4*NTRANS)].c_red = csat[ci];
		_FB_DEF_CMAP[i+(4*NTRANS)].c_green = csat[0];
		_FB_DEF_CMAP[i+(4*NTRANS)].c_blue = csat[NTRANM1];

		_FB_DEF_CMAP[i+5*NTRANS].c_red = csat[NTRANM1];
		_FB_DEF_CMAP[i+5*NTRANS].c_green = csat[0];
		_FB_DEF_CMAP[i+5*NTRANS].c_blue = csat[cd];
	}
}

