	.file	"vgalow.s"
	.text
	.globl	_vga_clear_screen
	.align	8

VRAM_ADDRESS	= 0xf80a0000
VRAM_SIZE	= 64000

//	Usage for clear_screen is:
//	vga_clear_screen();
_vga_clear_screen:
	adds	-1, r0, r28
	mov	VRAM_SIZE/8 - 1, r29
	mov	VRAM_ADDRESS-8, r30
	bla	r28, r29, clrloop
	nop

clrloop:
	bla	r28, r29, clrloop
	fst.d	f0, 8(r30)++

	bri	r1
	nop

.globl	_vga_fill_screen

//	Usage for fill_screen is:
//	vga_fill_screen(8-bit_color);
_vga_fill_screen:
	mov	16, r30
	shl	r30, r16, r27
	adds	-1, r0, r28
	mov	VRAM_SIZE/4 - 1, r29
	mov	VRAM_ADDRESS-4, r30
	bla	r28, r29, fillloop
	nop

fillloop:
	st.l	r27, 4(r30)
	bla	r28, r29, fillloop
	adds	4, r30, r30

	bri	r1
	nop
