#include <stdio.h>
#include "../../vgalib/vga.h"

main(argc, argv)
char **argv;
{
	if(argc != 2){
		fprintf(stderr, "Usage: %s file\n", argv[0]);
		exit(1);
	}
	if(vga_init()){
		exit(1);
	}
printf("This is a test\n");
printf("call set_cmap\n");
	set_cmap();
printf("call screensave\n");
	savescreen(argv[1]);
printf("getc\n");
	getc(stdin);
printf("vgaterm\n");
	vga_term();
	exit(0);
}

static char reds[8] = {
	0, 9, 18, 28, 37, 46, 54, 63
};
static char greens[8] = {
	0, 9, 18, 28, 37, 46, 54, 63
};
static char blues[4] = {
	0, 21, 42, 63
};

struct cmap cmap[256];

set_cmap()
{
	register int r, g, b;
	register struct cmap *p;

	p = &(cmap[0]);
	for(r = 0; r < 8; r++){
		for(g = 0; g < 8; g++){
			for(b = 0; b < 4; b++, p++){
				p->c_red = reds[r];
				p->c_green = greens[g];
				p->c_blue = blues[b];
			}
		}
	}
printf("call new_colreg\n");
	new_colreg(&cmap[0], 256);
}

savescreen(f)
char *f;
{
	FILE *fp;

	if((fp = fopen(f, "rb")) == NULL){
		perror(f);
		return(-1);
	}
	if(fread(VRAM, 320, 200, fp) != 200)
		fprintf(stderr, "Could not read output file %s\n", f);
	fclose(fp);
	return(0);
}

