/* file: mirovdim.h
  	 Include file for Microsoft.C to acces the miroVDI.
  	 Adapted to Microsoft.C by miro-Datensysteme by Joerg Weselmanni
  	 You can chose that memory model you like most!
  	 Date: 20.07.88
*/


#define VECTOR  0x7E	/* default interrupt vector */

/* koordinate array structure for polygons and polylines ---------

   the array had to be of type:
     coord_array [number of coord.] [2]
   where
     coord_array [n] [0] is the X-coordinate
   and
     coord_array [n] [1] is the Y-coordinate.
     
-----------------------------------------------------------------*/

/*  Register communication structure  */

struct REG {
        short ax, bx, cx, dx, si, di, ds, es;
};

struct VLUT {
        short ax, idx;
        long col;
};

struct PTR {
        short ax, bx;
        short far *ptr;
};

union COMREG {
        struct REG r;
        struct VLUT v;
        struct PTR p;
};

/* miroVDI - String */
    char miroGRAPH[] = "miroGRAPH";
    
/* Initfeld struktur */

struct INITFELD {
        short kenn, base, clock, hc, hsy, hbp, vc, vsy, vbp,
        mode, xpix, ypix;
};

/* Inquire characteristics struktur */

struct INQUIRE {
        short xpix, ypix, xsize, ysize, midx, mrgb, kenn, ver;
        short xmem, ymem;
};

/* Pointerfeld Struktur */

struct PFELD {
        int far *fkt1;
        int far *fkt2;
        int far *fkt3;
        int far *fkt4;
        int far *fkt5;
};

struct COPY {
        short x, y, dx, dy;
};
               
union COMREG c;
int f;
int vector = VECTOR;

int testvdi ()
{
    /* test, if miroVDI already installed */
    char far *iv;
    long x =  0;
    int anz;
    int flag = 0xFFFF;
        
    x  =  (vector * 4);
    iv  = (char far *) x;
     
    if ( *((long far *) iv ) != 0) { /* vector already hooked ? */
        /* test for miroVDI */
        iv = (char far *) *((long far *)iv) - 9;

        /* iv points to begin of identification */
        for (anz = 0; anz <= 8; anz = anz + 1)
	{
            if ( *(char far *) ((long) iv + anz)  != miroGRAPH [anz])
            {
                anz = 9;  /* end loop */
                flag = 0;       /* set flag to not ok*/
            }
        }
        return (flag);
    }
    return (0);  /* return not OK */
}

int init_screen (ptr)
struct INITFELD far *ptr;
{
    c.r.ax = 0x00;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
    return (c.r.ax);
}
void inq_init (ptr)
struct INITFELD far *ptr;
{
        c.r.ax = 0x01;
        c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void save_init ()
{
    c.r.ax = 0x02;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void inq_char (ptr)
struct INQUIRE far *ptr;
{
        c.r.ax = 0x03;
        c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void set_color (idx, col)
short idx;
long col;
{
    c.r.ax = 0x04;
    c.v.idx = idx;
    c.v.col = col;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
long get_color (idx)
short idx;
{
    c.r.ax = 0x05;
    c.v.idx = idx;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
    return (c.v.col);
}
void save_vlut ()
{
    c.r.ax = 0x06;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void clear_screen (idx)
short idx;
{
    c.r.ax = 0x07;
    c.r.bx = idx;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void set_start (scr, x, y)
short scr,x,y;
{
    c.r.ax = 0x10;
    c.r.bx = scr;
    c.r.cx = x;
    c.r.dx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void set_width (scr, w)
short scr,w;
{
    c.r.ax = 0x11;
    c.r.bx = scr;
    c.r.cx = w;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void zoom (x, y)
short x,y;
{
    c.r.ax = 0x13;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void blink (bool)
short bool;
{
    c.r.ax = 0x14;
    c.r.bx = bool;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void def_org (x, y)
short x, y;
{
    c.r.ax = 0x20;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void clip_area (x0,y0,x1,y1)
short x0,y0,x1,y1;
{
    short area[4];
    
    area[0] = x0;
    area[1] = y0;
    area[2] = x1;
    area[3] = y1;
    c.r.ax = 0x21;
    c.p.ptr = (short far *)&area[0];
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void clip_mode (m)
short m;
{
    c.r.ax = 0x22;
    c.r.bx = m;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void col_mode (m)
short m;
{
    c.r.ax = 0x23;
    c.r.bx = m;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void draw_mode (m)
short m;
{
    c.r.ax = 0x24;
    c.r.bx = m;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void select_color (c0, c1)
short c0,c1;
{
    c.r.ax = 0x25;
    c.r.bx = c0;
    c.r.cx = c1;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void line_pat (pat)
short pat;
{
    c.r.ax = 0x26;
    c.r.bx = pat;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void move_abs (x, y)
short x,y;
{
    c.r.ax = 0x30;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void move_rel (x, y)
short x,y;
{
    c.r.ax = 0x31;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void dot ()
{
    c.r.ax = 0x32;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void line_abs (x,y)
short x,y;
{
    c.r.ax = 0x33;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void line_rel (x,y)
short x,y;
{
    c.r.ax = 0x34;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void pline_abs (n, ptr)
short n;
short far *ptr;
{
    c.r.ax = 0x35;
    c.r.bx = n;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void pline_rel (n, ptr)
short n;
short far *ptr;
{
    c.r.ax = 0x36;
    c.r.bx = n;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void pgon_abs (n, ptr)
short n;
short far *ptr;
{
    c.r.ax = 0x37;
    c.r.bx = n;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void pgon_rel (n, ptr)
short n;
short far *ptr;
{
    c.r.ax = 0x38;
    c.r.bx = n;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void rct_abs (x, y)
short x,y;
{
    c.r.ax = 0x39;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void rct_rel (x, y)
short x,y;
{
    c.r.ax = 0x3A;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void frct_abs (x, y)
short x,y;
{
    c.r.ax = 0x3B;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void frct_rel (x, y)
short x,y;
{
    c.r.ax = 0x3C;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void gcpy_abs (dir, ptr)
short dir;
struct COPY far *ptr;
{
    c.r.ax = 0x3E;
    c.r.bx = dir;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void circle (rad)
short rad;
{
    c.r.ax = 0x40;
    c.r.bx = rad;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void paint (e, edge)
short e,edge;
{
    c.r.ax = 0x41;
    c.r.bx = edge;
    c.r.cx = 0;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void write_pram (xsiz, ysiz, ptr)
short xsiz,ysiz;
short far *ptr;
{
    c.r.ax = 0x60;
    c.r.bx = xsiz | (ysiz << 8);
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void ptn_zoom (xzoom, yzoom)
short xzoom,yzoom;
{
    c.r.ax = 0x61;
    c.r.bx = xzoom;
    c.r.cx = yzoom;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void pattern (m,x,y)
short m,x,y;
{
    c.r.ax = 0x62;
    c.r.bx = m;
    c.r.cx = x;
    c.r.dx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void draw_char (dir, a)
short dir;
char a;
{
    c.r.ax = 0x70;
    c.r.bx = dir;
    c.r.cx = (short)a;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void set_rwp (x, y)
short x, y;
{
    c.r.ax = 0x80;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
short set_size (x, y)
short x, y;
{
    c.r.ax = 0x81;
    c.r.bx = x;
    c.r.cx = y;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
    return (c.r.bx);
}
void word_read (ptr)
short far *ptr;
{
    c.r.ax = 0x82;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void word_write (ptr)
short far *ptr;
{
    c.r.ax = 0x83;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
void word_copy (ptr)
struct COPY far *ptr;
{
    c.r.ax = 0x84;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
}
short test_error ()
{
    c.r.ax = 0x90;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
    return (c.r.ax);
}
short get_pointer (ptr)
struct PFELD far *ptr;
{
    c.r.ax = 0x91;
    c.p.ptr = (short far *)ptr;
    f = int86(vector, (union REGS *)&c, (union REGS *)&c);
    return (c.r.ax);
}
