@ECHO OFF
ECHO.
ECHO **************************************************************
ECHO *   OS/2 Grafik-Treiber Installation fr miro Grafikkarten   *
ECHO *   OS/2 Display Driver Installation for miro Video Boards   *
ECHO **************************************************************

rem --- check arguments ---
IF .%1. == .. GOTO USAGE
IF .%2. == .. GOTO USAGE

rem --- check dirs and files ---
IF NOT EXIST %1\BUNDLE         GOTO USAGE
IF NOT EXIST %1\TIMING         GOTO USAGE
IF NOT EXIST %1\TOOLS          GOTO USAGE
IF NOT EXIST %1\S3VIDEO        GOTO USAGE
IF NOT EXIST %1\S3WIN          GOTO USAGE
IF NOT EXIST %1\MIRO.DSP       GOTO USAGE
IF NOT EXIST %1\MIROVER.EXE    GOTO USAGE
IF NOT EXIST %2\OS2\INSTALL    GOTO USAGE
IF NOT EXIST %2\OS2\ATTRIB.EXE GOTO USAGE
IF NOT EXIST %2\OS2\UNPACK.EXE GOTO USAGE

ECHO.
ECHO **************************************************************
ECHO *  Bitte lesen Sie erst das README.DEU auf dieser Diskette.  *
ECHO *  Please, read the README.ENG file on this diskette first.  *
ECHO **************************************************************
ECHO Weiter mit beliebiger Taste oder Ctrl-C fr Abbruch...
ECHO Press any key to continue or Ctrl-C to break...
PAUSE 1>NUL 2>NUL

ECHO.
ECHO **************************************************************
ECHO *            Kopiere Dateien, bitte warten Sie ...           *
ECHO *            Copying files, please stand by ...              *
ECHO **************************************************************

rem --- backup original files ---
%2\OS2\ATTRIB -R %2\OS2\*.* /S 1>NUL 2>NUL
IF EXIST %2\OS2\SVGA.SAV GOTO NEXT1
COPY %2\OS2\SVGA.EXE %2\OS2\SVGA.SAV 1>NUL 2>NUL
:NEXT1
IF EXIST %2\OS2\MDOS\VSVGA.SAV GOTO NEXT2
COPY %2\OS2\MDOS\VSVGA.SYS %2\OS2\MDOS\VSVGA.SAV 1>NUL 2>NUL
:NEXT2
IF EXIST %2\OS2\SCREEN0?.SAV GOTO NEXT3
COPY %2\OS2\SCREEN0?.SYS %2\OS2\SCREEN0?.SAV 1>NUL 2>NUL
:NEXT3
IF EXIST %2\OS2\INSTALL\DSPINSTL.SAV GOTO NEXT4
COPY %2\OS2\INSTALL\DSPINSTL.EXE %2\OS2\INSTALL\DSPINSTL.SAV 1>NUL 2>NUL
:NEXT4
IF EXIST %2\OS2\INSTALL\RSPDSPI.SAV GOTO NEXT5
COPY %2\OS2\INSTALL\RSPDSPI.EXE %2\OS2\INSTALL\RSPDSPI.SAV 1>NUL 2>NUL
:NEXT5

rem --- unpack SCREEN01.SYS and new DSPINSTL icon from archive ---
%2\OS2\UNPACK2 %1\BUNDLE %2 1>NUL 2>NUL

rem --- unpack timing files from archive ---
%2\OS2\UNPACK2 %1\TIMING %2 1>NUL 2>NUL

rem --- copy windows install batch files ---
COPY %1\WINSETUP.CMD %2\OS2\INSTALL\WINSETUP.CMD 1>NUL 2>NUL
COPY %1\WINCLEAR.CMD %2\OS2\INSTALL\WINCLEAR.CMD 1>NUL 2>NUL

rem --- no patching for OS/2 2.11 and above ---
%1\mirover
IF ERRORLEVEL 2 GOTO DOICON
%2\OS2\UNPACK2 %1\TOOLS  %2 1>NUL 2>NUL

rem --- perform patch for OS/2 2.1 ---
%2\OS2\INSTALL\MKSYSLVL %2\OS2\INSTALL\SYSLEVEL.OS2 XR02110 1>NUL 2>NUL
%2\OS2\ATTRIB -R -S -H %2\OS2KRNL 1>NUL 2>NUL
%2\OS2\INSTALL\S3PATCH /NOP /NOS /Q %2\ %2\OS2\INSTALL\OS2KRNL.RTP 1>NUL 2>NUL
%2\OS2\ATTRIB +R +S +H %2\OS2KRNL 1>NUL 2>NUL
%2\OS2\INSTALL\S3PATCH /NOP /NOS /Q  %2\OS2\MDOS  %2\OS2\INSTALL\VWIN.RTP 1>NUL 2>NUL
DEL %2\OS2\INSTALL\MKSYSLVL.EXE 1>NUL 2>NUL
DEL %2\OS2\INSTALL\S3PATCH.EXE  1>NUL 2>NUL
DEL %2\OS2\INSTALL\OS2KRNL.RTP  1>NUL 2>NUL
DEL %2\OS2\INSTALL\VWIN.RTP     1>NUL 2>NUL

:DOICON
rem --- install dspinstl icon on desktop ---
%2\OS2\INSTALL\DDICO.EXE %2 1>NUL 2>NUL
DEL %2\OS2\INSTALL\DDICO.EXE 1>NUL 2>NUL

rem --- copy screen0?.sys to boot directory (OS/2 3.0) ---
COPY %2\OS2\SCREEN0?.SYS %2\OS2\BOOT\SCREEN0?.SYS 1>NUL 2>NUL

rem --- select card and monitor ---
SET OCTO=%2\OS2
%2\OS2\INSTALL\MIROMON2

ECHO.
ECHO **************************************************************
ECHO *  Fhren Sie einen Systemabschlu durch und                 *
ECHO *  folgen Sie den Anweisungen vom Handbuch bzw. README.DEU.  *
ECHO *  Perform a system Shut Down and                            *
ECHO *  follow the instructions inside the manual or README.ENG.  *
ECHO **************************************************************
ECHO.
GOTO END

:USAGE
ECHO.
ECHO Syntax: MIROINST [INSTALLDRIVE:] [BOOTDRIVE:]
ECHO.

:END

