/*
** Copyright (C) 1991, 1992 by
** Digital Equipment Corporation, Maynard, Mass.
**
** This software is furnished under a license and may be used and copied
** only  in  accordance  with  the  terms  of such  license and with the
** inclusion of the above copyright notice. This software or  any  other
** copies thereof may not be provided or otherwise made available to any
** other person. No title to and ownership of  the  software  is  hereby
** transferred.
**
** The information in this software is subject to change without  notice
** and  should  not be  construed  as  a commitment by Digital Equipment
** Corporation.
**
** Digital assumes no responsibility for the use or  reliability  of its
** software on equipment which is not supplied by Digital.
**
*/

#include "sys/types.h"                          
#include "config.h"
#include "sys/dce_space.h"

/*
** Enable/disable diagnostic messages. Allowed values are:
**    DCE_TRUE  - enable debug message
**    DCE_FALSE - disable debug message
*/
#define DCE_DEBUG      DCE_FALSE

/*
** For PCI machines - how to access the HW :
**   DCE_USE_PCI_BIOS        - Use the 32-bit protected mode PCI BIOS calls
**   DCE_USE_PCI_MECHANISM1  - Direct access to the HW, using PCI mechanism 1
**   DCE_USE_PCI_MECHANISM2  - Direct access to the HW, using PCI mechanism 2
**
**   NOTE : The default is to use the PCI BIOS calls (in 32-bit protected
**          mode). Some systems may not support these calls, in which case
**          there will be problems at boot time. If using a system that
**          does not support 32-bit protected mode PCI BIOS calls, direct
**          hardware accesses must be used.
**          DCE_USE_PCI_MECHANISM1 or DCE_USE_PCI_MECHANISM2 should be
**          selected depending on what the specific machine supports.
*/
#define DCE_HW_ACCESSES  DCE_USE_PCI_BIOS


/* 
** Highest vector number supported. Needed to allocate large enough array 
** Should NOT be modified
*/
#define DCE_MAX_VECTOR_NUMS            16

/* 
** Number of buffers pre-allocated on the receive list
*/
#define DCE_RX_BUFS_TO_POST            4

/* 
** EISA Slot ID value for DC21040 adapter 
*/
#define DCE_PLX_DC21040_EISA_ID_VAL    0x5042A310    

/* 
** EISA Slot ID value for DC21140 adapter 
*/
#define DCE_PLX_DC21140_EISA_ID_VAL     0x0430A310    

/* 
** PCI CFID value for DC21040 adapter 
*/
#define DCE_PCI_DC21040_CFID_VAL       0x00021011  /* 0002 - 21040 device ID
                                                   ** 1011 - DEC vendor ID
                                                   */

/* 
** PCI CFID value for DC21140 adapter 
*/
#define DCE_PCI_DC21140_CFID_VAL        0x00091011  /* 0009 - 1010 device ID
                                                   ** 1011 - DEC vendor ID
                                                   */


/* 
** PCI CFID value for DC21041 adapter 
*/
#define DCE_PCI_DC21041_CFID_VAL        0x00141011  /* 0014 - 1010 device ID
                                                   ** 1011 - DEC vendor ID
                                                   */

/* 
** # of packets queued to read queues before rx processing is disabled
** (used as a high-water mark to disable driver rx processing of
** packets from the adapter)
*/
#define DCE_RX_PKTS_QUEUED_THRESH_HI   16

/* 
** When less than this # of packets are queued to read queue then
** driver receive processing will be re-enabled if it was previously
** disabled.         
*/
#define DCE_RX_PKTS_QUEUED_THRESH_LO   8


/* 
** Maximum number of streams connected (opened) to each adapter .
** Revision 1 adapters are limited to 16. If the number defined here is
** greater than the limit supported by the adapter's revision, or greater
** than the maximum supported by the driver, the driver will use the minimum
** of all the limitations
*/
#define DCE_MAX_USRS                   16

/* 
** When enabled, frames sent by a user will be looped back to the user
** if the frame meets the perfect filter criteria for that user.
** Default is enable.
*/
#define DCE_UNIFORM_CARD_MODEL         DCE_TRUE

/* 
** SIA mode for DC21040 and DC21041 boards only! . Can have one of the 
** following values:
**     DCE_TP                          - twisted pair connection
**     DCE_BNC                         - BNC connection 
**     DCE_AUI                         - AUI connection 
**     DCE_TP_FULL_DUPLEX              - point to point full duplex twisted 
**                                       pair connection
**     DCE_TP_LINK_DISABLE             - Twisted pair connection with linkfail
**                                       test ignore & set polarity plus
**     DCE_AUTOSENSE                   - Automatic detection between TP BNC 
**                                       and AUI
**     DCE_DC2104X_DEFAULT_SERIAL_MODE - choose the value that was read from
**                                       the SROM if read, else choose the 
**                                       AUTOSENSE mode
** 
** Important Note!
** This definition is a global definition for all installed boards. 
** If you want to set a different mode for each board, please modify 
** the 'DC2104x_sia_mode' field in the appropriate part of the DCE_info
** structure below (the values to use are those listed above).
**
** It is NOT recommended to select DCE_AUTOSENSE (for DC2104x) to the 
** first station in the net that will boot.
*/
#define DCE_DC2104X_SIA_MODE_0        DCE_DC2104X_DEFAULT_SERIAL_MODE
#define DCE_DC2104X_SIA_MODE_1        DCE_DC2104X_DEFAULT_SERIAL_MODE
#define DCE_DC2104X_SIA_MODE_2        DCE_DC2104X_DEFAULT_SERIAL_MODE
#define DCE_DC2104X_SIA_MODE_3        DCE_DC2104X_DEFAULT_SERIAL_MODE

/* 
** Serial mode for DC21140 boards only! . Can have one of the following values:
**     DCE_TP                          - 10 MB/sec TP connection
**     DCE_BNC                         - 10 MB/sec BNC connection 
**     DCE_AUI                         - 10 MB/sec AUI connection 
**     DCE_TP_FULL_DUPLEX              - point to point full duplex, 10 MB/sec
**                                       TP connection
**     DCE_SYM_SCR                     - 100 MB/sec mode
**     DCE_SYM_SCR_FULL_DUPLEX         - point to point full duplex, 100 MB/sec
**                                       mode
**     DCE_DC21140_DEFAULT_SERIAL_MODE - choose the value that was read from
**                                       the SROM if read, else choose the 
**                                       DCE_100MB mode
** 
** NOTE : If user choose DCE_DC21140_DEFAULT_SERIAL_MODE and the
**        SROM was programmed to DCE_AUTOSENSE - the driver will work
**        in DCE_SYM_SCR mode, since there is no DCE_AUTOSENSE for DC21140
**
** Important Note!
** This definition is a global definition for all installed boards. 
** If you want to set a different mode for each board, please modify 
** the 'DC21140_serial_mode' field in the appropriate part of the DCE_info
** structure below (the values to use are those listed above).
*/
#define DCE_DC21140_SERIAL_MODE_0        DCE_DC21140_DEFAULT_SERIAL_MODE
#define DCE_DC21140_SERIAL_MODE_1        DCE_DC21140_DEFAULT_SERIAL_MODE
#define DCE_DC21140_SERIAL_MODE_2        DCE_DC21140_DEFAULT_SERIAL_MODE
#define DCE_DC21140_SERIAL_MODE_3        DCE_DC21140_DEFAULT_SERIAL_MODE

/*
** Selects internal bus arbitration between the receive and transmit
** processing. Allowed values:
**    DCE_TRUE  - round robin arbitration, equal sharing
**    DCE_FALSE - receive process has priority over the transmit process
**                (default)
*/
#define DCE_BUS_ARBITRATION   DCE_FALSE

/*
** Maximum number of longwords transferred in a DMA transaction.
** Allowed values are: 0, 1, 2, 4, 8, 16 (default), 32. Burst length of 0
** means the only limit is the amount of data stored.
** Burst length of 32 is not supported in 21040 Revision 1 boards.
**
** NOTE : In case the driver work on PCI machine with CDC chip (rev 3) or 
**        with CDC chip (rev 2) he initialize DC21040 burst length to 8 and 
**        ignore the value that was given by the user in space.c .
** NOTE : The driver DOESN'T inform the user that he ignored his value because
**        there is standard format to the init message in SCO-UNIX, to all 
**        drivers and the driver can't change this format by adding warning 
**        messages to the user. 
*/
#define DCE_BURST_LENGTH      16

/*
** Address boundary for data burst stop. Allowed values are:
**    DCE_CACHE_8
**    DCE_CACHE_16 (default)
**    DCE_CACHE_32
*/
#define DCE_CACHE_ALIGNMENT   DCE_CACHE_16

/*
** Enable/disable passing of bad frames (runt frames, truncated frames,
** collided frames) from the adapter to the driver.
**    DCE_TRUE  - enables passing of bad frames
**    DCE_FALSE - disable passingof bad frames (default)
*/
#define DCE_PASS_BAD_FRAMES   DCE_FALSE 

/*
** Backoff counter algorithm.
**    DCE_TRUE  - stop counter when any carrier activity is detected
**    DCE_FALSE - backoff counter is not affected by the carrier activity
**                (default)
*/
#define DCE_BACKOFF_CNTR      DCE_FALSE

/*
** Transmit FIFO threshold for starting packet transmission to line (those
** values are for 10MB mode).
** Allowed values are:
**    DCE_10MB_THRESHOLD_72
**    DCE_10MB_THRESHOLD_96 
**    DCE_10MB_THRESHOLD_128
**    DCE_10MB_THRESHOLD_160 (default)
*/
#define DCE_10MB_THRESHOLD         DCE_10MB_THRESHOLD_160

/*
** Enable/disable backpressure algorithm.
**    DCE_TRUE  - enable backpressure algorithm
**    DCE_FALSE - disable backpressure algorithm (default)
*/
#define DCE_BACK_PRESSURE     DCE_FALSE

/*
** Enable/disable capture effect algorithm.
**    DCE_TRUE  - enable capture effect algorithm
**    DCE_FALSE - disable capture effect algorithm (default)
*/
#define DCE_CAPTURE_EFFECT_ENABLE DCE_FALSE

/*
** Enable/disable parity checking on PCI bus
**    DCE_TRUE  - enable parity checking
**    DCE_FALSE - disable parity checking (default)
*/
#define DCE_PARITY_ERROR_RESPONSE DCE_FALSE

/*
** DC21040/DC21140/DC21041 PCI Latency Timer, in units of PCI bus clocks. 
** Default is 50h
**
** Note : If the user choose a value for the PCI Latency Timer that is < 50h
**        the driver change this value to 50h, since the driver works with
**        the minimum value - 50h.
*/
#define DCE_LATENCY_TIMER     0x50
/*
** Enable/Disable SW's CRC calculation (in transmit packets)
**    DCE_SW_CRC_ALWAYS - CRC will be calculated by the software for every 
**                        transmit packet longer than the thershold, for
**                        transmit packets shorter than the threshold the HW
**                        will calculate the CRC
**    DCE_SW_CRC_NEVER  - CRC will be calculated by the hardware for every 
**                        transmit packet 
*/
#define DCE_CRC_CALC          DCE_SW_CRC_ALWAYS

/* 
** The control and data values to be written to the general purpose DC21140
** register.
**    DCE_GPR_DEFAULT - the value that will be found in the SROM. If no value
**                      was found in the SROM the driver has its default
**                      values.
**    The user can set his values by setting DCE_DC21140_CTRL/DATA his/her
**    value.
*/
#define DCE_DC21140_GPR_CTRL  DCE_GPR_DEFAULT
#define DCE_DC21140_GPR_DATA  DCE_GPR_DEFAULT


/*
** This constant use to enable/disable PCI priority over EISA.
**
** DCE_TRUE  - PCI has priority over EISA
** DCE_FALSE - EISA has priority over PCI
**
*/

#define DCE_TURBO             DCE_TRUE



#ifdef DCE_3
#define DCE_MAX_BOARDS        4
#else
#ifdef DCE_2
#define DCE_MAX_BOARDS        3
#else
#ifdef DCE_1
#define DCE_MAX_BOARDS        2
#else
#ifdef DCE_0
#define DCE_MAX_BOARDS        1
#endif
#endif
#endif
#endif




DCE_board_config_t DCE_info[DCE_MAX_BOARDS] =
{
#ifdef DCE_0
   {
   0,                            /* board_num */
   "ethpci0",                       /* board_id */
   DCE_0_VECT,                   /* vector */
   DCE_0_SIOA,                   /* iobase */
   DCE_0_EIOA,                   /* ioend */
   DCE_0_SIOA,                   /* placeholder for cfgbase */
   DCE_PLX_DC21040_EISA_ID_VAL,  /* DC21040_probe_val*/            
   DCE_PLX_DC21140_EISA_ID_VAL,  /* DC21140_probe_val*/            
   DCE_PCI_DC21040_CFID_VAL,     /* DC21040_cfid_probe_val*/
   DCE_PCI_DC21140_CFID_VAL,     /* DC21140_cfid_probe_val*/
   DCE_PCI_DC21041_CFID_VAL,     /* DC21041_cfid_probe_val*/
#ifdef DCE_CMAJOR_0
   DCE_CMAJOR_0,                 /* major_num */
#else
   -1,
#endif
   DCE_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   DCE_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   DCE_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   DCE_UNIFORM_CARD_MODEL,       /* uniform_card_model */
   DCE_DC2104X_SIA_MODE_0,       /* DC2104x_sia_mode */
   DCE_DC21140_SERIAL_MODE_0,    /* DC21140_serial_mode */
   DCE_BUS_ARBITRATION,          /* bus_arbitration */
   DCE_BURST_LENGTH,             /* burst_length */
   DCE_CACHE_ALIGNMENT,          /* cache_alignment */
   DCE_PASS_BAD_FRAMES,          /* pass_bad_frames */
   DCE_BACKOFF_CNTR,             /* backoff_cntr */
   DCE_10MB_THRESHOLD,           /* threshold */
   DCE_BACK_PRESSURE,            /* back_pressure */
   DCE_CAPTURE_EFFECT_ENABLE,    /* capture effect enable */
   DCE_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   DCE_LATENCY_TIMER,            /* latency_timer */
   DCE_NULL_PCI_HANDLER,         /* pci handler place-holder */
   DCE_CRC_CALC,                 /* SW/HW CRC calculation */
   DCE_DC21140_GPR_CTRL,         /* DC21140's general purpose register control
                                    value */
   DCE_DC21140_GPR_DATA,         /* DC21140's general purpose register data
                                    value */
   DCE_TURBO                     /* Enable/disable PCI priority over EISA */
   }
#endif



#ifdef DCE_1
   ,{
   1,                            /* board_num */
   "ethpci1",                       /* board_id */
   DCE_1_VECT,                  /* vector */
   DCE_1_SIOA,                  /* iobase */
   DCE_1_EIOA,                  /* ioend */
   DCE_1_SIOA,                  /* placeholder for cfgbase */
   DCE_PLX_DC21040_EISA_ID_VAL,  /* DC21040_probe_val*/            
   DCE_PLX_DC21140_EISA_ID_VAL,  /* DC21140_probe_val*/            
   DCE_PCI_DC21040_CFID_VAL,     /* DC21040_cfid_probe_val*/
   DCE_PCI_DC21140_CFID_VAL,     /* DC21140_cfid_probe_val*/
   DCE_PCI_DC21041_CFID_VAL,     /* DC21041_cfid_probe_val*/
#ifdef DCE_CMAJOR_1
   DCE_CMAJOR_1,                 /* major_num */
#else
   -1,
#endif
   DCE_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   DCE_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   DCE_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   DCE_UNIFORM_CARD_MODEL,       /* uniform_card_model */
   DCE_DC2104X_SIA_MODE_1,       /* DC2104x_sia_mode */
   DCE_DC21140_SERIAL_MODE_1,    /* DC21140_serial_mode */
   DCE_BUS_ARBITRATION,          /* bus_arbitration */
   DCE_BURST_LENGTH,             /* burst_length */
   DCE_CACHE_ALIGNMENT,          /* cache_alignment */
   DCE_PASS_BAD_FRAMES,          /* pass_bad_frames */
   DCE_BACKOFF_CNTR,             /* backoff_cntr */
   DCE_10MB_THRESHOLD,           /* threshold */
   DCE_BACK_PRESSURE,            /* back_pressure */
   DCE_CAPTURE_EFFECT_ENABLE,    /* capture effect enable */
   DCE_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   DCE_LATENCY_TIMER,            /* latency_timer */
   DCE_NULL_PCI_HANDLER,         /* pci handler place-holder */
   DCE_CRC_CALC,                 /* SW/HW CRC calculation */
   DCE_DC21140_GPR_CTRL,         /* DC21140's general purpose register control
                                    value */
   DCE_DC21140_GPR_DATA,         /* DC21140's general purpose register data
                                    value */
   DCE_TURBO                     /* Enable/disable PCI priority over EISA */
   }
#endif



#ifdef DCE_2
   ,{
   2,                            /* board_num */
   "ethpci2",                       /* board_id */
   DCE_2_VECT,                  /* vector */
   DCE_2_SIOA,                  /* iobase */
   DCE_2_EIOA,                  /* ioend */
   DCE_2_SIOA,                  /* placeholder for cfgbase */
   DCE_PLX_DC21040_EISA_ID_VAL,  /* DC21040_probe_val*/            
   DCE_PLX_DC21140_EISA_ID_VAL,  /* DC21140_probe_val*/            
   DCE_PCI_DC21040_CFID_VAL,     /* DC21040_cfid_probe_val*/
   DCE_PCI_DC21140_CFID_VAL,     /* DC21140_cfid_probe_val*/
   DCE_PCI_DC21041_CFID_VAL,     /* DC21041_cfid_probe_val*/
#ifdef DCE_CMAJOR_2
   DCE_CMAJOR_2,                 /* major_num */
#else
   -1,
#endif
   DCE_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   DCE_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   DCE_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   DCE_UNIFORM_CARD_MODEL,       /* uniform_card_model */
   DCE_DC2104X_SIA_MODE_2,       /* DC2104x_sia_mode */
   DCE_DC21140_SERIAL_MODE_2,    /* DC21140_serial_mode */
   DCE_BUS_ARBITRATION,          /* bus_arbitration */
   DCE_BURST_LENGTH,             /* burst_length */
   DCE_CACHE_ALIGNMENT,          /* cache_alignment */
   DCE_PASS_BAD_FRAMES,          /* pass_bad_frames */
   DCE_BACKOFF_CNTR,             /* backoff_cntr */
   DCE_10MB_THRESHOLD,           /* threshold */
   DCE_BACK_PRESSURE,            /* back_pressure */
   DCE_CAPTURE_EFFECT_ENABLE,    /* capture effect enable */
   DCE_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   DCE_LATENCY_TIMER,            /* latency_timer */
   DCE_NULL_PCI_HANDLER,         /* pci handler place-holder */
   DCE_CRC_CALC,                 /* SW/HW CRC calculation */
   DCE_DC21140_GPR_CTRL,         /* DC21140's general purpose register control
                                    value */
   DCE_DC21140_GPR_DATA,         /* DC21140's general purpose register data
                                    value */
   DCE_TURBO                     /* Enable/disable PCI priority over EISA */
   }
#endif




#ifdef DCE_3
   ,{
   3,                            /* board_num */
   "ethpci3",                       /* board_id */
   DCE_3_VECT,                  /* vector */
   DCE_3_SIOA,                  /* iobase */
   DCE_3_EIOA,                  /* ioend */
   DCE_3_SIOA,                  /* placeholder for cfgbase */
   DCE_PLX_DC21040_EISA_ID_VAL,  /* DC21040_probe_val*/            
   DCE_PLX_DC21140_EISA_ID_VAL,  /* DC21140_probe_val*/            
   DCE_PCI_DC21040_CFID_VAL,     /* DC21040_cfid_probe_val*/
   DCE_PCI_DC21140_CFID_VAL,     /* DC21140_cfid_probe_val*/
   DCE_PCI_DC21041_CFID_VAL,     /* DC21041_cfid_probe_val*/
#ifdef DCE_CMAJOR_3
   DCE_CMAJOR_3,                 /* major_num */
#else
   -1,
#endif
   DCE_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   DCE_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   DCE_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   DCE_UNIFORM_CARD_MODEL,       /* uniform_card_model */
   DCE_DC2104X_SIA_MODE_3,       /* DC2104x_sia_mode */
   DCE_DC21140_SERIAL_MODE_3,    /* DC21140_serial_mode */
   DCE_BUS_ARBITRATION,          /* bus_arbitration */
   DCE_BURST_LENGTH,             /* burst_length */
   DCE_CACHE_ALIGNMENT,          /* cache_alignment */
   DCE_PASS_BAD_FRAMES,          /* pass_bad_frames */
   DCE_BACKOFF_CNTR,             /* backoff_cntr */
   DCE_10MB_THRESHOLD,           /* threshold */
   DCE_BACK_PRESSURE,            /* back_pressure */
   DCE_CAPTURE_EFFECT_ENABLE,    /* capture effect enable */
   DCE_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   DCE_LATENCY_TIMER,            /* latency_timer */
   DCE_NULL_PCI_HANDLER,         /* pci handler place-holder */
   DCE_CRC_CALC,                 /* SW/HW CRC calculation */
   DCE_DC21140_GPR_CTRL,         /* DC21140's general purpose register control
                                    value */
   DCE_DC21140_GPR_DATA,         /* DC21140's general purpose register data
                                    value */
   DCE_TURBO                     /* Enable/disable PCI priority over EISA */
   }
#endif

};


#ifndef TCP_0
   void *ifstats = (void *)0;
#endif


char            *DCE_vector_to_board[DCE_MAX_VECTOR_NUMS];
uint            DCE_hw_accesses = DCE_HW_ACCESSES;
unchar          DCE_debug      = DCE_DEBUG;
uint            DCE_max_boards = DCE_MAX_BOARDS;
uint            DCE_max_usrs   = DCE_MAX_USRS;
void            *DCE_Boards_table[DCE_MAX_BOARDS];

