PROJ = DVA
PROJFILE = DVA.MAK
DEBUG = 0

PWBRMAKE  = pwbrmake
NMAKEBSC1  = set
NMAKEBSC2  = nmake
LINKER  = link
ILINK  = ilink
LRF  = echo > NUL
BIND  = bind
RC  = rc
IMPLIB  = implib
LFLAGS_G  =   /BATCH /ALIGN:16
LFLAGS_D  =  /CO /NOF /NOP
LFLAGS_R  =  /NOF /NOP
MAPFILE_D  = NUL
MAPFILE_R  = NUL
CC  = cl
CFLAGS_G  = /AM /W2 /G2 /Gw /DWIN /DDOSMACHINE /Zp /BATCH
CFLAGS_D  = /Zi /Gi$(PROJ).mdt /Od /Gs /FPa
CFLAGS_R  = /Oe /Og /Os /Gs /FPa
LLIBS_R  =  /NOD:MLIBCA MLIBCAW
LLIBS_D  =  /NOD:MLIBCA MLIBCAW
LLIBS_G  = LIBW.LIB MICDLL.LIB
ASM  = masm
AFLAGS_G  = /Mx /T
AFLAGS_D  = /Zi

DEF_FILE  = DVA.DEF
OBJS  = DVA.obj DVAU.obj
RESS  = DVA.res
SBRS  = DVA.sbr DVAU.sbr

all: $(PROJ).exe

.SUFFIXES: .c .sbr .rc .res .obj .asm

DVA.obj : DVA.C DVA.h MICDLL.h

DVA.sbr : DVA.C DVA.h MICDLL.h

DVAU.obj : DVAU.C DVA.h MICDLL.h

DVAU.sbr : DVAU.C DVA.h MICDLL.h

DVA.res : DVA.RC DVA.h DVA.DLG


$(PROJ).bsc : $(SBRS)
        $(PWBRMAKE) @<<
$(BRFLAGS) $(SBRS)
<<

$(PROJ).exe : $(DEF_FILE) $(OBJS) $(RESS)
!IF $(DEBUG)
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
!IF $(DEBUG)
        $(LINKER) @$(PROJ).lrf
!ELSE
        $(LINKER) @$(PROJ).lrf
!ENDIF
        $(RC) $(RESS) $@


.c.sbr :
!IF $(DEBUG)
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_D) /FR$@ $<
!ELSE
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_R) /FR$@ $<
!ENDIF

.rc.res :
        $(RC) /r $<

.c.obj :
!IF $(DEBUG)
        $(CC) /c $(CFLAGS_G) $(CFLAGS_D) /Fo$@ $<
!ELSE
        $(CC) /c $(CFLAGS_G) $(CFLAGS_R) /Fo$@ $<
!ENDIF

.asm.obj :
!IF $(DEBUG)
        $(ASM) $(AFLAGS_G) $(AFLAGS_D) $<, $@;
!ELSE
        $(ASM) $(AFLAGS_G) $(AFLAGS_R) $<, $@;
!ENDIF


run: $(PROJ).exe
        WIN $(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
        WIN CVW $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
