@echo off
REM - Erzeugen von Installationsdisketten aus dem Inhalt der CD
REM - (c) 1998 by ELSA AG

REM - Kommandozeile parsen

:PARSE_START
if "%1%"=="" goto SYNTAX

:PARSE_P1
set McDestDisk=%1%

:PARSE_P2
set McOS=%2%
if "%McOS%"=="nt" set McOS=NT
if "%McOS%"=="Nt" set McOS=NT
if "%McOS%"=="nT" set McOS=NT

if "%McOS%"=="NT" goto P2_DONE
if not "%McOS%"=="95" goto SYNTAX
:P2_DONE

:PARSE_P3
if "%McOS%"=="NT" goto P3_DONE
set McLang=%3%
if "%McLang%"=="G" set McLang=g
if "%McLang%"=="E" set McLang=e
if "%McLang%"=="F" set McLang=f
if "%McLang%"=="I" set McLang=i

if "%McLang%"=="g" goto P3_DONE
if "%McLang%"=="e" goto P3_DONE
if "%McLang%"=="f" goto P3_DONE
if not "%McLang%"=="i" goto SYNTAX
:P3_DONE
:PARSE_DONE

set McState=0
set McRelPath=..
set McDriverPath=uni
goto STATEMAC


REM - Hilfe ausgeben

:SYNTAX
echo.
echo makedisk Destination OperatingSystem Language
echo.
echo   Destination     - destination drive (eg. a:)
echo   OperatingSystem - 95 for Windows 95 or Windows 98
echo                     NT for Windows NT
echo   Language        - only needed with Windows 95 and Windows 98
echo                     G for german
echo                     E for english
echo                     F for french
echo                     I for italian
echo.
goto ENDE


REM - Anlegen der Verzeichnisstruktur

:DIR_START
md %McDestDisk%\driver
md %McDestDisk%\driver\%McDriverPath%
md %McDestDisk%\driver\support

if "%McOS%"=="NT" goto DIR_NT
md %McDestDisk%\driver\%McDriverPath%\win95
md %McDestDisk%\driver\%McDriverPath%\win95\driver
md %McDestDisk%\driver\%McDriverPath%\win95\utils
md %McDestDisk%\driver\support\win95
md %McDestDisk%\driver\support\win95\acotec
md %McDestDisk%\driver\support\win95\acotec\css
md %McDestDisk%\driver\support\win95\elsa
md %McDestDisk%\driver\support\win95\ndiswan
md %McDestDisk%\driver\support\win95\ndiswan\ger
md %McDestDisk%\driver\support\win95\ndiswan\eng
md %McDestDisk%\driver\support\win95\ndiswan\fra
md %McDestDisk%\driver\support\win95\ndiswan\ita
md %McDestDisk%\driver\support\win95\wanmini
goto DIR_DONE

:DIR_NT
md %McDestDisk%\driver\%McDriverPath%\winnt
md %McDestDisk%\driver\%McDriverPath%\winnt\driver
md %McDestDisk%\driver\%McDriverPath%\winnt\utils
md %McDestDisk%\driver\support\winnt
md %McDestDisk%\driver\support\winnt\wanmini
:DIR_DONE
goto STATEMAC


REM - Kopieren der Treiber

:DRV_START
if "%McOS%"=="NT" goto DRV_NT
copy %McRelPath%\csseluni.inf %McDestDisk%
copy %McRelPath%\install.sup %McDestDisk%
copy %McRelPath%\driver\%McDriverPath%\win95\driver\*.* %McDestDisk%\driver\%McDriverPath%\win95\driver
copy %McRelPath%\driver\support\win95\acotec\css\*.* %McDestDisk%\driver\support\win95\acotec\css
copy %McRelPath%\driver\support\win95\elsa\*.* %McDestDisk%\driver\support\win95\elsa
copy %McRelPath%\driver\support\win95\wanmini\*.* %McDestDisk%\driver\support\win95\wanmini
if not "%McLang%"=="g" goto DRV_95_ENG
copy %McRelPath%\driver\support\win95\ndiswan\ger\*.exe %McDestDisk%\driver\support\win95\ndiswan\ger
goto DRV_DONE
:DRV_95_ENG
if not "%McLang%"=="e" goto DRV_95_FRA
copy %McRelPath%\driver\support\win95\ndiswan\eng\*.exe %McDestDisk%\driver\support\win95\ndiswan\eng
goto DRV_DONE
:DRV_95_FRA
if not "%McLang%"=="f" goto DRV_95_ITA
copy %McRelPath%\driver\support\win95\ndiswan\fra\*.exe %McDestDisk%\driver\support\win95\ndiswan\fra
goto DRV_DONE
:DRV_95_ITA
copy %McRelPath%\driver\support\win95\ndiswan\ita\*.exe %McDestDisk%\driver\support\win95\ndiswan\ita
goto DRV_DONE

:DRV_NT
copy %McRelPath%\driver\%McDriverPath%\winnt\*.* %McDestDisk%\driver\%McDriverPath%\winnt
copy %McRelPath%\driver\%McDriverPath%\winnt\driver\*.* %McDestDisk%\driver\%McDriverPath%\winnt\driver
copy %McRelPath%\driver\setup.cm_ %McDestDisk%\setup.cmd
:DRV_DONE
goto STATEMAC


REM - Kopieren der Utilities

:UTL_START
copy %McRelPath%\setup*.* %McDestDisk%
copy %McRelPath%\driver\setup.in_ %McDestDisk%\setup.inf
copy %McRelPath%\cfgmgr32.dll %McDestDisk%
copy %McRelPath%\elsa.hlp %McDestDisk%

if "%McOS%"=="NT" goto UTL_NT
copy %McRelPath%\driver\%McDriverPath%\win95\utils\*.* %McDestDisk%\driver\%McDriverPath%\win95\utils
goto  UTL_DONE

:UTL_NT
copy %McRelPath%\driver\%McDriverPath%\winnt\utils\*.* %McDestDisk%\driver\%McDriverPath%\winnt\utils
copy %McRelPath%\driver\support\winnt\wanmini\*.* %McDestDisk%\driver\support\winnt\wanmini
copy %McRelPath%\driver\setup.cm_ %McDestDisk%\setup.cmd
:UTL_DONE
goto STATEMAC


REM - Statusmaschine

:STATEMAC
if not "%McState%"=="0" goto STATE1
echo.
echo Please insert an empty disk in drive %McDestDisk%
echo Label the Disk "Driver Disk"
echo.
pause
set McState=1
goto DIR_START

:STATE1
if not "%McState%"=="1" goto STATE2
set McState=2
goto DRV_START

:STATE2
if not "%McState%"=="2" goto STATE3
echo.
echo Please insert an empty disk in drive %McDestDisk%
echo Label the Disk "Utilities Disk"
echo.
pause
set McState=3
goto DIR_START

:STATE3
if not "%McState%"=="3" goto STATE4
set McState=4
goto UTL_START

:STATE4


REM - Aufraeumen

:ENDE
set McDestDisk=
set McOS=
set McLang=
set McState=
set McRelPath=
set McDriverPath=

