
version "CFGMGR 1.00","Deutsch"

section "Allgemein"

group_logo 0

readonly_text 001
    description "Gert"
    short_help "Der Produktname des Gerts."

readonly_text 002
    description "Version"
    short_help "Die Firmware Version des Gerts."

readonly_text 003
    description "Datum"
    short_help "Das Erstellungsdatum der Firmware."

readonly_text 600
    description "Firmwaretyp"
    short_help "Die Bedeutung des Firmwaretyp."
    item_text "MX - Multilink X.75 (ELSA)", "MP - Multilink PPP"
    item_value "X", "P"

group_end

group "Lnderauswahl"

selection_list 502
  description "Land"
  short_help "Whlen Sie bitte das Land aus, indem Sie sich befinden. Mit dieser Einstellung konfigurieren Sie das Line-Interface des Modems."
  item_text  "Belgien","Dnemark","Deutschland","Finnland","Frankreich","Grobritannien","Italien","Liechtenstein","Luxemburg","Monaco","Niederlande","Norwegen","sterreich","Portugal","Schweden","Schweiz","Spanien","USA"
  item_value  "0F","31","04","3C","3D","B4","59","68","69","74","7B","82","0A","8B","A5","A6","A0","B5"

selection_list 800
  description "Land"
  short_help "Whlen Sie bitte das Land aus, indem Sie sich befinden. Mit dieser Einstellung konfigurieren Sie das Line-Interface des Modems."
  item_text   "Belgien","Dnemark","Finland","Frankreich","Deutschland","Niederlande","Italien","Norwegen","Spanien","Schweden","Schweiz","Grobritannien","sterreich","Portugal","Irland"
  item_value  "02","03","04","05","06","07","08","0A","0B","0C","0D","0E","0F","18","1A"

selection_list 540
  description "Land"
  short_help "Whlen Sie bitte das Land aus, indem Sie sich befinden. Mit dieser Einstellung konfigurieren Sie das Line-Interface des Modems."
  item_text  "Belgien","Dnemark","Deutschland","Finnland","Frankreich","Grobritannien","Irland","Italien","Niederlande","Norwegen","sterreich","Portugal","Schweden","Schweiz","Spanien","USA"
  item_value "002",    "003",  "006",        "004",     "005",       "016",           "007",   "008",    "010",        "011",     "001",       "012",     "014",     "015",    "013",    "022"

group_end

group "Interne Uhr des Gerts"

entryfield_text 500
  description "Uhrzeit"
  short_help "Die Uhrzeit des Gerts."
  time_format "%h,%m,%s"

entryfield_text 501
  description "Datum"
  short_help "Das Datum des Gerts."
  date_format "%y,%m,%d"

group_end

group "D-Kanal Protokoll"

selection_list 004
  description "Protokoll"
  short_help "Stellen Sie hier das gewnschte D-Kanal Protokoll ein."
  item_text  "Automatisch","Euro DSS1","DSS1 Punkt zu Punkt","Nationales 1TR6","Japanisches Protocol: INS64"
  item_value "AUTO", "DSS1","DSS1PP","1TR6","INS64"

selection_list 150
  description "Protokoll"
  short_help "Stellen Sie hier das gewnschte D-Kanal Protokoll ein."
  item_text "Euro DSS1","National 1TR6"
  item_value "DSS1", "1TR6"

group "Lndereinstellung der a/b Ports"

selection_list 700
  description "Land"
  short_help "Whlen Sie bitte das Land aus, indem Sie sich befinden. Mit dieser Einstellung konfigurieren Sie das Line-Interface der a/b Ports."
  item_text "Nordamerika", "Griechenland","Niederlande","Belgien","Frankreich","Spanien","Italien","Schweiz","Oesterreich","Grossbritanien","Daenemark","Schweden","Norwegen","Deutschland","Japan","Tuerkei","Portugal","Luxemburg","Irland","Zypern","Finnland"
  item_value "1","30","31","32","33","34","39","41","43","44","45","46","47","49","81","90","351","352","353","357","358"

group "Rufannahme"

onoff_switch 300
  description "Rufannahme an ISDN-Adapter sperren"
  short_help "Hiermit legen Sie fest, da der ISDN Datenport keine Rufe annimmt."
  value_list  "1", "0"

onoff_switch 301
  description "Rufannahme an a/b Port 1 sperren."
  short_help "Hiermit legen Sie fest, da der a/b Port 1 keine Rufe annimmt."
  value_list  "1", "0"

onoff_switch 302
  description "Rufannahme an a/b Port 2 sperren."
  short_help "Hiermit legen Sie fest, da der a/b Port 2 keine Rufe annimmt."
  value_list  "1", "0"

section "Anrufbeantworter + Fax"

group "Anrufbeantworter"

onoff_switch 506
  description "Anrufbeantworter eingeschaltet"
  short_help "Hiermit legen Sie fest, ob Sie Telefonanrufe entgegennehmen wollen."

onoff_switch 518
  description "Whrend der Aufnahme Lautsprecher einschalten"
  short_help "Wenn diese Option eingeschaltet ist, knnen Sie Anrufe, die von dem Anrufbeantworter aufgenommen werden, mithren."

onoff_switch 515
  description "Nur Ansagetext abspielen, keine Nachrichten aufnehmen"
  short_help "Hiermit legen Sie fest, da nur die Ansage des Anrufbeantworters abgespielt wird. Es knnen keine Nachrichten auf dem Anrufbeantworter hinterlassen werden."
  value_list  "1", "0"

onoff_switch 519
  description "Mithren oder Mitschneiden von Telefonaten verbieten"
  short_help "Schalten Sie diese Option ein, wenn Sie nicht mchten, da Telefonate am Anrufbeantworter mitgeschnitten werden knnen."
  value_list  "1","0"

selection_list 503
  description "Rufe annehmen"
  short_help  "Hiermit legen Sie fest, nach welcher Zeit Telefonanrufe angenommen werden."
  item_text   "nach 2x klingeln","nach 3x klingeln","nach 4x klingeln","nach 5x klingeln","nach 6x klingeln","nach 7x klingeln","nach 8x klingeln","nach 9x klingeln"
  item_value  "2","3","4","5","6","7","8","9"

group_end

group "Fax-Anrufe"

onoff_switch 505
  description "Fax-Annahme eingeschaltet"
  short_help "Hiermit legen Sie fest, ob Sie Fax-Anrufe entgegennehmen wollen."

onoff_switch 508
  description "Fax-bernahme whrend eines Telefonat erlauben"
  short_help "Hiermit legen Sie fest, da ein ankomendes Fax auch whrend eines Telefonats erkannt werden kann."

entryfield_text 507
  description "Fax-Identifikation"
  short_help "Geben Sie hier eine Fax-Identifikation ein, diese kann z.B. Ihr Name oder Ihre Telefonnummer sein."
  max_len 20
  add_to_charset " #"
  convert_to_upper 1

group_end

onoff_switch 504
  description "Rufe annehmen, auch wenn der Speicher voll ist"
  value_list  "0","1"
  short_help "Hiermit legen Sie fest, da das Modem auch Anrufe entgegennimmt wenn der Speicher voll ist."

onoff_switch 530
  description "Modem klingelt bei einkommendem Ruf"
  short_help "Hiermit legen Sie fest, da das Modem klingelt, wenn Sie angerufen werden."

section "ISDN-Adapter"

group "Rufnummern (bei DSS1)"

entryfield_numbers 005
  description "Eigene Rufnummer"
  short_help "Geben Sie hier die MSN fr abgehende Rufe ein."
  max_len 16

entryfield_numbers 007
  description "Rufe annehmen auf"
  short_help "Geben Sie hier die erste MSN ein, auf die bei ankommenden Rufen reagiert werden soll."
  max_len 16

entryfield_numbers 008
  description "Rufe annehmen auf"
  short_help "Geben Sie hier die zweite MSN ein, auf die bei ankommenden Rufen reagiert werden soll."
  max_len 16

entryfield_numbers 009
  description "Rufe annehmen auf"
  short_help "Geben Sie hier die dritte MSN ein, auf die bei ankommenden Rufen reagiert werden soll."
  max_len 16

group "Rufnummern (bei 1TR6)"

entryfield_numeric 011
  description "Endgerteziffer"
  short_help "Geben Sie hier die EAZ ein, auf die das Gert bei ankommenden Rufen reagieren soll."
  range_min 0
  range_max 19

group "Extras"

readonly_text 170
    description "Summe der Einheiten"
    short_help "Zeigt die Summe aller Einheiten des ISDN Datenports an."

readonly_text 171
    description "Letzte Verbindung"
    short_help "Zeigt die Einheiten des ISDN Datenports, von der letzten Verbindung an."
    invisible 1

onoff_switch 180
    description "Einheitenzhler lschen"
     short_help "Setzt die Einheiten des ISDN Datenports zurck."

onoff_switch 006
  description "bermittlung der eigenen Rufnummer unterdrcken"
  short_help "Schalten Sie diese Option ein, damit die MSN bei abgehenden Rufen nicht bermittelt wird."
  value_list "1", "0"

group_end

selection_list 016
  description "Eigenes Dienstmerkmal"
  short_help  "Whlen Sie hier das Dienstmerkmal fr abgehende Verbindungen"
  item_text   "Fernspechen 3.1 kHz", "Fernsprechen analog", "Fax Gruppe 2", "Fax Gruppe 3"
  invisible 1

onoff_switch 012
  description "Fernsprechdienst 3.1 khz annehmen"
  short_help "Whlen Sie hier, ob Fernsprechdienste (3.1 khz) angenommen werden sollen."
  invisible 1

onoff_switch 013
  description "Fernsprechen analog annehmen"
  short_help "Whlen Sie hier, ob Fernsprechdienste (analog) angenommen werden sollen."
  invisible 1

onoff_switch 014
  description "Faxbetrieb Gruppe 2 annehmen"
  short_help "Whlen Sie hier, ob Faxe (Gruppe 2) angenommen werden sollen."
  invisible 1

onoff_switch 015
  description "Faxbetrieb Gruppe 3 annehmen"
  short_help "Whlen Sie hier, ob Faxe (Gruppe 3) angenommen werden sollen."
  invisible 1

section "a/b Port 1"

group "Rufnummern (bei DSS1)"

entryfield_text 020
  description "Eigene Rufnummer"
  short_help "Geben Sie hier die MSN fr abgehende Rufe ein."
  max_len 16

entryfield_text 022
  description "Rufe annehmen auf"
  short_help "Geben Sie hier die erste MSN ein, auf die bei ankommenden Rufen reagiert werden soll."
  max_len 16

entryfield_text 023
  description "Rufe annehmen auf"
  short_help "Geben Sie hier die zweite MSN ein, auf die bei ankommenden Rufen reagiert werden soll."
  max_len 16

entryfield_text 024
  description "Rufe annehmen auf"
  short_help "Geben Sie hier die dritte MSN ein, auf die bei ankommenden Rufen reagiert werden soll."
  max_len 16

group "Rufnummern (bei 1TR6)"

entryfield_text 025
  description "Endgerteziffer"
  short_help "Geben Sie hier die EAZ ein, auf die das Gert bei ankommenden Rufen reagieren soll."
  max_len 2

group "Amtsholung"

onoff_switch 701
    description "Durch Abheben des Hrers"
    short_help "Wenn diese Option ausgewhlt ist, dann hren Sie nach Abheben des Hrers das Freizeichen Ihres Amts oder Ihrer Telefonanlage. Sie knnen externe Gesprche fhren.\r\rUm nun intern telefonieren zu knnen, bettigen Sie die Flash-Taste."

onoff_switch 702
    description "Durch Drcken der Flash-Taste"
    short_help "Wenn diese Option ausgewhlt ist, dann hren Sie nach Drcken der Flash-Taste das Freizeichen Ihres Amts oder Ihrer Telefonanlage. Sie knnen externe Gesprche fhren.\r\rIst die Option 'Amtsholung durch Abheben des Hrers' eingeschaltet, so ist keine interne Telefonie mglich!"

group "Dienstmerkmale"

selection_list 027
  description "Eigenes Dienstmerkmal"
  short_help  "Whlen Sie hier das Dienstmerkmal fr abgehende Verbindungen"
  item_text   "Fernspechen 3.1 kHz", "Fernsprechen analog", "Fax Gruppe 2", "Fax Gruppe 3"

onoff_switch 028
  description "Fernsprechdienst 3.1 khz annehmen"
  short_help "Whlen Sie hier, ob Fernsprechdienste (3.1 khz) angenommen werden sollen."
  invisible 1

onoff_switch 029
  description "Fernsprechen analog annehmen"
  short_help "Whlen Sie hier, ob Fernsprechdienste (analog) angenommen werden sollen."
  invisible 1

onoff_switch 030
  description "Faxbetrieb Gruppe 2 annehmen"
  short_help "Whlen Sie hier, ob Faxe (Gruppe 2) angenommen werden sollen."
  invisible 1

onoff_switch 031
  description "Faxbetrieb Gruppe 3 annehmen"
  short_help "Whlen Sie hier, ob Faxe (Gruppe 3) angenommen werden sollen."
  invisible 1

section "a/b Port 2"

group "Rufnummern (bei DSS1)"

entryfield_text 032
  description "Eigene Rufnummer"
  short_help "Geben Sie hier die MSN fr abgehende Rufe ein."
  max_len 16

entryfield_text 034
  description "Rufe annehmen auf"
  short_help "Geben Sie hier die erste MSN ein, auf die bei ankommenden Rufen reagiert werden soll."
  max_len 16

entryfield_text 035
  description "Rufe annehmen auf"
  short_help "Geben Sie hier die zweite MSN ein, auf die bei ankommenden Rufen reagiert werden soll."
  max_len 16

entryfield_text 036
  description "Rufe annehmen auf"
  short_help "Geben Sie hier die dritte MSN ein, auf die bei ankommenden Rufen reagiert werden soll."
  max_len 16

group "Rufnummern (bei 1TR6)"

entryfield_text 037
  description "Endgerteziffer"
  short_help "Geben Sie hier die EAZ ein, auf die das Gert bei ankommenden Rufen reagieren soll."
  max_len 2

group "Amtsholung"

onoff_switch 703
    description "Durch Abheben des Hrers"
short_help "Wenn diese Option ausgewhlt ist, dann hren Sie nach Abheben des Hrers das Freizeichen Ihres Amts oder Ihrer Telefonanlage. Sie knnen externe Gesprche fhren.\r\rUm nun intern telefonieren zu knnen, bettigen Sie die Flash-Taste."

onoff_switch 704
    description "Durch Drcken der Flash-Taste"
    short_help "Wenn diese Option ausgewhlt ist, dann hren Sie nach drcken der Flash-Taste das Freizeichen Ihres Amts oder Ihrer Telefonanlage. Sie knnen externe Gesprche fhren.\r\rIst die Option 'Amtsholung durch abheben des Hrers' eingeschaltet, so ist keine interne Telefonie mglich!"

group "Dienstmerkmale"

selection_list 039
  description "Eigenes Dienstmerkmal"
  short_help  "Whlen Sie hier das Dienstmerkmal fr abgehende Verbindungen"
  item_text   "Fernspechen 3.1 kHz", "Fernsprechen analog", "Fax Gruppe 2", "Fax Gruppe 3"

onoff_switch 040
  description "Fernsprechdienst 3.1 khz annehmen"
  short_help "Whlen Sie hier, ob Fernsprechdienste (3.1 khz) angenommen werden sollen."
  invisible 1

onoff_switch 041
  description "Fernsprechen analog annehmen"
  short_help "Whlen Sie hier, ob Fernsprechdienste (3.1 khz) angenommen werden sollen."
  invisible 1

onoff_switch 042
  description "Faxbetrieb Gruppe 2 annehmen"
  short_help "Whlen Sie hier, ob Faxe (Gruppe 2) angenommen werden sollen."
  invisible 1

onoff_switch 043
  description "Faxbetrieb Gruppe 3 annehmen"
  short_help "Whlen Sie hier, ob Faxe (Gruppe 3) angenommen werden sollen."
  invisible 1

section "Konfiguration"

group "Fernabfrage"

onoff_switch 516
  description "Fernabfrage erlauben"
  short_help "Wenn Sie die Fernabfrage erlauben, knnen Sie das Modem via Telefon mit DTMF-Tnen abfragen."

onoff_switch 517
  description "Fernkonfiguration erlauben"
  short_help "Wenn Sie die Fernkonfiguration erlauben, knnen Sie das Modem via Telefon mit DTMF-Tnen konfigurieren."

entryfield_numbers 510
  description "Passwort"
  short_help "Geben Sie hier das Passwort fr die Fernabfrage ein."
  max_len 4
  fill 1

group_end

group "Konfiguration ber nachgeschalteten Handapparat"

onoff_switch 522
  description "Zugang durch Drcken der Gabel des Telefons"
  short_help "Wenn Sie diese Zugangsart erlauben, knnen Sie das Gert mit dem nachgeschalteten Handappart konfigurieren und abfragen, indem Sie kurz auf die Gabel des Gerts drcken."
  value_list  "1","0"

onoff_switch 523
  description "Zugang durch Senden von DTMF-Tnen"
  short_help "Wenn Sie diese Zugangsart erlauben, knnen Sie das Gert mit dem nachgeschalteten Handappart konfigurieren und abfragen, indem Sie das Gert mit DTMF-Tnen ansprechen."
group_end

group "Anrufbeantworter"

slider 532
  description "Wiedergabelautstke"
  short_help "Stellen Sie hier ein, mit welcher Lautstrke aufgezeichnete Anrufe wiedergegeben werden."
  range_min 0
  range_max 255
  step 128
  unit "Leise", "Mittel", "Laut"

slider 531
  description "Aufnahmelautstke"
  short_help "Stellen Sie hier ein, mit welcher Lautstrke Anrufe aufgezeichnet werden sollen."
  range_min 0
  range_max 255
  step 128
  unit "Leise", "Mittel", "Laut"

group "Freisprechmodus"

slider 534
  description "Wiedergabelautstke"
  short_help "Stellen Sie die Wiedergabelautstke so ein, so da es keine Rckkopplungen gibt."
  range_min 0
  range_max 255
  step 128
  unit "Leise", "Mittel", "Laut"

slider 533
  description "Mikro-Empfindlichkeit"
  short_help "Stellen Sie hier die Mikro-Empfindlichkeit fr das Freisprechen ein."
  range_min 0
  range_max 255
  step 128
  unit "Leise", "Mittel", "Laut"

section "Extras"

group "Sprachaufnahme"

selection_list 511
  description "Aufnahmequalitt"
  short_help "Whlen Sie hier die Aufnahmequalitt."
  item_text "Niedrige Qualitt","Normale Qualitt","Hohe Qualitt"
  item_value "ADPCM2-7","ADPCM4-7","PCM8L-7"

selection_list 509
  description "Maximale Aufnahmedauer"
  short_help "Whlen Sie hier die maximale Aufnahmedauer."
  item_text "unbegrenzt","15 sec.","30 sec.","45 sec.","60 sec.","75 sec.","90 sec.","105 sec.","120 sec.","135 sec."
  item_value "0","1","2","3","4","5","6","7","8","9"

selection_list 521
  description "Minimale Aufnahmedauer"
  short_help "Whlen Sie hier die minimale Aufnahmedauer."
  item_text " ", "1 sec.","2 sec.","3 sec.","4 sec.","5 sec.","6 sec.","7 sec.","8 sec.","9 sec.","10 sec.","11 sec.","12 sec.","13 sec.","14 sec."
  item_value "0","1","2","3","4","5","6","7","8","9","10","11","12","13","14"

group_end

group "Sprachausgabe"

onoff_switch 512
  description "Meldungen vom System ansagen"
  short_help "Whlen Sie hier, ob das Gert Systemmeldungen ansagen soll."

onoff_switch 513
  description "Nummer des Anrufers ansagen (Caller ID)"
  short_help "Whlen Sie hier, ob das Gert die Nummer des Anrufers (CLIP) ansagen soll."

onoff_switch 514
  description "Uhrzeit von Nachrichten ansagen"
  short_help "Whlen Sie hier, ob das Gert die Uhrzeit von Nachrichten ansagen soll."

selection_list 520
  description "Ansagetext"
  short_help "Whlen Sie hier die Ansagetexte aus."
  item_text "Nr.1","Nr.2","Nr.3","Speicher voll"
  item_value "0","1","2","255"

group_end

group "Kompatibilitt"

onoff_switch 524

  description "Anrufbeantworter auch dann aktivieren, wenn das Modem von einer Anwendung benutzt wird."
  short_help "Manche Anwendungen geben das Modem nicht richtig frei, auch wenn es nicht mehr bentigt wird.\r\rUm in einem solchen Fall denoch die Anrufbeantworter-Funktion benutzen zu knnen, aktivieren Sie diesen Schalter.\r\rWeitere Informationen zu diesem Thema entnehmen Sie bitte Ihrem Handbuch."

group_end

onoff_switch 110
  description "Anklopfen auf a/b Port 0 erlauben"
  short_help "Disable or enable the knocking facility on a/b port 1."
  invisible 1

onoff_switch 101
  description "Verbinden ohne Wahl an ISDN-Adapter"
  short_help "."
  invisible 1

entryfield_text 100
  description "Nummer fr ISDN-Port"
  short_help "."
  invisible 1

group "a/b-Port 1"

readonly_text 172
    description "Summe aller Einheiten"
    short_help "Zeigt die Summe aller Einheiten an."

readonly_text 173
    description "Letztes Gesprch"
    short_help "Zeigt die Einheiten der letzten Verbindung an."

onoff_switch 181
    description "Einheitenzhler lschen"
    short_help "Beim nchsten Schlieen des Dialogs mit 'OK' wird der Einheitenzhler auf Null gesetzt."

onoff_switch 111
  description "Anruf whrend Gesprch durch Anklopfton signalisieren"
  short_help "Hiermit legen Sie fest, ob das Anklopfen ein- oder ausgeschaltet wird."

onoff_switch 021
  description "bermittlung der eigenen Rufnummer unterdrcken"
  short_help "Schalten Sie diese Option ein, damit die MSN bei abgehenden Rufen nicht bermittelt wird."
  value_list "1", "0"

onoff_switch 103
  description "Rufnummer bei Abheben des Hrers automatisch whlen:"
  short_help "Hiermit legen Sie fest, ob Verbinden ohne Wahl ein- oder ausgeschaltet wird."

entryfield_numbers 102
  description "Direktruf-Nummer"
  short_help "Geben Sie hier die MSN an, die direkt nach Abnahme des Hrers gewhlt werden soll."

group "a/b-Port 2"

readonly_text 174
   description "Summe aller Einheiten"
    short_help "Zeigt die Summe aller Einheiten an."

readonly_text 175
    description "Letztes Gesprch"
    short_help "Zeigt die Einheiten der letzten Verbindung an."

onoff_switch 182
    description "Einheitenzhler lschen"
    short_help "Beim nchsten Schlieen des Dialogs mit 'OK' wird der Einheitenzhler auf Null gesetzt."

onoff_switch 112
  description "Anruf whrend Gesprch durch Anklopfton signalisieren"
  short_help "Hiermit legen Sie fest, ob das Anklopfen ein- oder ausgeschaltet wird."

onoff_switch 033
  description "bermittlung der eigenen Rufnummer unterdrcken"
  short_help "Schalten Sie diese Option ein, damit die MSN bei abgehenden Rufen nicht bermittelt wird."
  value_list "1", "0"

onoff_switch 105
  description "Rufnummer bei Abheben des Hrers automatisch whlen:"
  short_help "Hiermit legen Sie fest, ob Verbinden ohne Wahl ein- oder ausgeschaltet wird."

entryfield_numbers 104
  description "Direktruf-Nummer"
  short_help "Geben Sie hier die MSN an, die direkt nach Abnahme des Hrers gewhlt werden soll."

version "CFGMGR 1.00","English"

section "General"

group_logo 0

readonly_text 001
    description "Device"
    short_help "The product name of this device."

readonly_text 002
    description "Version"
    short_help "The device's firmware version"

readonly_text 003
    description "Date"
    short_help "The firmware creation date"

readonly_text 999
    description "Release"
    short_help "The release version number"

readonly_text 600
    description "Firmwaretype"
    short_help "The meaning of the firmwaretype."
    item_text "MX - Multilink X.75 (ELSA)", "MP - Multilink PPP"
    item_value "X", "P"

group_end

group "Line Interface"

selection_list 502
  description "Country"
  short_help "Select your country in which you are located. This setting will be used to configure the line interface of the modem."
  item_text  "Austria","Belgium","Denmark","Finland","France","Germany","Italy","Liechtenstein","Luxemburg","Monaco","Netherlands","Norway","Portugal","Sweden","Switzerland","Spain","United Kingdom","USA"
  item_value "0A","0F","31","3C","3D","04","59","68","69","74","7B","82","8B","A5","A6","A0","B4","B5"

selection_list 800
  description "Country"
  short_help "Select your country in which you are located. This setting will be used to configure the line interface of the modem."
  item_text   "Belgium","Denmark","Finland","France","Germany","Netherlands","Italy","Norway","Spain","Schweden","Swiss","United Kingdom","Austria","Portugal","Ireland"
  item_value  "02","03","04","05","06","07","08","0A","0B","0C","0D","0E","0F","18","1A"

selection_list 540
  description "Country"
  short_help "Select your country in which you are located. This setting will be used to configure the line interface of the modem."
  item_text   "Austria","Belgium","Denmark","Finland","France","Germany","Ireland","Italy","Netherlands","Norway","Portugal","Spain","Sweden","Switzerland","United Kingdom","USA"
  item_value  "001"    ,"002"    ,"003"    ,"004"    ,"005"   ,"006"    ,"007"    ,"008"  ,"010"        ,"011"   ,"012"     ,"013"  ,"014"   ,"015"        ,"016"           ,"022"

group_end

group "Intern device clock"

entryfield_text 500
  description "Time"
  short_help "The device time"
  time_format "%h,%m,%s"

entryfield_text 501
  description "Date"
  short_help "The device date"
  date_format "%y,%m,%d"

group_end

group "D channel protocol"

selection_list 004
  description "Protocol"
  short_help "Select the prefered D channel protocol."
  item_text  "Euro DSS1","DSS1 Point to Point","National 1TR6","Japanese INS64"
  item_value "DSS1","DSS1PP","1TR6","INS64"

selection_list 150
  description "Protocol"
  short_help "Select the prefered D channel protocol."
  item_text "Euro DSS1","National 1TR6"
  item_value "DSS1", "1TR6"

group "a/b Port Lineinterface"

selection_list 700
  description "Country"
  short_help "Select your country in which you are located. This setting will be used to configure the line interface of the modem."
  item_text "Nordamerika", "Griechenland","Niederlande","Belgien","Frankreich","Spanien","Italien","Schweiz","Oesterreich","Grossbritanien","Daenemark","Schweden","Norwegen","Deutschland","Japan","Tuerkei","Portugal","Luxemburg","Irland","Zypern","Finnland"
  item_value "1","30","31","32","33","34","39","41","43","44","45","46","47","49","81","90","351","352","353","357","358"

group "Call accepting"

onoff_switch 300
  description "Disable call accepting on ISDN port"
  value_list  "1", "0"
  short_help "Check this option to suppress incoming calls.""

onoff_switch 301
  description "Disable call accepting on a/b port 1"
  value_list  "1", "0"
  short_help "Check this option to suppress incoming calls.""

onoff_switch 302
  description "Disable call accepting on a/b port 2"
  value_list  "1", "0"
  short_help "Check this option to suppress incoming calls.""

section "Answering machine and fax "

group "Answering machine"

onoff_switch 506
  description "Answering machine enabled "
  short_help "Use this option to set call acceptance."

onoff_switch 518
  description "Enable speaker during recording"
  short_help "Calls that are being recorded by the answering machine can be monitored on the speakers if this option is enabled."

onoff_switch 515
  description "Outgoing message only, do not record messages"
  short_help "Use this option if you only want an outgoing message to be played. Incoming messages will not be recorded by the answering machine."
  value_list  "1", "0"

onoff_switch 519
  description "Prohibit monitoring or recording of conversations"
  short_help "Enable this option if you want to prevent conversations from being monitored or recorded by the answering machine."
  value_list  "1", "0"

selection_list 503
  description "Accept calls "
  short_help  "Use this option to set the delay before calls are accepted."
  item_text   "after 1 ring","after 2 rings","after 3 rings","after 4 rings","after 5 rings","after 6 rings","after 7 rings"
  item_value   "1","2","3","4","5","6","7"

group_end

group "Fax calls"

onoff_switch 505
  description "Fax reception enabled"
  short_help "Use this option to set fax reception."

onoff_switch 508
  description "Permit automatic fax reception during phone call"
  short_help "Use this option to set whether incoming faxes should also be recognized during phone conversations."

entryfield_text 507
  description "Fax ID"
  short_help "Enter a fax ID here, such as your name or telephone number."
  max_len 20
  add_to_charset " #"
  convert_to_upper 1

group_end

onoff_switch 504
  description "Accept calls if memory full"
  value_list  "0", "1"
  short_help "If this option is enabled, the modem will continue to accept calls when the memory is full."

onoff_switch 530
  description "Modem rings with incoming call"
  short_help "This defines whether the modem rings when you are called."

section "ISDN adapter"

group "Calling numbers (DSS1)"

entryfield_text 005
  description "Outgoing calling number"
  short_help "The entered calling number determines the number to be transfered with outgoing calls."
  max_len 16

entryfield_text 007
  description "Calls accept on"
  short_help "The entered calling number (first MSN) determines the first call accept signal. If no number entered, all calls are accepted."
  max_len 16

entryfield_text 008
  description "Calls accept on"
  short_help "The entered calling number (second MSN) determines the first call accept signal. If no number entered, all calls are accepted."
  max_len 16

entryfield_text 009
  description "Calls accept on"
  short_help "The entered calling number (third MSN) determines the first call accept signal. If no number entered, all calls are accepted."
  max_len 16

group "Calling number (1TR6)"

entryfield_numeric 011
  description "Terminal device digit"
  short_help "The entered calling digit (EAZ) determines the call accept signal. If no digit entered, all calls are accepted."
  range_min 0
  range_max 19

group_end

group Extras

readonly_text 170
    description "ISDN data port call charge"
    short_help "Total ISDN call charge display."

readonly_text 171
    description "Last connection"
    short_help "Last call charge display."
    invisible 1

onoff_switch 180
    description "Reset call charge of the ISDN data port"
    short_help "Reset the call charge of the ISDN data port"

onoff_switch 006

  description "Suppress outgoing calling number"
  short_help "Check this option to suppress the outgoing calling number."
  value_list  "1", "0"

group_end

selection_list 016
  description "Outgoing service indicator"
  short_help  "Outgoing service indicator."
  item_text   "Telephone 3.1 kHz", "Telephone analog", "Fax group 2", "Fax group 3"
  invisible 1

onoff_switch 012
  description "Pick up telephone service 3.1 khz"
  short_help "Pick up telephone service 3.1 khz."
  invisible 1

onoff_switch 013
  description "Pick up analog telephone"
  short_help "Pick up analog telephone."
  invisible 1

onoff_switch 014
  description "Pick up fax group 2"
  short_help "Pick up fax group 2."
  invisible 1

onoff_switch 015
  description "Pick up fax group 3"
  short_help "Pick up fax group 3."
  invisible 1

section "a/b port 1"

group "Calling numbers (DSS1)"

entryfield_text 020
  description "Outgoing calling number"
  short_help "The entered calling number determines the number to be transfered with outgoing calls."
  max_len 16

entryfield_text 022
  description "Calls accept on"
  short_help "The entered calling number (first MSN) determines the first call accept signal. If no number entered, all calls are accepted."
  max_len 16

entryfield_text 023
  description "Calls accept on"
  short_help "The entered calling number (second MSN) determines the first call accept signal. If no number entered, all calls are accepted."
  max_len 16

entryfield_text 024
  description "Calls accept on"
  short_help "The entered calling number (third MSN) determines the first call accept signal. If no number entered, all calls are accepted."
  max_len 16

group "Calling number (1TR6)"

entryfield_text 025
  description "Terminal device digit"
  short_help "The entered calling digit (EAZ) determines the call accept signal. If no digit entered, all calls are accepted."
  max_len 2

group "Public exchange access"

onoff_switch 701
    description "By picking up the phone"
    short_help "Get public exchange access by picking up the phone."

onoff_switch 702
    description "By pressing the flash key"
    short_help "Get public exchange access by pressing the flash key."

group "Service attributes"

selection_list 027
  description "Outgoing indicator"
  short_help  "Specify the outgoing service indicator."
  item_text   "Telephone 3.1 kHz", "Telephone analog", "Fax group 2", "Fax group 3"

onoff_switch 028
  description "Pick up telephone service 3.1 khz"
  short_help "Pick up telephone service 3.1 khz."
  invisible 1

onoff_switch 029
  description "Pick up analog telephone"
  short_help "Pick up analog telephone."
  invisible 1

onoff_switch 030
  description "Pick up fax group 2"
  short_help "Pick up fax group 2."
  invisible 1

onoff_switch 031
  description "Pick up fax group 3"
  short_help "Pick up fax group 3."
  invisible 1

section "a/b port 2"

group "Calling numbers (DSS1)"

entryfield_text 032
  description "Outgoing calling number"
  short_help "The entered calling number determines the number to be transfered with outgoing calls."
  max_len 16

entryfield_text 034
  description "Calls accept on"
  short_help "The entered calling number (first MSN) determines the first call accept signal. If no number entered, all calls are accepted."
  max_len 16

entryfield_text 035
  description "Calls accept on"
  short_help "The entered calling number (second MSN) determines the first call accept signal. If no number entered, all calls are accepted."
  max_len 16

entryfield_text 036
  description "Calls accept on"
  short_help "The entered calling number (third MSN) determines the first call accept signal. If no number entered, all calls are accepted."
  max_len 16

group "Calling number (1TR6)"

entryfield_text 037
  description "Terminal device digit"
  short_help "The entered calling digit (EAZ) determines the call accept signal. If no digit entered, all calls are accepted."
  max_len 2

group "Public exchange access"

onoff_switch 703
    description "By picking up the phone"
    short_help "Get public exchange access by picking up the phone."

onoff_switch 704
    description "By pressing the flash key"
    short_help "Get public exchange access by pressing the flash key."

group "Service attributes"

selection_list 039
  description "Outgoing indicator"
  short_help  "Select a outgoing service indicator."
  item_text   "Telephone 3.1 kHz", "Telephone analog", "Fax group 2", "Fax group 3"

onoff_switch 040
  description "Pick up telephone service 3.1 khz"
  short_help "Pick up telephone service 3.1 khz."
  invisible 1

onoff_switch 041
  description "Pick up analog telephone"
  short_help "Pick up analog telephone."
  invisible 1

onoff_switch 042
  description "Pick up fax group 2"
  short_help "Pick up fax group 2."
  invisible 1

onoff_switch 043
  description "Pick up fax group 3"
  short_help "Pick up fax group 3."
  invisible 1

section "Configuration"

group "Remote playback"

onoff_switch 516
  description "Enable remote playback"
  short_help "If remote playback is enabled, you can use a telephone with DTMF dialing to play back incoming messages."

onoff_switch 517
  description "Enable remote configuration"
  short_help "If remote configuration is enabled, you can use a telephone with DTMF dialing to configure the modem. "

entryfield_numbers 510
  description "Password"
  short_help "Enter the password for remote playback here."
  max_len 4
  fill 1

group_end

group "Configuration with the connected phone"

onoff_switch 522
  description "Push hook flash on your phone to have access"
  short_help "It is possible to configure the device with the telephone attached to the modem, simply tap the cradle on the phone."
  value_list  "1","0"

onoff_switch 523
  description "Send DTMF tons to have access"
  short_help "It is possible to configure the device with the telephone attached to the modem, simply address the device with the DTMF - Tone."
group_end

group "Answering machine"

slider 532
  description "Playback volume"
  short_help "This sets the volume with which recorded messages are played back."
  unit "Quiet", "Middle", "Loud"
  range_min 0
  range_max 255
  step 128

slider 531
  description "Recording volume"
  short_help "This sets the volume with which incoming messages are recorded."
  unit "Quiet", "Middle", "Loud"
  range_min 0
  range_max 255
  step 128

group "Speakerphone mode"

slider 534
  description "Sound volume"
  short_help "Set the sound volume so that there is no feedback."
  unit "Quiet", "Middle", "Loud"
  range_min 0
  range_max 255
  step 128

slider 533
  description "Microphone sensitivity"
  short_help "This sets the microsphone sensitivity for the speakerphone mode."
  unit "Quiet", "Middle", "Loud"
  range_min 0
  range_max 255
  step 128

section "Others"

group "Voice recording"

selection_list 511
  description "Recording quality"
  short_help "Select the recording quality here."
  item_text "Low quality","Normal quality","High quality"
  item_value "ADPCM2-7","ADPCM4-7","PCM8L-7"

selection_list 509
  description "Maximum recording duration"
  short_help "Select the maximum recording duration here."
  item_text "unlimited","15 sec.","30 sec.","45 sec.","60 sec.","75 sec.","90 sec.","105 sec.","120 sec.","135 sec."
  item_value "0","1","2","3","4","5","6","7","8","9"

selection_list 521
  description "Minimum recording duration"
  short_help "Select the minimum recording duration here."
  item_text " ", "1 sec.","2 sec.","3 sec.","4 sec.","5 sec.","6 sec.","7 sec.","8 sec.","9 sec.","10 sec.","11 sec.","12 sec.","13 sec.","14 sec."
  item_value "0","1","2","3","4","5","6","7","8","9","10","11","12","13","14"

group_end

group "Voice output"

onoff_switch 512
  description "Announce system messages"
  short_help "With this option selected, system messages will be announced."

onoff_switch 513
  description "Announce caller ID"
  short_help "With this option selected, the caller ID (CLIP) of incoming calls will be announced."

onoff_switch 514
  description "Announce time of call"
  short_help "With this option selected, the time of the call will be announced."

selection_list 520
  description "Outgoing message"
  short_help "Select your outgoing message here."
  item_text "No. 1","No. 2","No. 3","Memory full"
  item_value "0","1","2","255"

group_end

group "Compatibility"

onoff_switch 524
  description "Activate the answering machine, if an application use the modem."
  short_help "Some applications do not properly free the modem, even when it is no longer required.\r\rIn such a situation, click this option when you need to activate the ansaphone.\r\rFor further information please refer to your handbook."

group_end

onoff_switch 110
  description "Knocking on port 0"
  short_help "Disable or enable the call waiting facility."
  invisible 1

onoff_switch 101
  description "Automatic dialing on ISDN port"
  short_help "Automatic dialing on ISDN port."
  invisible 1

entryfield_text 100
  description "Dialing number port 0"
  short_help "Dialing number port 0."
  invisible 1

group a/b port 1

readonly_text 172
    description "a/b port 1 call charge"
    short_help "Total call charge display."

readonly_text 173
    description "Last call"
    short_help "Last call charge display."

onoff_switch 181
    description "Reset call charge"
    short_help "Reset the call charge of the a/b port 1."

onoff_switch 111
  description "Let hear knocking tone on incomming call"
  short_help "Disable or enable the call waiting facility on a/b port 1."

onoff_switch 021
  description "Suppress outgoing calling number"
  short_help "Check this option to suppress the outgoing calling number."
  value_list  "1", "0"

onoff_switch 103
  description "By picking up the phone dial the following number"
  short_help "Automatic dialing on a/b port 1."

entryfield_text 102
  description "Number"
  short_help "Dialing number port 1."

group a/b port 2

readonly_text 174
    description "a/b port 2 call charge"
    short_help "Total call charge display."

readonly_text 175
    description "Last call"
    short_help "Last call charge display."

onoff_switch 182
    description "Reset call charge"
    short_help "Reset the call charge of the a/b port 2."

onoff_switch 112
  description "Let hear knocking tone on incomming call"
  short_help "Disable or enable the  call waiting facility on a/b port 2."

onoff_switch 033
  description "Suppress outgoing calling number"
  short_help "Check this option to suppress the outgoing calling number."
  value_list "1", "0"

onoff_switch 105
  description "By picking up the phone dial the following number"
  short_help "Automatic dialing on a/b port 2."

entryfield_text 104
  description "Number"
  short_help "Dialing number port 2."

group_end

version "CFGMGR 1.00","Francais"

section "Gnralits"

group_logo 0

readonly_text 001
    description "Priphrique"
    short_help "Le nom de produit du priphrique."

readonly_text 002
    description "Version"
    short_help "La version du microprogramme du priphrique."

readonly_text 003
    description "Date"
    short_help "La date de cration du microprogramme."

readonly_text 600
    description "Firmwaretype"
    short_help "The meaning of the firmwaretype."
    item_text "MX - Multilink X.75 (ELSA)", "MP - Multilink PPP"
    item_value "X", "P"

group_end

group "Slection du pays"

selection_list 502
  description "Pays"
  short_help "Slectionnez le pays dans lequel vous vous trouvez. Cette slection configure l'interface Line du modem."
  item_text  "L'Allemagne","L'Autriche","La Belgique","Le Danemark","L'Espagne","Les tats-Unis d'Amerique","La Finlande","La France","L'Italie","Liechtenstein","Luxembourg","Monaco","La Norvge","Les Pays-Bas","Le Portugal","Le Royaume-Uni","La Sude","La Suisse"
  item_value "04","0A","0F","31","A0","B5","3C","3D","59","68","69","74","82","7B","8B","B4","A5","A6"

selection_list 800
  description "Pays"
  short_help "Slectionnez le pays dans lequel vous vous trouvez. Cette slection configure l'interface Line du modem."
  item_text   "La Belgique","Le Danemark","La Finlande","La France","L'Allemagne","Les Pays-Bas","L'Italie","La Norvge","L'Espagne","La Sude","La Suisse","Le Royaume-Uni","L'Autriche","Le Portugal","L' Irlande"
  item_value  "02","03","04","05","06","07","08","0A","0B","0C","0D","0E","0F","18","1A"

selection_list 540
  description "Pays"
  short_help  "Slectionnez le pays dans lequel vous vous trouvez. Cette slection configure l'interface Line du modem."
  item_text   "L'Allemagne","L'Autriche","La Belgique","Le Danemark","L'Espagne","Les tats-Unis d'Amerique","La Finlande","La France","L'Italie","La Norvge","Les Pays-Bas","Le Portugal","Le Royaume-Uni","La Sude","La Suisse"
  item_value  "006"        ,"001"       ,"002"        ,"003"        ,"013"      ,"022"                      ,"004"        ,"005"      ,"008"     ,"011"       ,"010"         ,"012"        ,"016"           ,"014"     ,"015"

group_end

group "Heure interne du priphrique"

entryfield_text 500
  description "Heure"
  short_help "Heure interne du priphrique."
  time_format "%h,%m,%s"

entryfield_text 501
  description "Date"
  short_help "Date du priphrique."
  date_format "%y,%m,%d"

group_end

group "Protocole du canal D"

selection_list 004
  description "Protocole"
  short_help "Slectionnez le protocole de canal D souhait."
  item_text  "Euro DSS1","DSS1 Point to Point","National 1TR6","Japanese Protocol: INS64"
  item_value "DSS1","DSS1PP","1TR6","INS64"

selection_list 150
  description "Protocole"
  short_help "Slectionnez le protocole de canal D souhait."
  item_text "Euro DSS1","National 1TR6"
  item_value "DSS1", "1TR6"

group "Prise d'appel"

onoff_switch 300
  description "Verrouiller la prise d'appel sur l'adaptateur RNIS"
  short_help "Cochez cette option pour refuser les appels reus par l'adaptateur."
  value_list  "1", "0"

onoff_switch 301
  description "Verrouiller la prise d'appel sur le port a/b 1"
  short_help "Cochez cette option pour refuser les appels reus sur le port a/b 1."
  value_list  "1", "0"

onoff_switch 302
  description "Verrouiller la prise d'appel sur le port a/b 2"
  short_help "Cochez cette option pour refuser les appels reus sur le port a/b 2."
  value_list  "1", "0"

section "Rpondeur vocal + Fax"

group "Rpondeur vocal"

onoff_switch 506
  description "Mettre le rpondeur vocal en marche"
  short_help "Vous permet d'indiquer si les appels tlphoniques doivent tre accepts."

onoff_switch 518
  description "Activer le haut-parleur pendant l'enregistrement"
  short_help "Activez cette option pour couter les messages pendant l'enregistrement sur le rpondeur."

onoff_switch 515
  description "Rpondre sans enregistrer de messages"
  short_help "Cette option vous permet d'indiquer que l'appelant coute uniquement le message d'accueil, sans pouvoir laisser lui-mme de message."
  value_list  "1", "0"

onoff_switch 519
  description "Ne pas autoriser l'coute ou l'enregistrement des appels"
  short_help "Activez cette option si vous ne souhaitez pas enregistrer la conversation pendant l'appel."
  value_list  "1", "0"

selection_list 503
  description "Dcrochage"
  short_help  "Permet d'indiquer le nombre de sonneries avant la prise d'appel."
  item_text   "aprs 1 sonnerie","aprs 2 sonneries","aprs 3 sonneries","aprs 4 sonneries","aprs 5 sonneries","aprs 6 sonneries","aprs 7 sonneries"
  item_value   "1","2","3","4","5","6","7"

group_end

group "Rception des tlcopies"

onoff_switch 505
  description "Rception fax active"
  short_help "Vous permet d'indiquer si vous souhaitez accepter les transmissions de tlcopie."

onoff_switch 508
  description "Autoriser la rception automatique de fax pendant un appel"
  short_help "Vous permet d'indiquer que les fax entrants peuvent tre identifis pendant une conversation tlphonique."

entryfield_text 507
  description "Identification du fax"
  short_help "Saisissez une identification pour votre fax, par exemple votre nom ou votre numro de tlphone."
  max_len 20
  add_to_charset " #"
  convert_to_upper 1

group_end

onoff_switch 504
  description "Accepter les appels quand la mmoire est pleine"
  value_list  "0", "1"
  short_help "Vous permet d'indiquer que le modem accepte les appels mme si la mmoire est pleine."

onoff_switch 530
  description "Sonnerie du modem  la rception d'un appel"
  short_help "Cette option fait sonner le modem quand vous recevez un appel."

section "Adaptateur RNIS"

group "Numros d'appel (pour DSS1)"

entryfield_text 005
  description "Votre numro d'appel"
  short_help "Saisissez le numro d'appel identifiant les appels sortants."
  max_len 16

onoff_switch 006
  description "Ne pas transmettre avec les appels sortants"
  short_help "Activez cette option si vous ne souhaitez pas transmettre votre numro avec les appels sortants."
  value_list "1", "0"

entryfield_text 007
  description "Prendre les appels sur"
  short_help "Le numro d'appel saisi (premier numro MSN) dtermine le premier signal de prise d'appel."
  max_len 16

entryfield_text 008
  description "Prendre les appels sur"
  short_help "Le numro d'appel saisi (deuxime numro MSN) dtermine le premier signal de prise d'appel."
  max_len 16

entryfield_text 009
  description "Prendre les appels sur"
  short_help "Le numro d'appel saisi (troisime numro MSN) dtermine le premier signal de prise d'appel."
  max_len 16

group "Numro d'appel (1TR6)"

entryfield_numeric 011
  description "Adresse EAZ"
  short_help "Saisissez l'adresse EAZ  laquelle le priphrique doit ragir."
  range_min 0
  range_max 19

group_end

selection_list 016
  description "Indicateur de service sortant"
  short_help  "Slectionnez l'indicateur de service sortant."
  item_text   "Tlphone 3.1 kHz", "Tlphone analogiques", "Fax groupe 2", "Fax groupe 3"
  invisible 1

onoff_switch 012
  description "Accepter les services tlphoniques 3.1 khz"
  short_help "Indiquez si les services tlphoniques (3.1 khz) sont accepts."
  invisible 1

onoff_switch 013
  description "Accepter les appels tlphoniques analogiques"
  short_help "Indiquez si les services tlphoniques (analogiques) sont accepts."
  invisible 1

onoff_switch 014
  description "Accepter fax groupe 2"
  short_help "Indiquez si les fax (groupe 2) sont accepts."
  invisible 1

onoff_switch 015
  description "Accepter fax groupe 3"
  short_help "Indiquez si les fax (groupe 3) sont accepts."
  invisible 1

section "Port a/b 1"

group "Numros d'appel (pour DSS1)"

entryfield_text 020
  description "Votre numro d'appel"
  short_help "Saisissez le numro d'appel identifiant les appels sortants."
  max_len 16

onoff_switch 021
  description "Ne pas transmettre avec les appels sortants"
  short_help "Activez cette option si vous ne souhaitez pas transmettre votre numro avec les appels sortants."
  value_list "1", "0"

entryfield_text 022
  description "Prendre les appels sur"
  short_help "Le numro d'appel saisi (premier numro MSN) dtermine le premier signal de prise d'appel."
  max_len 16

entryfield_text 023
  description "Prendre les appels sur"
  short_help "Le numro d'appel saisi (deuxime numro MSN) dtermine le premier signal de prise d'appel."
  max_len 16

entryfield_text 024
  description "Prendre les appels sur"
  short_help "Le numro d'appel saisi (troisime numro MSN) dtermine le premier signal de prise d'appel."
  max_len 16

group "Numro d'appel (1TR6)"

entryfield_text 025
  description "Adresse EAZ"
  short_help "Saisissez l'adresse EAZ  laquelle le priphrique doit ragir."
  max_len 2

group "Tlservices"

selection_list 027
  description "Indicateur de service sortant"
  short_help  "Slectionnez l'indicateur de service sortant."
  item_text   "Tlphone 3.1 kHz", "Tlphone analogiques", "Fax groupe 2", "Fax groupe 3"

onoff_switch 028
  description "Accepter les services tlphoniques 3.1 khz"
  short_help "Indiquez si les services tlphoniques (3.1 khz) sont accepts."

onoff_switch 029
  description "Accepter les appels tlphoniques analogiques"
  short_help "Indiquez si les services tlphoniques (analogiques) sont accepts."

onoff_switch 030
  description "Accepter fax groupe 2"
  short_help "Indiquez si les fax (groupe 2) sont accepts."

onoff_switch 031
  description "Accepter fax groupe 3"
  short_help "Indiquez si les fax (groupe 3) sont accepts."

section "Port a/b 2"

group "Numros d'appel (pour DSS1)"

entryfield_text 032
  description "Votre numro d'appel"
  short_help "Saisissez le numro d'appel identifiant les appels sortants."
  value_list "1", "0"
  max_len 16

onoff_switch 033
  description "Ne pas transmettre avec les appels sortants"
  short_help "Activez cette option si vous ne souhaitez pas transmettre votre numro avec les appels sortants."
  value_list "1", "0"

entryfield_text 034
  description "Prendre les appels sur"
  short_help "Le numro d'appel saisi (premier numro MSN) dtermine le premier signal de prise d'appel."
  max_len 16

entryfield_text 035
  description "Prendre les appels sur"
  short_help "Le numro d'appel saisi (deuxime numro MSN) dtermine le premier signal de prise d'appel."
  max_len 16

entryfield_text 036
  description "Prendre les appels sur"
  short_help "Le numro d'appel saisi (troisime numro MSN) dtermine le premier signal de prise d'appel."
  max_len 16

group "Numro d'appel (1TR6)"

entryfield_text 037
  description "Adresse EAZ"
  short_help "Saisissez l'adresse EAZ  laquelle le priphrique doit ragir."
  max_len 2

group "Tlservices"

selection_list 039
  description "Indicateur de service sortant"
  short_help  "Slectionnez l'indicateur de service sortant."
  item_text   "Tlphone 3.1 kHz", "Tlphone analogiques", "Fax groupe 2", "Fax groupe 3"

onoff_switch 040
  description "Accepter les services tlphoniques 3.1 khz"
  short_help "Indiquez si les services tlphoniques (3.1 khz) sont accepts."

onoff_switch 041
  description "Accepter les appels tlphoniques analogiques"
  short_help "Indiquez si les services tlphoniques (3.1 khz) sont accepts."

onoff_switch 042
  description "Accepter fax groupe 2"
  short_help "Indiquez si les fax (groupe 2) sont accepts."

onoff_switch 043
  description "Accepter fax groupe 3"
  short_help "Indiquez si les fax (groupe 3) sont accepts."

section "Configuration"

group "Interrogation  distance"

onoff_switch 516
  description "Autoriser l'interrogation  distance"
  short_help "L'interrogation  distance permet d'interroger le modem avec un tlphone  frquence vocale DTMF."

onoff_switch 517
  description "Autoriser la configuration  distance"
  short_help "La configuration  distance permet de configurer le modem avec un tlphone  frquence vocale DTMF."

entryfield_numbers 510
  description "Mot de passe"
  short_help "Entrez le mot de passe pour la configuration  distance."
  max_len 4
  fill 1

group_end

group "Configuration par le tlphone branch sur modem"

onoff_switch 522
  description "Accs par raccrochage court"
  short_help "Si vous voulez mettre en application cette fonction, vous pouvez configurer l'appareil avec votre tlphone connect  l'arrire du modem, et faire un contrle,en raccrochant trs brivement avec le doigt."
  value_list  "1","0"

onoff_switch 523
  description "Accs pas DTMF"
  short_help "Si vous voulez mettre en application cette fonction, vous pouvez configurer l'appareil avec votre tlphone connect  l'arrire du modem, et faire un contrle,en interrogeant l'appareil avec le DTMF (code multifrquence d'un tlphone  clavier)"
group_end

group "Rpondeur vocal"

slider 532
  description "Volume de restitution"
  short_help "Rglez ici le volume de restitution des appels enregistrs."
  range_min 0
  range_max 255
  step 128
  unit "bas", "moyen", "fort"

slider 531
  description "Niveau d'enregistrement"
  short_help "Rglez ici le niveau d'enregistrement des appels reus."
  range_min 0
  range_max 255
  step 128
  unit "bas", "moyen", "fort"

group "Mode mains-libres"

slider 534
  description "Volume de restitution"
  short_help "Rglez le volume de restitution de manire qu'il n'y ait pasde feedback."
  range_min 0
  range_max 255
  step 128
  unit "bas", "moyen", "fort"

slider 533
  description "Sensibilit du micro"
  short_help "Rglez ici la sensibilit du micro pour le mode mains-libres."
  range_min 0
  range_max 255
  step 128
  unit "bas", "moyen", "fort"

section "Autres"

group "Enregistrement des messages"

selection_list 511
  description "Qualit d'enregistrement"
  short_help "Slectionnez la qualit de l'enregistrement audio."
  item_text "Basse qualit","Qualit normale","Haute qualit"
  item_value "ADPCM2-7","ADPCM4-7","PCM8L-7"

selection_list 509
  description "Dure max. d'enregistrement"
  short_help "Slectionnez la dure maximale de l'enregistrement."
  item_text "unlimited","15 sec.","30 sec.","45 sec.","60 sec.","75 sec.","90 sec.","105 sec.","120 sec.","135 sec."
  item_value "0","1","2","3","4","5","6","7","8","9"

selection_list 521
  description "Dure min. d'enregistrement"
  short_help "Slectionnez la dure minimale de l'enregistrement."
  item_text " ", "1 sec.","2 sec.","3 sec.","4 sec.","5 sec.","6 sec.","7 sec.","8 sec.","9 sec.","10 sec.","11 sec.","12 sec.","13 sec.","14 sec."
  item_value "0","1","2","3","4","5","6","7","8","9","10","11","12","13","14"

group_end

group "Restitution des messages"

onoff_switch 512
  description "Restitution vocale des messages systme"
  short_help "Indiquez si le priphrique doit annoncer les messages systme."

onoff_switch 513
  description "Restitution vocale du numro de l'appelant"
  short_help "Indiquez si le priphrique doit annoncer le numro d'appel de l'appelant (CLIP)."

onoff_switch 514
  description "Restitution vocale de l'heure d'appel"
  short_help "Indiquez si le priphrique doit annoncer l'heure de l'appel."

selection_list 520
  description "Message d'accueil"
  short_help "Slectionnez le message d'accueil."
  item_text "N 1","N 2","N 3","Mmoire pleine"
  item_value "0","1","2","255"

group_end

group "Compatibilit"

onoff_switch 524
  description "Activez le rpondeur galement quand le modem est utilis par une autre aplication."
  short_help "Certaines applications ne librent pas le modem compltement, mme si elle ne l'utilisent plus.\r\rPour pouvoir quand mme utiliser le rpondeur tlphonique dans detels cas, activez ce bouton\r\rPour plus d'informations, veuillez consulter le manuel"

group_end

group "Prsentation d'appel"

onoff_switch 110
  description "Signal d'alerte sur port a/b 0"
  short_help "Permet d'activer ou de dsactiver la prsentation d'appel."
  invisible 1

onoff_switch 111
  description "Signal d'alerte sur port a/b 1"
  short_help "Permet d'activer ou de dsactiver la prsentation d'appel."

onoff_switch 112
  description "Signal d'alerte sur port a/b 2"
  short_help "Permet d'activer ou de dsactiver la prsentation d'appel."

group "Appel automatique"

onoff_switch 101
  description "Liaison sans numrotation sur l'adaptateur RNIS"
  short_help "."
  invisible 1

entryfield_text 100
  description "Numro d'appel pour port RNIS"
  short_help "."
  invisible 1

onoff_switch 103
  description "Liaison sans numrotation sur le port a/b 1"
  short_help "Permet d'activer ou de dsactiver l'appel automatique."

entryfield_text 102
  description "Numro d'appel port a/b 1"
  short_help "Saisissez le numro d'appel  composer aprs le dcrochage du combin."

onoff_switch 105
  description "Liaison sans numrotation sur le port a/b 2"
  short_help "Permet d'activer ou de dsactiver l'appel automatique."

entryfield_text 104
  description "Numro d'appel port a/b 2"
  short_help "Saisissez le numro d'appel  composer aprs le dcrochage du combin."

group "Indication de cot"

readonly_text 170
    description "Cots de comm. RNIS"
    short_help "Indique le cot total des communications de l'adaptateur RNIS."

readonly_text 171
    description "Dernier appel"
    short_help "Indique le cot de communication du dernier appel de l'adaptateur RNIS."

readonly_text 172
    description "Cots de communication port a/b 1"
    short_help "Indique le cot total des communications du port a/b 1

readonly_text 173
    description "Dernier appel"
    short_help "Indique le cot de communication du dernier appel du port a/b 1."

readonly_text 174
    description "Cots de communication port a/b 2"
    short_help "Indique le cot total des communications du port a/b 2

readonly_text 175
    description "Dernier appel"
    short_help "Indique le cot de communication du dernier appel du port a/b 2."

version "CFGMGR 1.00","Italiano"

section "Generale"

group_logo 0

readonly_text 001
    description "Apparecchio"
    short_help "Il nome di prodotto dell'apparecchio."

readonly_text 002
    description "Versione"
    short_help "La versione firmware dell'apparecchio."

readonly_text 003
    description "Data"
    short_help "La data di creazione del firmware."

readonly_text 600
    description "Tipo di firmware"
    short_help "Il significato del tipo di firmware."
    item_text "MX - Multilink X.75 (ELSA)", "MP - Multilink PPP"
    item_value "X", "P"

group_end

group "Selezione nazionale"

selection_list 502
  description "Paese"
  short_help "Selezionare il paese in cui ci si trova. Con questa impostazione si configura l'interfaccia di linea del modem."
  item_text  "Belgio","Danimarca","Germania","Finlandia","Francia","Gran Bretagna","Italia","Liechtenstein","Lussemburgo","Monaco","Paesi Bassi","Norvegia","Austria","Portogallo","Svezia","Svizzera","Spagna","USA"
  item_value  "0F","31","04","3C","3D","B4","59","68","69","74","7B","82","0A","8B","A5","A6","A0","B5"

selection_list 800
  description "Paese"
  short_help "Selezionare il paese in cui ci si trova. Con questa impostazione si configura l'interfaccia di linea del modem."
  item_text   "Belgio","Danimarca","Finlandia","Francia","Germania","Paesi Bassi","Italia","Norvegia","Spagna","Svezia","Svizzera","Gran Bretagna","Austria","Portogallo","Irlanda"
  item_value  "02","03","04","05","06","07","08","0A","0B","0C","0D","0E","0F","18","1A"

selection_list 540
  description "Paese"
  short_help "Selezionare il paese in cui ci si trova. Con questa impostazione si configura l'interfaccia di linea del modem."
  item_text   "Belgio","Danimarca","Germania","Finlandia","Francia","Gran Bretagna","Irlanda","Italia","Paesi Bassi","Norvegia","Austria","Portogallo","Svezia","Svizzera","Spagna","USA"
  item_value  "002"   ,"003"      ,"006"     ,"004"      ,"005"    ,"016"          ,"007"    ,"008"   ,"010"        ,"011"     ,"001"    ,"012"       ,"014"   ,"015"     ,"013"   ,"022"

group_end

group " Orologio interno dell'apparecchio"

entryfield_text 500
  description " Ora"
  short_help "L'ora dell'apparecchio."
  time_format "%h,%m,%s"

entryfield_text 501
  description "Data"
  short_help "La data dell'apparecchio."
  date_format "%y,%m,%d"

group_end

group "Protocollo canale D"

selection_list 004
  description "Protocollo"
  short_help "Impostare qui il protocollo canale D desiderato."
  item_text  "Automatico","Euro DSS1","DSS1 punto-a-punto","Nazionale 1TR6","Protocollo giapponese: INS64"
  item_value "AUTO", "DSS1","DSS1PP","1TR6","INS64"

selection_list 150
  description "Protocollo"
  short_help "Impostare qui il protocollo canale D desiderato."
  item_text "Euro DSS1","Nazionale 1TR6"
  item_value "DSS1", "1TR6"

group "Impostazione nazionale delle porte a/b"

selection_list 700
  description "Paese"
  short_help "Selezionare il paese in cui ci si trova. Con questa impostazione si configura l'interfaccia di linea delle porte a/b."
  item_text "Nordamerica", "Grecia","Paesi Bassi","Belgio","Francia","Spagna","Italia","Svizzera","Austria","Gran Bretagna","Danimarca","Svezia","Norvegia","Germania","Giappone","Turchia","Portogallo","Lussemburgo","Irlanda","Cipro","Finlandia"
  item_value "1","30","31","32","33","34","39","41","43","44","45","46","47","49","81","90","351","352","353","357","358"

group "Accettazione della chiamata"

onoff_switch 300
  description "Blocco dell'accettazione delle chiamate sull'adapter ISDN"
  short_help "Con questo si stabilisce che la porta dati ISDN non deve accettare alcuna chiamata."
  value_list  "1", "0"

onoff_switch 301
  description "Blocco dell'accettazione delle chiamate sulla porta a/b 1."
  short_help "Con questo si stabilisce che la porta a/b 1 non deve accettare alcuna chiamata."
  value_list  "1", "0"

onoff_switch 302
  description "Blocco dell'accettazione delle chiamate sulla porta a/b 2."
  short_help "Con questo si stabilisce che la porta a/b 2 non deve accettare alcuna chiamata."
  value_list  "1", "0"

section "Segreteria telefonica + fax"

group "Segreteria telefonica"

onoff_switch 506
  description "Segreteria telefonica attivata"
  short_help "Con questo si stabilisce se si vuole rispondere alle chiamate telefoniche."

onoff_switch 518
  description "Durante la registrazione attivare l'altoparlante"
  short_help "Attivando questa opzione, si possono ascoltare le chiamate mentre vengono registrate dalla segreteria telefonica."

onoff_switch 515
  description "Eseguire solo l'annuncio, non registrare notizie"
  short_help "Con questo si stabilisce che viene solo eseguito l'annuncio della segreteria telefonica. Non si possono lasciare messaggi alla segreteria telefonica."
  value_list  "1", "0"

onoff_switch 519
  description "Vietare l'ascolto o la registrazione delle telefonate"
  short_help "Attivare questa opzione se non si desidera che le telefonate alla segreteria telefonica possano essere registrate."
  value_list  "1","0"

selection_list 503
  description "Accettazione delle chiamate"
  short_help  "Con questo si stabilisce dopo quanto tempo le chiamate telefoniche devono essere accettate."
  item_text   "dopo 2x squilli","dopo 3x squilli","dopo 4x squilli","dopo 5x squilli","dopo 6x squilli","dopo 7x squilli","dopo 8x squilli","dopo 9x squilli"
  item_value  "2","3","4","5","6","7","8","9"

group_end

group "Chiamate fax"

onoff_switch 505
  description "Accettazione fax attivata"
  short_help "Con questo si stabilisce se si vuole rispondere alle chiamate fax."

onoff_switch 508
  description "Consentire l'accettazione fax durante una telefonata"
  short_help "Con questo si stabilisce che un fax in arrivo pu essere accettato anche durante una telefonata."

entryfield_text 507
  description "Identificazione fax"
  short_help "Introdurre qui un'identificazione fax, questa pu essere per es. il proprio nome o numero telefonico."
  max_len 20
  add_to_charset " #"
  convert_to_upper 1

group_end

onoff_switch 504
  description "Accettare le chiamate anche se la memoria  esaurita"
  value_list  "0","1"
  short_help "Con questo si stabilisce che il modem pu rispondere alle chiamate anche se la memoria  esaurita."

onoff_switch 530
  description "Il modem squilla per una chiamata in arrivo"
  short_help "Con questo si stabilisce che il modem squilla se si riceve una chiamata."

section "Adapter ISDN"

group "Numeri d'utenza (con DSS1)"

entryfield_numbers 005
  description "Proprio numero d'utenza"
  short_help "Introdurre qui il MSN per le chiamate in uscita."
  max_len 16

entryfield_numbers 007
  description "Accettare le chiamate a"
  short_help "Introdurre qui il primo MSN a cui si deve reagire per una chiamata in arrivo."
  max_len 16

entryfield_numbers 008
  description "Accettare le chiamate a"
  short_help "Introdurre qui il secondo MSN a cui si deve reagire per una chiamata in arrivo."
  max_len 16

entryfield_numbers 009
  description "Accettare le chiamate a"
  short_help "Introdurre qui il terzo MSN a cui si deve reagire per una chiamata in arrivo."
  max_len 16

group "Numero d'utenza (con 1TR6)"

entryfield_numeric 011
  description "Cifra di terminale"
  short_help "Introdurre qui il EAZ a cui si l'apparecchio deve reagire per una chiamata in arrivo."
  range_min 0
  range_max 19

group "Extra"

readonly_text 170
    description "Somma delle unit"
    short_help "Indica la somma di tutte le unit della porta dati ISDN."

readonly_text 171
    description "Ultima connessione"
    short_help "Indica le unit della porta dati ISDN dopo l'ultima connessione."
    invisible 1

onoff_switch 180
    description "Azzeramento del contatore di unit"
     short_help "Azzera le unit della porta dati ISDN."

onoff_switch 006
  description "Soppressione della trasmissione del proprio numero d'utenza"
  short_help "Attivare questa opzione per non trasmettere il MSN nelle chiamate in partenza."
  value_list "1", "0"

group_end

selection_list 016
  description "Propria caratteristica di servizio"
  short_help  "Selezionare qui la caratteristica di servizio per le connessioni in uscita"
  item_text   "Telefonia 3.1 kHz", "Telefonia analogica", "Fax gruppo 2", "Fax gruppo 3"
  invisible 1

onoff_switch 012
  description "Accettazione telefonia 3.1 khz"
  short_help "Selezionare qui se devono essere accettati servizi telefonici (3.1 khz)."
  invisible 1

onoff_switch 013
  description "Accettazione telefonia analogica"
  short_help "Selezionare qui se devono essere accettati servizi telefonici (analogici)."
  invisible 1

onoff_switch 014
  description "Accettazione servizio fax gruppo 2"
  short_help "Selezionare qui se devono essere accettati fax (gruppo 2)."
  invisible 1

onoff_switch 015
  description "Accettazione servizio fax gruppo 3"
  short_help "Selezionare qui se devono essere accettati fax (gruppo 3)."
  invisible 1

section "Porta a/b 1"

group "Numero d'utenza (con DSS1)"

entryfield_text 020
  description "Proprio numero d'utenza"
  short_help "Introdurre qui il MSN per le chiamate in uscita."
  max_len 16

entryfield_text 022
  description "Accettare le chiamate a"
  short_help "Introdurre qui il primo MSN a cui si deve reagire per una chiamata in arrivo."
  max_len 16

entryfield_text 023
  description "Accettare le chiamate a"
  short_help "Introdurre qui il secondo MSN a cui si deve reagire per una chiamata in arrivo."
  max_len 16

entryfield_text 024
  description "Accettare le chiamate a"
  short_help "Introdurre qui il terzo MSN a cui si deve reagire per una chiamata in arrivo."
  max_len 16

group "Numero d'utenza (con 1TR6)"

entryfield_text 025
  description "Cifra di terminale"
  short_help "Introdurre qui il EAZ a cui si l'apparecchio deve reagire per una chiamata in arrivo."
  max_len 2

group "Chiamata centralino"

onoff_switch 701
    description "Sollevando la cornetta"
    short_help "Se  selezionata questa opzione, quando si solleva la cornetta si sente il segnale di libero del proprio centralino o del proprio impianto telefonico. Si possono effettuare conversazioni esterne.\r\rPer telefonare all'interno, premere il tasto Flash."

onoff_switch 702
    description "Premendo il tasto Flash"
    short_help "Se  selezionata questa opzione, quando si preme il tasto Flash si sente il segnale di libero del proprio centralino o del proprio impianto telefonico. Si possono effettuare conversazioni esterne.\r\rSe  attivata l'opzione 'Chiamata centralino sollevando la cornetta', la telefonia interna  impossibile!"

group "Caratteristiche di servizio"

selection_list 027
  description "Propria caratteristica di servizio"
  short_help  "Selezionare qui la caratteristica di servizio per le connessioni in uscita"
  item_text   "Telefonia 3.1 kHz", "Telefonia analogica", "Fax gruppo 2", "Fax gruppo 3"

onoff_switch 028
  description "Accettazione telefonia 3.1 khz"
  short_help "Selezionare qui se devono essere accettati servizi telefonici (3.1 khz)."
  invisible 1

onoff_switch 029
  description "Accettazione telefonia analogica"
  short_help "Selezionare qui se devono essere accettati servizi telefonici (analogici)."
  invisible 1

onoff_switch 030
  description "Accettazione servizio fax gruppo 2"
  short_help "Selezionare qui se devono essere accettati fax (gruppo 2)."
  invisible 1

onoff_switch 031
  description "Accettazione servizio fax gruppo 3"
  short_help "Selezionare qui se devono essere accettati fax (gruppo 3)."
  invisible 1

section "Porta a/b 2"

group "Numeri d'utenza (con DSS1)"

entryfield_text 032
  description "Proprio numero d'utenza"
  short_help "Introdurre qui il MSN per le chiamate in uscita."
  max_len 16

entryfield_text 034
  description "Accettare le chiamate a"
  short_help "Introdurre qui il primo MSN a cui si deve reagire per una chiamata in arrivo."
  max_len 16

entryfield_text 035
  description "Accettare le chiamate a"
  short_help "Introdurre qui il secondo MSN a cui si deve reagire per una chiamata in arrivo."
  max_len 16

entryfield_text 036
  description "Accettare le chiamate a"
  short_help "Introdurre qui il terzo MSN a cui si deve reagire per una chiamata in arrivo."
  max_len 16

group "Numero d'utenza (con 1TR6)"

entryfield_text 037
  description "Cifra di terminale"
  short_help "Introdurre qui il EAZ a cui si l'apparecchio deve reagire per una chiamata in arrivo."
  max_len 2

group "Chiamata centralino"

onoff_switch 703
    description "Sollevando la cornetta"
short_help "Se  selezionata questa opzione, quando si solleva la cornetta si sente il segnale di libero del proprio centralino o del proprio impianto telefonico. Si possono effettuare conversazioni esterne.\r\rPer telefonare all'interno, premere il tasto Flash."

onoff_switch 704
    description "Premendo il tasto Flash"
    short_help "Se  selezionata questa opzione, quando si preme il tasto Flash si sente il segnale di libero del proprio centralino o del proprio impianto telefonico. Si possono effettuare conversazioni esterne.\r\rSe  attivata l'opzione 'Chiamata centralino sollevando la cornetta', la telefonia interna  impossibile!"

group "Caratteristiche di servizio"

selection_list 039
  description "Propria caratteristica di servizio"
  short_help  "Selezionare qui la caratteristica di servizio per le connessioni in uscita"
  item_text   "Telefonia 3.1 kHz", "Telefonia analogica", "Fax gruppo 2", "Fax gruppo 3"

onoff_switch 040
  description "Accettazione telefonia 3.1 khz"
  short_help "Selezionare qui se devono essere accettati servizi telefonici (3.1 khz)."
  invisible 1

onoff_switch 041
  description "Accettazione telefonia analogica"
  short_help "Selezionare qui se devono essere accettati servizi telefonici (3.1 khz)."
  invisible 1

onoff_switch 042
  description "Accettazione servizio fax gruppo 2"
  short_help "Selezionare qui se devono essere accettati fax (gruppo 2)."
  invisible 1

onoff_switch 043
  description "Accettazione servizio fax gruppo 3"
  short_help "Selezionare qui se devono essere accettati fax (gruppo 3)."
  invisible 1

section "Configurazione"

group "Interrogazione remota"

onoff_switch 516
  description "Consenso all'interrogazione remota"
  short_help "Se si consente l'interrogazione remota,  possibile  interrogare il modem tramite telefono con toni DTMF."

onoff_switch 517
  description "Consenso alla configurazione remota"
  short_help "Se si consente la configurazione remota,  possibile  configurare il modem tramite telefono con toni DTMF."

entryfield_numbers 510
  description "Password"
  short_help "Introdurre qui la password per l'interrogazione remota."
  max_len 4
  fill 1

group_end

group "Configurazione tramite il telefono collegato"

onoff_switch 522
  description "Accesso premendo la forcella del telefono"
  short_help "Se si consente questo tipo di accesso,  possibile configurare e interrogare l'apparecchio usando il telefono collegato, premendo brevemente la forcella del telefono."
  value_list  "1","0"

onoff_switch 523
  description "Accesso tramite invio di toni DTMF"
  short_help "Se si consente questo tipo di accesso,  possibile configurare e interrogare l'apparecchio usando il telefono collegato, inviando all'apparecchio toni DTMF."
group_end

group "Segreteria telefonica"

slider 532
  description "Volume di riproduzione"
  short_help "Impostare qui il volume con cui devono essere riprodotte le chiamate."
  range_min 0
  range_max 255
  step 128
  unit "Basso", "Medio", "Alto"

slider 531
  description "Volume di registrazione"
  short_help "Impostare qui il volume con cui devono essere registrate le chiamate."
  range_min 0
  range_max 255
  step 128
  unit "Basso", "Medio", "Alto"

group "Modalit viva voce"

slider 534
  description "Volume di riproduzione"
  short_help "Impostare il volume di riproduzione in modo che non ci siano ritorni."
  range_min 0
  range_max 255
  step 128
  unit "Basso", "Medio", "Alto"

slider 533
  description "Sensibilit microfono"
  short_help "Impostare qui la sensibilit microfono per la modalit viva voce."
  range_min 0
  range_max 255
  step 128
  unit "Basso", "Medio", "Alto"

section " Opzioni"

group "Registrazione voce"

selection_list 511
  description "Qualita di registrazione"
  short_help "Selezionare qui la qualit di registrazione."
  item_text "Qualit bassa","Qualit normale","Qualit alta"
  item_value "ADPCM2-7","ADPCM4-7","PCM8L-7"

selection_list 509
  description "Massima durata della reg."
  short_help "Selezionare qui la massima durata della registrazione."
  item_text "illimitato","15 sec.","30 sec.","45 sec.","60 sec.","75 sec.","90 sec.","105 sec.","120 sec.","135 sec."
  item_value "0","1","2","3","4","5","6","7","8","9"

selection_list 521
  description "Minima durata della reg."
  short_help "Selezionare qui la minima durata della registrazione."
  item_text " ", "1 sec.","2 sec.","3 sec.","4 sec.","5 sec.","6 sec.","7 sec.","8 sec.","9 sec.","10 sec.","11 sec.","12 sec.","13 sec.","14 sec."
  item_value "0","1","2","3","4","5","6","7","8","9","10","11","12","13","14"

group_end

group "Messaggi viva voce"

onoff_switch 512
  description "Messaggi annunciati dal sistema"
  short_help "Selezionare qui se l'apparecchio deve annunciare i messaggi di sistema."

onoff_switch 513
  description "Annuncio del numero del chiamante (Caller ID)"
  short_help "Selezionare qui se l'apparecchio deve annunciare il numero del chiamante (CLIP)."

onoff_switch 514
  description "Annuncio dell'ora delle notizie"
  short_help "Selezionare qui se l'apparecchio deve annunciare annunciare l'ora delle notizie."

selection_list 520
  description "Annuncio"
  short_help "Selezionare qui gli annunci."
  item_text "Nr.1","Nr.2","Nr.3","Memoria esaurita"
  item_value "0","1","2","255"

group_end

group "Compatibilit"

onoff_switch 524

  description "Attivazione della segreteria telefonica solo se il modem viene utilizzato da una applicazione."
  short_help "Alcune applicazioni non abilitano correttamente il modem, anche se esso non  pi richiesto.\r\rPer poter usare la funzione segreteria telefonica anche in questo caso, attivare questo pulsante.\r\rUlteriori informazioni su questo tema si possono trovare nel Manuale."

group_end

onoff_switch 110
  description "Consenso all'avviso di chiamata sulla porta a/b 0"
  short_help "Consenso all'avviso di chiamata sulla porta a/b 1."
  invisible 1

onoff_switch 101
  description "Connessione senza selezione all'adapter ISDN"
  short_help "."
  invisible 1

entryfield_text 100
  description "Numero della porta ISDN"
  short_help "."
  invisible 1

group "Porta a/b 1"

readonly_text 172
    description "Somma di tutte le unit"
    short_help "Indica la somma di tutte le unit."

readonly_text 173
    description "Ultima conversazione"
    short_help "Indica le unit dell'ultima connessione."

onoff_switch 181
    description "Azzeramento del contatore di unit"
    short_help "Alla successiva chiusura della finestra di dialogo con 'OK' il contatore di unit viene azzerato."

onoff_switch 111
  description "Segnalazione durante la conversazione con un tono di avviso di chiamata"
  short_help "Con questo si stabilisce se l'avviso di chiamata deve essere attivato o disattivato."

onoff_switch 021
  description "Soppressione della trasmissione del proprio numero d'utenza"
  short_help "Attivare questa opzione per non trasmettere il MSN nelle chiamate in partenza."
  value_list "1", "0"

onoff_switch 103
  description "Selezione automatica del numero d'utenza quando si solleva la cornetta:"
  short_help "Con questo si stabilisce se la connessione senza selezione deve essere attivata o disattivata."

entryfield_numbers 102
  description "Numero di chiamata diretta"
  short_help "Introdurre qui il MSN che deve essere selezionato direttamente quando si solleva la cornetta."

group "Porta a/b 2"

readonly_text 174
   description "Somma di tutte le unit"
    short_help "Indica la somma di tutte le unit."

readonly_text 175
    description "Ultima conversazione"
    short_help "Indica le unit dell'ultima connessione."

onoff_switch 182
    description "Azzeramento del contatore di unit"
    short_help "Alla successiva chiusura della finestra di dialogo con 'OK' il contatore di unit viene azzerato."

onoff_switch 112
  description "Segnalazione durante la conversazione con un tono di avviso di chiamata"
  short_help "Con questo si stabilisce se l'avviso di chiamata deve essere attivato o disattivato."

onoff_switch 033
  description "Soppressione della trasmissione del proprio numero d'utenza"
  short_help "Attivare questa opzione per non trasmettere il MSN nelle chiamate in partenza."
  value_list "1", "0"

onoff_switch 105
  description "Selezione automatica del numero d'utenza quando si solleva la cornetta:"
  short_help "Con questo si stabilisce se la connessione senza selezione deve essere attivata o disattivata."

entryfield_numbers 104
  description "Numero di chiamata diretta"
  short_help "Introdurre qui il MSN che deve essere selezionato direttamente quando si solleva la cornetta."

version "CFGMGR 1.00","spanish"

section "General"

group_logo 0

readonly_text 001
    description "Aparato"
    short_help "Nombre del aparato."

readonly_text 002
    description "Versin"
    short_help "Versin de firmware del aparato."

readonly_text 003
    description "Fecha"
    short_help "Fecha de creacin del firmware."

readonly_text 600
    description "Tipo de firmware"
    short_help "El significado del tipo de firmware."
    item_text "MX - Multilink X.75 (ELSA)", "MP - Multilink PPP"
    item_value "X", "P"

group_end

group "Seleccin del pas"

selection_list 502
  description "Pas"
  short_help "Por favor, seleccione el pas en el que se encuentra. Con esta opcin configura usted la interfaz de lnea de su mdem."
  item_text  "Blgica","Dinamarca","Alemania","Finlandia","Francia","Gran Bretaa","Italia","Liechtenstein","Luxemburgo","Mnaco","Holanda","Noruega","Austria","Portugal","Suecia","Suiza","Espaa","USA"
  item_value  "0F","31","04","3C","3D","B4","59","68","69","74","7B","82","0A","8B","A5","A6","A0","B5"

selection_list 800
  description "Pas"
  short_help "Por favor, seleccione el pas en el que se encuentra. Con esta opcin configura usted la interfaz de lnea de su mdem."
  item_text   "Blgica","Dinamarca","Finlandia","Francia","Alemania","Holanda","Italia","Noruega","Espaa","Suecia","Suiza","Gran Bretaa","Austria","Portugal","Irlanda"
  item_value  "02","03","04","05","06","07","08","0A","0B","0C","0D","0E","0F","18","1A"

group_end

group "Reloj interno del aparato"

entryfield_text 500
  description "Hora"
  short_help "Hora interna del aparato."
  time_format "%h,%m,%s"

entryfield_text 501
  description "Fecha"
  short_help "Fecha interna del aparato."
  date_format "%y,%m,%d"

group_end

group "Protocolo canal D"

selection_list 004
  description "Protocolo"
  short_help "Ajuste el protocolo de canal D deseado."
  item_text  "Automtico","Euro DSS1","DSS1 punto a punto","1TR6 nacional","Protocolo japons: INS64"
  item_value "AUTO", "DSS1","DSS1PP","1TR6","INS64"

selection_list 150
  description "Protocolo"
  short_help "Ajuste el protocolo de canal D deseado."
  item_text "Euro DSS1","1TR6 nacional"
  item_value "DSS1", "1TR6"

group "Configuracin de pas de los puertos a/b"

selection_list 700
  description "Pas"
  short_help "Por favor, seleccione el pas en el que se encuentra. Con esta opcin configura usted la interfaz de lnea de los puertos a/b."
  item_text "Norteamrica", "Grecia","Holanda","Blgica","Francia","Espaa","Italia","Suiza","Austria","Gran Bretaa","Dinamarca","Suecia","Noruega","Alemania","Japn","Turqua","Portugal","Luxemburgo","Irlanda","Chipre","Finlandia"
  item_value "1","30","31","32","33","34","39","41","43","44","45","46","47","49","81","90","351","352","353","357","358"

group "Aceptacin de llamadas"

onoff_switch 300
  description "Bloquear aceptacin de llamadas en adaptador RDSI"
  short_help "Establece que el puerto de datos RDSI no acepte ninguna llamada."
  value_list  "1", "0"

onoff_switch 301
  description "Bloquear aceptacin de llamadas en puerto 1 a/b."
  short_help "Establece que el puerto 1 a/b no acepte ninguna llamada."
  value_list  "1", "0"

onoff_switch 302
  description "Bloquear aceptacin de llamadas en puerto 2 a/b."
  short_help "Establece que el puerto 2 a/b no acepte ninguna llamada."
  value_list  "1", "0"

section "Contestador automtico + Fax"

group "Contestador automtico"

onoff_switch 506
  description "Contestador automtico conectado"
  short_help "Establece si desea aceptar llamadas telefnicas."

onoff_switch 518
  description "Conectar altavoz durante la aceptacin"
  short_help "Cuando esta opcin est activada, puede escuchar las llamadas contestadas por el contestador automtico."

onoff_switch 515
  description "Reproducir nicamente mensaje grabado, no aceptar mensajes"
  short_help "Establece que se reproduzca el mensaje del contestador automtico. No es posible dejar mensajes en el contestador automtico."
  value_list  "1", "0"

onoff_switch 519
  description "Prohibir la escucha o grabacin compartida de llamadas"
  short_help "Active esta opcin cuando desee que las llamadas puedan ser grabadas en el contestador automtico."
  value_list  "1","0"

selection_list 503
  description "Aceptar llamadas"
  short_help  "Establece el tiempo que ha de transcurrir hasta la aceptacin de las llamadas telefnicas."
  item_text   "despus de 2 timbres","despus de 3 timbres","despus de 4 timbres","despus de 5 timbres","despus de 6 timbres","despus de 7 timbres","despus de 8 timbres","despus de 9 timbres"
  item_value  "2","3","4","5","6","7","8","9"

group_end

group "Llamadas de fax"

onoff_switch 505
  description "Aceptacin de fax activada"
  short_help "Establece si desea aceptar llamadas de fax."

onoff_switch 508
  description "Permitir la recepcin de fax durante una llamada telefnica"
  short_help "Establece que un fax entrante pueda ser reconocido, tambin durante una llamada telefnica."

entryfield_text 507
  description "Identificacin del fax"
  short_help "Introduzca la identificacin del fax. Puede ser - por ejemplo - su nombre o su nmero de telfono."
  max_len 20
  ad_to_charset " #"
  convert_to_upper 1

group_end

onoff_switch 504
  description "Aceptar llamadas, tambin cuando el almacenamiento est lleno"
  value_list  "0","1"
  short_help "Establece que el mdem acepte llamadas, tambin cuando el almacenamiento est lleno."

onoff_switch 530
  description "El mdem suena cuando hay una llamada entrante"
  value_list  "0","1"
  short_help "Establece que el mdem suene al recibir una llamada."

section "Adaptador ISDN"

group "Nmeros de telfono (para DSS1)"

entryfield_numbers 005
  description "Nmero de telfono propio"
  short_help "Introduzca el MSN para llamadas salientes."
  max_len 16

entryfield_numbers 007
  description "Aceptar llamadas en"
  short_help "Introduzca el primer MSN, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 16

entryfield_numbers 008
  description "Aceptar llamadas en"
  short_help "Introduzca el segundo MSN, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 16

entryfield_numbers 009
  description "Aceptar llamadas en"
  short_help "Introduzca el tercer MSN, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 16

group "Nmeros de telfono (para 1TR6)"

entryfield_numeric 011
  description "Cifra de terminal"
  short_help "Introduzca el EAZ, sobre el que se ha de reaccionar en caso de llamada entrante."
  range_min 0
  range_max 19

group "Extras"

readonly_text 170
    description "Suma de los pasos"
    short_help "Muestra la suma de todos los pasos del puerto de datos RDSI."

readonly_text 171
    description "Ultima conexin"
    short_help "Muestra los pasos del puerto de datos RDSI de la ltima conexin."
    invisible 1

onoff_switch 180
    description "Borrar contador de pasos"
     short_help "Restablece los pasos del puerto de datos RDSI."

onoff_switch 006
  description "Cancelar la transmisin del nmero de telfono propio"
  short_help "Active esta opcin para que el MSN no sea transmitido en las llamadas salientes."
  value_list "1", "0"

group_end

selection_list 016
  description "Opciones de servicio internas"
  short_help  "Seleccione la opcin de servicio para conexiones salientes"
  item_text   "Comunicacin telefnica 3.1 "khz, "Comunicacin telefnica analgica", "Fax: Grupo 2", "Fax: Grupo 3"
  invisible 1

onoff_switch 012
  description "Aceptar servicio telefnico 3.1 khz"
  short_help "Seleccione si se han de aceptar servicios telefnicos (3.1 khz)."
  invisible 1

onoff_switch 013
  description "Aceptar comunicaciones telefnicas analgicas"
  short_help "Seleccione si se han de aceptar servicios telefnicos (analgicos)."
  invisible 1

onoff_switch 014
  description "Aceptar funcionamiento como fax del grupo 2"
  short_help "Seleccione si se han de aceptar faxes (Grupo 2)."
  invisible 1

onoff_switch 015
  description "Aceptar funcionamiento como fax del grupo 3"
  short_help "Seleccione si se han de aceptar faxes (Grupo 3)."
  invisible 1

section "Puerto 1 a/b"

group "Nmeros de telfono (para DSS1)"

entryfield_text 020
  description "Nmero de telfono propio"
  short_help "Introduzca el MSN para llamadas salientes."
  max_len 16

entryfield_text 022
  description "Aceptar llamadas en"
  short_help "Introduzca el primer MSN, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 16

entryfield_text 023
  description "Aceptar llamadas en"
  short_help "Introduzca el segundo MSN, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 16

entryfield_text 024
  description "Aceptar llamadas en"
  short_help "Introduzca el tercer MSN, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 16

group "Nmeros de telfono (para 1TR6)"

entryfield_text 025
  description "Cifra de terminal"
  short_help "Introduzca el EAZ, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 2

group "Conexin a centralita"

onoff_switch 701
    description "Descolgando el auricular"
    short_help "Al seleccionar esta opcin, escuchar el tono de llamada de la central o de la instalacin telefnica una vez descolgado el auricular. Puede realizar conversaciones externas.\r\rPara poder telefonear internamente, presione la tecla Flash."

onoff_switch 702
    description "Presionando la tecla Flash"
    short_help "Al seleccionar esta opcin, escuchar el tono de llamada de la central o de la instalacin telefnica una vez presionada la tecla Flash. Puede realizar conversaciones externas.\r\rSi est activada la opcin 'Conexin a central al descolgar el auricular', no es posible realizar llamadas internas."

group "Opciones de sevicio"

selection_list 027
  description "Opciones internas de servicio"
  short_help  "Seleccione la opcin de servicio para conexiones salientes"
  item_text   "Comunicacin telefnica 3.1 "khz, "Comunicacin telefnica analgica", "Fax: Grupo 2", "Fax: Grupo 3"

onoff_switch 028
  description "Aceptar servicios telefnicos 3.1 khz"
  short_help "Seleccione si se han de aceptar servicios telefnicos (3.1 khz)."
  invisible 1

onoff_switch 029
  description "Aceptar comunicaciones telefnicas analgicas"
  short_help "Seleccione si se han de aceptar servicios telefnicos (analgicos)."
  invisible 1

onoff_switch 030
  description "Aceptar funcionamiento como fax del grupo 2"
  short_help "Seleccione si se han de aceptar faxes (Grupo 2)."
  invisible 1

onoff_switch 031
  description "Aceptar funcionamiento como fax del grupo 3"
  short_help "Seleccione si se han de aceptar faxes (Grupo 3)."
  invisible 1

section "Puerto 2 a/b"

group "Nmeros de telfono (para DSS1)"

entryfield_text 032
  description "Nmero de telfono propio"
  short_help "Introduzca el MSN para llamadas salientes."
  max_len 16

entryfield_text 034
  description "Aceptar llamadas en"
  short_help "Introduzca el primer MSN, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 16

entryfield_text 035
  description "Aceptar llamadas en"
  short_help "Introduzca el segundo MSN, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 16

entryfield_text 036
  description "Aceptar llamadas en"
  short_help "Introduzca el tercer MSN, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 16

group "Nmeros de telfono (para 1TR6)"

entryfield_text 037
  description "Nmero terminal"
  short_help "Introduzca el EAZ, sobre el que se ha de reaccionar en caso de llamada entrante."
  max_len 2

group "Conexin a centralita"

onoff_switch 703
    description "Descolgando el auricular"
short_help "Al seleccionar esta opcin, escuchar el tono de llamada de la central o de la instalacin telefnica una vez descolgado el auricular. Puede realizar conversaciones externas.\r\rPara poder telefonear internamente, presione la tecla Flash."

onoff_switch 704
    description "Presionando la tecla Flash"
    short_help "Al seleccionar esta opcin, escuchar el tono de llamada de la central o de la instalacin telefnica una vez presionada la tecla Flash. Puede realizar conversaciones externas.\r\rSi est activada la opcin 'Conexin a central al descolgar el auricular', no es posible realizar llamadas internas."

group "Opciones de servicios"

selection_list 039
  description "Opciones internas de servicios"
  short_help  "Seleccione la opcin de servicios para conexiones salientes"
  item_text   "Comunicacin telefnica 3.1 "khz, "Comunicacin telefnica analgica", "Fax: Grupo 2", "Fax: Grupo 3"

onoff_switch 040
  description "Aceptar servicio telefnico 3.1 khz"
  short_help "Seleccione si se han de aceptar servicios telefnicos (3.1 khz)."
  invisible 1

onoff_switch 041
  description "Aceptar comunicaciones telefnicas analgicas"
  short_help "Seleccione si se han de aceptar servicios telefnicos (3.1 khz)."
  invisible 1

onoff_switch 042
  description "Aceptar funcionamiento como fax del grupo 2"
  short_help "Seleccione si se han de aceptar faxes (Grupo 2)."
  invisible 1

onoff_switch 043
  description "Aceptar funcionamiento como fax del grupo 3"
  short_help "Seleccione si se han de aceptar faxes (Grupo 3)."
  invisible 1

section "Configuracin"

group "Consulta remota"

onoff_switch 516
  description "Permitir consulta remota"
  short_help "Cuando permite la consulta remota, puede consultar el mdem desde el telfono, mediante tonos DTMF."

onoff_switch 517
  description "Permitir configuracin remota"
  short_help "Cuando permite la configuracin remota, puede configurar el mdem desde el telfono, mediante tonos DTMF."

entryfield_numbers 510
  description "Contrasea"
  short_help "Introduzca la contrasea para la consulta remota."
  max_len 4
  fill 1

group_end

group "Configuracin mediante microtelfono conectado"

onoff_switch 522
  description "Acceso presionando la horquilla del telfono"
  short_help "Si permite este tipo de acceso, puede configurar y consultar el aparato desde el microtelfono, presionando brevemente la horquilla del aparato."

onoff_switch 523
  description "Acceso mediante emisin de tonos DTMF"
  short_help "Si permite este tipo de acceso, puede configurar y consultar el aparato desde el microtelfono, emitiendo al aparato tonos DTMF."
group_end

group "Contestador automtico"

slider 532
  description "Volumen de reproduccin"
  short_help "Ajuste el volumen de reproduccin de las llamadas grabadas."
  range_min 0
  range_max 255
  step 128
  unit "Bajo", "Medio", "Alto"

slider 531
  description "Volumen de grabado"
  short_help "Ajuste el volumen con el que han de ser grabadas las llamadas."
  range_min 0
  range_max 255
  step 128
  unit "Bajo", "Medio", "Alto"

group "Modo audfono"

slider 534
  description "Volumen de reproduccin"
  short_help "Ajuste el volumen de reproduccin de manera que no se produzcan microfonas."
  range_min 0
  range_max 255
  step 128
  unit "Bajo", "Medio", "Alto"

slider 533
  description "Sensibilidad del micrfono"
  short_help "Ajuste la sensibilidad del micrfono para el funcionamiento con audfono."
  range_min 0
  range_max 255
  step 128
  unit "Bajo", "Medio", "Alto"

section "Extras"

group "Grabacin de voz"

selection_list 511
  description "Calidad de grabacin"
  short_help "Seleccione la calidad de grabacin."
  item_text "Calidad baja","Calidad normal","Calidad alta"
  item_value "ADPCM2-7","ADPCM4-7","PCM8L-7"

selection_list 509
  description "Tiempo mx. de grabacin"
  short_help "Seleccione el tiempo mximo de grabacin."
  item_text "ilimitado","15 seg.","30 seg.","45 seg.","60 seg.","75 seg.","90 seg.","105 seg.","120 seg.","135 seg."
  item_value "0","1","2","3","4","5","6","7","8","9"

selection_list 521
  description "Tiempo mn. de grabacin"
  short_help "Seleccione el tiempo mnimo de grabacin."
  item_text " ", "1 seg.","2 seg.","3 seg.","4 seg.","5 seg.","6 seg.","7 seg.","8 seg.","9 seg.","10 seg.","11 seg.","12 seg.","13 seg.","14 seg."
  item_value "0","1","2","3","4","5","6","7","8","9","10","11","12","13","14"

group_end

group "Reproduccin de voz"

onoff_switch 512
  description "Reproducir mensajes del sistema"
  short_help "Seleccione si el aparato ha de reproducir los mensajes del sistema."

onoff_switch 513
  description "Reproducir el nmero del aparato que realiza la llamada (Id. de la persona que llama)"
  short_help "Seleccione si el aparato ha de reproducir el nmero del aparato que realiza la llamada (CLIP)."

onoff_switch 514
  description "Reproducir hora de los mensajes"
  short_help "Seleccione si el aparato ha de reproducir la hora de los mensajes."

selection_list 520
  description "Texto a reproducir"
  short_help "Seleccione los textos a reproducir."
  item_text "n1","n2","n3","Almacenamiento lleno"
  item_value "0","1","2","255"

group_end

group "Compatibilidad"

onoff_switch 524

  description "Activar el contestador automtico, tambin cuando el mdem est siendo utilizado por otra aplicacin."
  short_help "Algunas aplicaciones no desocupan el mdem, aunque ya no est siendo utilizado.\r\rPara poder utilizar la funcin del contestador automtico, tambin en estos casos, active este conmutador.\r\rMs informacin al respecto en el manual."

group_end

onoff_switch 110
  description "Permitir solicitud de entrada en Puerto 0 a/b"
  short_help "Activar o desactivar la funcin de solicitud de entrada en Puerto 1 a/b."
  invisible 1

onoff_switch 101
  description "Conectar sin marcado en adaptador RDSI"
  short_help "."
  invisible 1

entryfield_text 100
  description "Nmero para Puerto RDSI"
  short_help "."
  invisible 1

group "Puerto 1 a/b"

readonly_text 172
    description "Suma de todos los pasos"
    short_help "Muestra la suma de todos los pasos."

readonly_text 173
    description "Ultima llamada"
    short_help "Muestra los pasos de la ltima conexin."

onoff_switch 181
    description "Borrar contador de pasos"
    short_help "La prxima vez que cierre el dilogo con 'Aceptar', el contador de pasos ser puesto a cero."

onoff_switch 111
  description "Sealizar llamada durante una conversacin mediante tono de permiso de entrada"
  short_help "Establece la conexin o desconexin del tono de permiso de entrada."

onoff_switch 021
  description "Cancelar la transmisin del nmero de telfono propio"
  short_help "Active esta opcin para que el MSN no sea transmitido en las llamadas salientes."
  value_list "1", "0"

onoff_switch 103
  description "Marcar nmero de forma automtica al descolgar el auricular:"
  short_help "Establece la conexin o desconexin de la opcin de conexin sin marcado."

entryfield_numbers 102
  description "Nmero de llamada directa"
  short_help "Introduzca el MSN que ha de ser marcado automticamente al descolgar el auricular."

group "Puerto 2 a/b"

readonly_text 174
   description "Suma de todos los pasos"
    short_help "Muestra la suma de todos los pasos."

readonly_text 175
    description "Ultima llamada"
    short_help "Muestra los pasos de la ltima conexin."

onoff_switch 182
    description "Borrar contador de pasos"
    short_help "La prxima vez que cierre el dilogo con 'Aceptar', el contador de pasos ser puesto a cero."

onoff_switch 112
  description "Sealizar llamada durante una conversacin mediante tono de permiso de entrada"
  short_help "Establece la conexin o desconexin del tono de permiso de entrada."

onoff_switch 033
  description "Cancelar la transmisin del nmero de telfono propio"
  short_help "Active esta opcin para que el MSN no sea transmitido en las llamadas salientes."
  value_list "1", "0"

onoff_switch 105
  description "Marcar nmero de forma automtica al descolgar el auricular:"
  short_help "Establece la activacin o desactivacin de la opcin de conexin sin marcado."

entryfield_numbers 104
  description "Nmero de llamada directa"
  short_help "Introduzca el MSN que ha de ser marcado automticamente al descolgar el auricular."

