<?PHP

/**
 *	Schaltjahr bestimmen
 *
 *	Systemvoraussetzung:
 *	Linux/Windows 
 *	PHP 3, 4, 5
 *
 *	Berechnet das Schaltjahr fuer ein angegebenes Jahr
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Datumsberechnungen
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: schaltjahr.php,v 0.10 2006/03/10 18:48:00 des1 Exp $
 *	@link       http://www.selfphp.de/extratipp
 */

function schaltjahr($jahr)
{
	if(($jahr % 400) == 0 || (($jahr % 4) == 0 && ($jahr % 100) != 0))
		return TRUE;
	else
		return FALSE;
}

$wort[0] = 'kein';
$wort[1] = 'ein';

//Jahr 1900 - durch 4 aber auch durch 100 teilbar
$jahr				= 1900;
$checkJahr	= schaltjahr($jahr);
echo $jahr . ' ist ' . $wort[$checkJahr] . ' Schaltjahr.<br>';

// Jahr 2000 - durch 4 und 100 aber auch durch 400 teilbar
echo '2000 ist ' . $wort[schaltjahr(2000)] . ' Schaltjahr.<br>';

if(schaltjahr(date("Y")))
	echo date("Y") . ' ist ein Schaltjahr.';
else
	echo date("Y") . ' ist kein Schaltjahr.';

?>
