<?php

/**
 *	Datumsberechnung
 *
 *	Systemvoraussetzung:
 *	Linux / Windows
 *	PHP 3, 4, 5
 *
 *	Berechnet die Anzahl der Tage zwischen zwei Datumsangaben 
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Datum
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: GregorianToJD.php,v 0.10 2006/03/11 13:40:00 des1 Exp $
 *	@link       http://www.selfphp.de
 */


/**
 *	Hier wird die eigentliche Berechnung durchgefhrt. Als Parameter werden 
 *	zwei Datumsangaben ($begin, $end) gefordert, einmal das Jngste und einmal 
 *	das lteste Datum. Dabei ist es unrelevant in welcher Reihenfolge Sie diese 
 *	bergeben, da die Function diese automatisch erkennt und zur Berechnung 
 *	jeweils richtig nutzt. Der Parameter $format muss die korrekte Datumsformatierung 
 *	enthalten, also wie Ihr Datum aufgebaut ist. Mgliche Werte hierfr sind:
 *	d	-	Tag
 *	m	-	Monat
 *	Y	-	Jahr
 *	Der letzte Parameter $sep steht fr die Trennzeichen Ihrer Datumsangabe. 
 *	Je nachdem ob Sie z.B. ein deutsches oder amerikanisches Datumformat haben kann es 
 *	mit diesem Parameter eingestellt werden.
 */

function seDay($begin,$end,$format,$sep)
{	
	
	$pos1	= strpos($format, 'd');
	$pos2	= strpos($format, 'm');
	$pos3	= strpos($format, 'Y'); 
	
	$begin	= explode($sep,$begin);
	$end		= explode($sep,$end);
	
	$first 	= GregorianToJD($end[$pos2],$end[$pos1],$end[$pos3]);
	$second	= GregorianToJD($begin[$pos2],$begin[$pos1],$begin[$pos3]);
	
	if($first > $second)
		return $first - $second;
	else
		return $second - $first;
	
}

/*
 *	Dieses Beispiel soll zeigen wie die Funktion mit deutschen Datumsangaben 
 *	aufgerufen wird. Das deutsche Datum wird bekanntlich im Format Tag, Monat, Jahr 
 *	aufgebaut und enthlt als Trennzeichen den Punkt. $timeA enthlt hier das Geburtsdatum 
 *	von Wolfgang Amadeus Mozart, hingegen $timeB die aktuelle Zeit enthlt.
 */
$timeA	= '27.01.1756';
$timeB	= date("d.m.Y");

$mozart = seDay($timeA,$timeB,"dmY",".");
echo 'Wolfgang Amadeus Mozart wre heute ' . $mozart . ' Tage alt';

echo "<br>\n";

/*
 *	Dieses Beispiel soll zeigen wie die Funktion mit amerikanischen Datumsangaben 
 *	aufgerufen wird. Das amerikanische Datum wird bekanntlich im Format Monat, Tag, Jahr 
 *	aufgebaut und enthlt als Trennzeichen ein Bindestrich oder den Schrgstrich. $timeA 
 *	enthlt hier das das Datum der nchsten totalen Sonnenfinsternis in Deutschland, 
 *	hingegen $timeB die aktuelle Zeit enthlt
 */
$timeA	= '09-03-2081';
$timeB	= date("m-d-Y");

$sonne = seDay($timeA,$timeB,"mdY","-");

echo 'Die nchste totale Sonnenfinsternis in Deutschland ist in ' . $sonne . ' Tagen';

?>
