<?PHP

/**
 *	Vestrichene Zeit in Tage, Stunden, Minuten und Sekunden anzeigen
 *
 *	Systemvoraussetzung:
 *	Linux, Windows
 *	PHP 3 >= 3.0.9, PHP 4, PHP 5
 *	PCRE-Bibliothek
 *
 *	Errechnet anhand von Sekunden die vestrichene Zeit in Tage, Stunden, 
 *	Minuten und Sekunden
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Verschlsselung
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: verstrichene_zeit.php,v 0.10 2006/04/08 11:29:30 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Errechnet die Zeit in Tage, Stunden,	Minuten und Sekunden
 *
 * @param		integer		$first				Die erste Zeit in Sekunden (Timestamp)
 * @param		integer		$second				Die zweite Zeit in Sekunden (Timestamp)
 *
 * @return	array			$td						Liefert ein Array mit den Werten						
 */

function makeDifferenz($first, $second)
{
	
	if($first > $second)
		$td['dif'][0] = $first - $second;
	else
		$td['dif'][0] = $second - $first;
	
	$td['sec'][0] = $td['dif'][0] % 60; // 67 = 7

	$td['min'][0] = (($td['dif'][0] - $td['sec'][0]) / 60) % 60; 
	
	$td['std'][0] = (((($td['dif'][0] - $td['sec'][0]) /60)- $td['min'][0]) / 60) % 24;
	
	$td['day'][0] = floor( ((((($td['dif'][0] - $td['sec'][0]) /60)- $td['min'][0]) / 60) / 24) );
	
	$td = makeString($td);
	
	return $td;
	
}

/**
 * Textausgabe fr die Zeiten
 *
 * @param		array			$td					Das Array mit den einzelnen Werten fr Tage, Stunden,	Minuten und Sekunden
 *
 * @return	array			$td					Liefert ein Array mit den Werten						
 */
function makeString($td)
{
	
	if ($td['sec'][0] == 1)
		$td['sec'][1] = 'Sekunde';
	else 
		$td['sec'][1] = 'Sekunden';
	
	if ($td['min'][0] == 1)
		$td['min'][1] = 'Minute';
	else 
		$td['min'][1] = 'Minuten';
		
	if ($td['std'][0] == 1)
		$td['std'][1] = 'Stunde';
	else 
		$td['std'][1] = 'Stunden';
		
	if ($td['day'][0] == 1)
		$td['day'][1] = 'Tag';
	else 
		$td['day'][1] = 'Tage';
	
	return $td;
	
}

$secLast = time();
$secNow = mktime ( 18, 0, 0, 6, 10, 2006 );

$td = makeDifferenz($secLast, $secNow);

echo 'Die Erffnungsspiel der WM 2006 ist in<br>';
echo $td['day'][0] . ' ' . $td['day'][1] . ', ' . $td['std'][0] . ' ' . $td['std'][1] . ', ' . $td['min'][0] . ' ' . $td['min'][1] . ', ' . $td['sec'][0] . ' ' . $td['sec'][1]; 
echo '<br><br>';

$secLast = time();
$secNow = mktime ( 18, 35, 0, 04, 19, 2006 );

$td = makeDifferenz($secLast, $secNow);

echo 'Das Angebot endet in<br>';
echo $td['day'][0] . ' ' . $td['day'][1] . ', ' . $td['std'][0] . ' ' . $td['std'][1] . ', ' . $td['min'][0] . ' ' . $td['min'][1] . ', ' . $td['sec'][0] . ' ' . $td['sec'][1]; 
echo '<br><br>';

$secLast = mktime ( 13, 12, 35, 3, 29, 2006 );
$secNow = time();

$td = makeDifferenz($secLast, $secNow);

echo 'Ihr letzter Besuch war vor:<br>';
echo $td['day'][0] . ' ' . $td['day'][1] . ', ' . $td['std'][0] . ' ' . $td['std'][1] . ', ' . $td['min'][0] . ' ' . $td['min'][1] . ', ' . $td['sec'][0] . ' ' . $td['sec'][1]; 

?> 