<?PHP

/**
 *	Datum/Uhrzeit von MySQL-Format ins deutsche Format und zurck
 *
 *	Systemvoraussetzung:
 *	Linux / Windows
 *	PHP 3, PHP 4, PHP 5
 *
 *	Konvertiert ein MySQL Datum in das deutsche Datumsformat und zurck 
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Datenbank / Datum/Uhrzeit
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: mysqlDate.php,v 0.10 2006/03/22 18:11:00 des1 Exp $
 *	@link       http://www.selfphp.de
 */


/**
 * Konvertiert von MySQL in das deutsche Format
 *
 * @param		string		$date			Enthlt das MySQL-Datum
 *															im Format 2006-03-22
 *
 * @return	string							Liefert das deutsche Format						
 */
function date_mysql2german($date)
{
	$d	=	explode("-",$date);
	
	return	sprintf("%02d.%02d.%04d", $d[2], $d[1], $d[0]);
}

/**
 * Konvertiert das deutsche Format in ein MySQL-Format
 *
 * @param		string		$date			Enthlt das deutsche Format
 *															im Format 22.03.2006
 *
 * @return	string							Liefert das MySQL-Format						
 */
function date_german2mysql($date)
{
	$d	=	explode(".",$date);
	
	return	sprintf("%04d-%02d-%02d", $d[2], $d[1], $d[0]);
}

/**
 * Konvertiert ein MySQL-Timestamp-Format in das deutsche Format
 *
 * @param		string		$date			Enthlt das MySQL-Timestamp-Format
 *															im Format 20060322181602
 *
 * @return	string							Liefert das deutsche Format					
 */
function timestamp_mysql2german($date) {
	
	$stamp['date']	=	sprintf("%02d.%02d.%04d",
												substr($date, 6, 2),
												substr($date, 4, 2),
												substr($date, 0, 4));
											
	$stamp['time']	=	sprintf("%02d:%02d:%02d",
												substr($date, 8,	2),
												substr($date, 10, 2),
												substr($date, 12, 2));

	return $stamp;
}

/**
 * Konvertiert ein deutsches Format in ein MySQL-Timestamp-Format
 *
 * @param		string		$date			Enthlt das deutsche Format
 *															im Format 22.03.2006 18:16:02
 *
 * @return	string							Liefert das MySQL-Timestamp-Format					
 */
function timestamp_german2mysql($date) {
	
	$split = explode(" ",$date);
	$timestamp =	sprintf("%04d%02d%02d",
												substr($split[0], 6, 4),
												substr($split[0], 3, 2),
												substr($split[0], 0, 2));
											
	$timestamp .=	sprintf("%02d%02d%02d",
												substr($split[1], 0,	2),
												substr($split[1], 3, 2),
												substr($split[1], 6, 2));

	return $timestamp;
}

echo "Beispiel:	2006-03-22	<br>\n";
echo "wird zu	:	" . date_mysql2german("2006-03-22") . "	<br>\n";

echo "Beispiel:	2006-03-22 23:59:12	<br>\n";
$expDate = explode(" ","2006-03-22 23:59:12");
echo "wird zu	:	" . date_mysql2german($expDate[0]) . " $expDate[1] <br>\n";

echo "Beispiel:	22.03.2006	<br>\n";
echo "wird zu	:	" . date_german2mysql("22.03.2006") . "	<br>\n";

echo "Beispiel:	20060322181602	<br>\n";
$dateTime	=	timestamp_mysql2german("20060322181602");
echo "wird zu	:	" . $dateTime['date'] . " " . $dateTime['time'] . "	<br>\n";

echo "Beispiel:	22.03.2006 18:16:02	<br>\n";
echo "wird zu	:	" . timestamp_german2mysql("22.03.2006 18:16:02") . "	<br>\n";

?>