<?php

/**
 *	Datumsanzeige
 *
 *	Systemvoraussetzung:
 *	Linux / Windows
 *	PHP 3, 4, 5
 *
 *	berprfung auf ein korrektes Datum
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Datum
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: checkdate.php,v 0.10 2006/03/26 19:12:00 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 *	berprft auf ein korrektes Datum
 *
 *	@param		string		$date			Das zu prfende Datum
 *	@param		string		$format		Der Aufbau des Datums (z.B. Tag/Monat/Jahr)
 *																mgliche Werte sind d,m,Y
 *																d	=>	Tag
 *																m	=>	Monat
 *																Y	=>	Jahr
 *	@param		string		$sep			Das Trennzeichen des datums
 *
 *	@return		bool								true wenn es sich um ein korrektes Datum
 *																handelt, ansonsten false
 */

function check_date($date,$format,$sep)
{	
	
	$pos1	= strpos($format, 'd');
	$pos2	= strpos($format, 'm');
	$pos3	= strpos($format, 'Y'); 
	
	$check	= explode($sep,$date);
	
	return checkdate($check[$pos2],$check[$pos1],$check[$pos3]);

}

$dateA	= '27.03.1971';

echo $dateA . '<br>';

if(check_date($dateA,"dmY","."))
	echo 'Das Datum ist korrekt.<br>';
else
	echo 'Bitte berprfen Sie Ihr Datum!<br>';

$dateB	= '02-29-2006';

echo $dateB . '<br>';

if(check_date($dateB,"mdY","-"))
	echo 'Das Datum ist korrekt.<br>';
else
	echo 'Bitte berprfen Sie Ihr Datum!<br>';

?>