<?PHP

/**
 *	Dateien zum Download anbieten
 *
 *	Systemvoraussetzung:
 *	Linux
 *	PHP 3, PHP 4, PHP 5
 *
 *	Dateien zum Download anbieten
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Verschlsselung
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: download.php,v 0.10 2006/04/14 13:25:30 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Erstellt die Navigationsleiste fr die einzelnen Seiten
 *
 * @param		string		$file		Datei, die zum Download steht
 * @param		string		$dir		Verzeichnis mit abschlieenden Slash (/)
 * @param		string  	$type		Mime-Type
 *
 * @return	void			
 */
 
function makeDownload($file, $dir, $type)
{
	
	header("Content-Type: $type");

	header("Content-Disposition: attachment; filename=\"$file\"");

	readfile($dir.$file);
	
}

// gif  -  image/gif
// jpg  -  image/jpeg
// png  -  image/png
// zip  -  application/zip
// txt  -  text/plain

$dir = '/is/htdocs/wp1042434_BDEO6BJ7VB/www/download/';

$type = 'application/zip';

if(!empty($_GET['file']) && !preg_match('=/=', $_GET['file']))
{
	if(file_exists ($dir.$_GET['file']))
	{
		makeDownload($_GET['file'], $dir, $type);
	}
		
}

// Beispielaufruf:
// http://www.ihreDomain.de/download.php?file=dieDatei.zip
?>