<?PHP

/**
 *	Fgt Zeilenzahlen vor jeder Programmzeile ein
 *
 *	Systemvoraussetzung:
 *	Linux, Windows
 *	PHP 4 >= 4.0.1, PHP 5
 *
 *	Hebt Syntax hervor incl. Zeilenzahlen
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   CURL
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: file_number.php,v 0.10 2006/04/16 14:21:10 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Hebt Syntax hervor incl. Zeilenzahlen
 *
 * @param		string			$file			Die darzustellende Datei
 * @param		string			$table		Tabelle fuer Darstellung
 * @param		bool				$print		Direkte Ausgabe
 *
 * @return	mixed													
 */

function lineNumber($file, $table, $print=false)
{
	
	$content = highlight_file($file,TRUE);
	
	$ex_line = file($file);
	
	$lines = count($ex_line);
	
	$length = strlen($lines);
	
	for($x=1;$x<=$lines;$x++)
	{
		$ausgabe .= str_pad($x, $length, "0", STR_PAD_LEFT);
		$ausgabe .= ":<br>";
	}
	
	$table = @preg_replace('/{lineNumber}/',$ausgabe,$table);
	$table = @preg_replace('/{phpHighlight}/',$content,$table);
	
	if($print === false)
	{
		return $table;
	}
	else
	{
		echo $table;
	}
	
}

$table .= '<table><tr>';
$table .= '<td><code>';
$table .= '<span style="color: #AAAAAA;">{lineNumber}</span>';
$table .= '</code></td>';
$table .= '<td>{phpHighlight}</td>';
$table .= '</tr></table>';

$lineNum = lineNumber("file_number.php",$table,true);

?>