<?php

/**
 *	Kopiert Dateien incl. auf Wunsch mit Unterverzeichnissen
 *
 *	Systemvoraussetzung:
 *	Linux, Windows
 *	PHP 3, PHP 4, PHP 5
 *
 *	Kopiert Dateien incl. auf Wunsch mit Unterverzeichnissen
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Dateien/Verzeichnisse
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: copy_folder.php,v 0.10 2006/04/19 11:23:40 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Kopiert Dateien, auf Wunsch incl. Unterverzeichnisse
 *
 * @param		string		$source							Das zu kopierende Verzeichnis
 * @param		string		$dest								Zielordner
 * @param		array			&$statsCopyFolder		Statistik, Gesamtgroesse aller Dateien und Menge
 * @param		bool			$recursive					Unterverzeichnisse kopieren
 *
 * @return	bool													
 */
function copyFolder($source, $dest, &$statsCopyFolder, $recursive = false)
{

	if (!is_dir($dest)) 
	{ 
        mkdir($dest); 
  } 
 
	$handle = @opendir($source);
	
	if(!$handle)
		return false;
	
	while ($file = @readdir ($handle))
	{
		if (eregi("^\.{1,2}$",$file))
		{
			continue;
		}
		
		if(!$recursive && $source != $source.$file."/")
		{
			if(is_dir($source.$file))
				continue;
		}
		
		if(is_dir($source.$file))
		{
			copyFolder($source.$file."/", $dest.$file."/", $statsCopyFolder, $recursive);
			
		}
		else
		{
			copy($source.$file, $dest.$file);
			$statsCopyFolder['files']++;
			$statsCopyFolder['bytes'] += filesize($source.$file); 
		}
	}

	@closedir($handle);
	
}


/**
 * Berechnet von Bytes in verschiedene Einheiten
 *
 * @param		integer			$size			Wert in Bytes
 * @param		bool				$praefix	Umrechnung 1000 / 1024
 * @param		bool				$short		Kurzform / Langform
 *
 * @return	mixed													
 */

function binary_multiples($size, $praefix=true, $short= true)
{

	if($praefix === true)
	{
		if($short === true)
		{
			$norm = array('B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
		}
		else
		{
			$norm = array('Byte', 
										'Kilobyte', 
										'Megabyte', 
										'Gigabyte', 
										'Terabyte', 
										'Petabyte', 
										'Exabyte', 
										'Zettabyte', 
										'Yottabyte'
										);
		}
		
		$factor = 1000;
	}
	else
	{
		if($short === true)
		{
			$norm = array('B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB');
		}
		else
		{
			$norm = array('Byte', 
										'Kibibyte', 
										'Mebibyte', 
										'Gibibyte', 
										'Tebibyte', 
										'Pebibyte', 
										'Exbibyte', 
										'Zebibyte', 
										'Yobibyte'
										);
		}
		
		$factor = 1024;
		
	}
	
	$count = count($norm) -1;
	
	$x = 0;
	while ($size >= $factor && $x < $count) 
	{ 
		$size /= $factor; 
		$x++;
	} 
  
  $size = sprintf("%01.2f", $size) . ' ' . $norm[$x];

	return $size; 

}

$source = '/is/htdocs/wp1042434_BDEO6BJ7VB/www/bilder/'; 

$dest = '/is/htdocs/wp1042434_BDEO6BJ7VB/www/backup3/';

$statsCopyFolder['bytes'] = 0;
$statsCopyFolder['files'] = 0;

copyFolder($source, $dest, $statsCopyFolder, true);

$statsCopyFolder['bytes'] = binary_multiples($statsCopyFolder['bytes'], true, false);

echo $statsCopyFolder['files'] . ' Dateien kopiert ('.$statsCopyFolder['bytes'].').';

?> 

 