<?PHP

/**
 *	Bilderauflistung
 *
 *	Systemvoraussetzung:
 *	Linux / Windows
 *	PHP 4 >= 4.3.0, PHP 5
 *
 *	Durchluft ein komplettes Verzeichnis und sucht nach einer bestimmten 
 *	anzugebenen Dateiendung (z.B. jpg, gif, png) und listet die Bilder incl 
 *	Dateigre, sowie letzter Aktualisierung auf. 
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Datenbank
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: backupDB.php,v 0.10 2006/03/12 13:01:00 des1 Exp $
 *	@link       http://www.selfphp.de
 */


/**
 *	Als erstes bergeben wir unserer Function das Verzeichnis und die Dateiendung 
 *	($pic = listPicture("bilder/","gif");) fr unsere Verzeichnisauflistung. 
 *	Sollten Sie der Function leere Werte bergeben, so wird das aktuelle Arbeitsverzeichnis 
 *	nach der Dateiendung jpg durchsucht. Die Funktion glob() durchluft jetzt das komplette 
 *	Verzeichnis und sucht nach unser gesuchten Dateiendung  gibt es ein Treffer, so wird der 
 *	Pfadname incl.Dateiname, die Dateigre (hier erfolgt schon die Umrechnung in KB) sowie 
 *	das letzte Aktualisierungsdatum der Datei in unser Array $picture gespeichert. Ist das 
 *	Verzeichnisende erreicht, wird mit return das Array zurck gegeben.
 */
 
 /**
 * Holt alle Bilder
 *
 * @param		string	  $dir				Der Verzeichnisname
 * @param		string	  $type				Die Dateiendung
 *
 * @return	array 		Gibt alle Dateien zurck			
 */
function listPicture($dir=".",$type="jpg")
{
	$x = 0;
	foreach (glob($dir."*.".$type) as $filename)
	{
		$picture[$x]['file'] = $filename;
		$picture[$x]['size'] = filesize($filename) / 1024;
		$picture[$x]['time'] = filemtime($filename);
		$x++;
	} 
	
	return $picture;
}

$pic = listPicture("bilder/","gif");

/**
 *	In $pic haben wir jetzt unsere Bilder alle gespeichert, wir mssen jetzt lediglich den Inhalt 
 *	korrekt auflisten. Aus diesem Grund durchlaufen wir das vollstndige Array. Selbstverstndlich 
 *	htten Sie das auch direkt in der Function listPicture machen knnen aber die bessere Lsung 
 *	ist die Trennung beider Aufgaben. Jetzt mssen wir lediglich die Ausgabe korrekt darstellen, 
 *	also ein Link zu der Datei erstellen und das Datum, sowie die Dateigre formatieren.
 */
for($x=0;$x<count($pic);$x++)
{
	
	$file	=	$pic[$x]['file'];
	$size	=	number_format($pic[$x]['size'], 1, ',', '.');
	$date	=	date("d.m.Y, H:i:s", $pic[$x]['time']);
	
	echo '<a href="'.$file.'">'.$file.'</a>';
	echo ' (Gre: ' . $size . ' KB - ';
	echo 'Letzte nderung: ' . $date . ')';
	echo '<br><br>';

}

?>