<?PHP

/**
 *	Rekursive Verzeichnisdarstellung
 *
 *	Systemvoraussetzung:
 *	Linux / Windows 
 *	PHP 3, PHP 4, PHP 5
 *
 *	Listet alle Dateien oder wahlweise nur ausgewhlte Dateitypen (z.B. *.jpg)
 *	eines Verzeichnisses rekursiv auf. Entweder kann nur das angebenene Verzeichnis 
 *	oder rekursiv alle Verzeichnisse und Unterverzeichnisse gelistet werden.
 *	Weiterhin kann ein Array mit aufzulistende Dateitypen dargestellt werden.
 *	Als Rckgabewert erhalten Sie eine Variable mit smtlichen Verzeichnissen, Dateien,
 *	Dateigre sowie das Aktualisierungsdatum der einzelnen Dateien.
 *	Um eine barrierefreie Darstellung zu garantieren, ist die Ausgabe valide zu HTML 4.01
 *	und CSS 2.0 
 *
 *	Aufruf der Funktion:
 *	----------------------------------------------------------------
 *	include_once("searchFiles.inc.php");
 *	$fileTyp = array("jpg","gif");
 *	$Bildergalerie = scan_dir("Bilder/",$fileTyp,TRUE,FALSE,TRUE);
 *	if($Bildergalerie == false)
 *	{
 *	//echo 'Verzeichnis existiert nicht';
 *	}
 *	else{
 *	$ausgabe = buildSites($Bildergalerie);
 *	echo $ausgabe;
 *	}
 *	----------------------------------------------------------------
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Verzeichnis
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: searchFiles.inc.php,v 0.10 2006/03/14 10:39:00 des1 Exp $
 *	@link       http://www.selfphp.de
 */
 
 
/**
 * Baut die Struktur fr die Darstellung auf
 *
 * @param		array		$pictures		Enthlt den Inhalt der Verzeichnisstruktur
 *
 * @return	string							Liefert das fertige HTML/CSS Layout						
 */
function buildSites($pictures)
{
	reset ($pictures);
	
	$ausgabe .= '<div id="navBar">' . "\n";
	$ausgabe .= '	<div id="sectionLinks">' . "\n";
	foreach($pictures as $key => $array) 
	{
		$ausgabe .= '		<h3>'.$pictures[$key]['name']['dir'].'</h3>' . "\n";
		$ausgabe .= '		<ul>' . "\n";
		foreach ($array as $key2 => $array1) 
		{
		
			if(!empty($pictures[$key][$key2]['file'])){
				$size			=	number_format($pictures[$key][$key2]['size'], 1, ',', '.');
				$date			=	date("d.m.Y, H:i:s", $pictures[$key][$key2]['time']);
				$alt			=	'Datum: ' . $date . ' / Gre: ' . $size . 'KB'; 
				$path			= $pictures[$key]['name']['path'].$pictures[$key][$key2]['file'];
				$ausgabe	.= '			<li><a href="'.$path.'" target="_blank" title="'.$alt.'">';
				$ausgabe .= $pictures[$key][$key2]['file'];
				$ausgabe .= '</a></li>' . "\n"; 
			}

		}
		$ausgabe .= '		</ul>' . "\n";
	}
	
	$ausgabe .= '	</div>' . "\n";
	$ausgabe .= '</div>' . "\n";
	
	return $ausgabe;
}

/**
 * Fllt das Array mit den Dateiinformationen
 * (Pfad, Verzeichnisname, Dateiname, Dateigre, letzte Aktualisierung
 *
 * @param		string	$dir 				Pfad zum Verzeichnis
 * @param		string	$file				enthlt den Dateinamen
 * @param		string	$onlyDir		Enthlt den Verzeichnisnamen fr die berschrift
 *															ber den Bildernamen
 * @param		array		$type				aufzulistende Bildtypen
 *															genommen, ansonsten der Pfad
 * 															Default: FALSE
 * @param		bool		$allFiles		Listet alle Dateien in den Verzeichnissen auf
 *															ohne Rcksicht auf $type	
 * @param		array		$pictures		Enthlt den Inhalt der Verzeichnisstruktur
 *
 * @return	array								Das Array mit allen Dateinamen						
 */
function buildArray($dir,$file,$onlyDir,$type,$allFiles,$pictures)
{
	$typeFormat = FALSE;
			
	foreach ($type as $item)
  {
  	if (strtolower($item) == substr(strtolower($file), -strlen($item)))
			$typeFormat = TRUE;
	}

	if($allFiles || $typeFormat == TRUE)
	{
		if(empty($onlyDir))
			$onlyDir = substr($dir, -strlen($dir), -1);

		$pictures[$dir]['name']['dir']	= $onlyDir;
		$pictures[$dir]['name']['path']	= $dir;
		$pictures[$dir][$file]['file']	= $file;
		$pictures[$dir][$file]['size']	= filesize($dir.$file) / 1024;
		$pictures[$dir][$file]['time']	= filemtime($dir.$file);
	}
	
	return $pictures;
}

/**
 * Durchluft rekursiv das zu durchsuchende Verzeichnis
 *
 * @param		string	$dir 				Pfad zum Verzeichnis
 * @param		array		$type				aufzulistende Bildtypen
 * @param		bool		$only				Bei den berschriften wird nur der Verzeichnisname
 *															genommen, ansonsten der Pfad
 * 															Default: FALSE
 * @param		bool		$allFiles		Listet alle Dateien in den Verzeichnissen auf
 *															ohne Rcksicht auf $type	
 *															Default:	FALSE
 * @param		bool		$recursive	Durchluft rekursiv alle Verzeichnisse und Unterverzeichnisse
 *															Default:	TRUE
 * @param		string	$onlyDir		Enthlt den Verzeichnisnamen fr die berschrift
 *															ber den Bildernamen
 * @param		array		$pictures		Enthlt als Verweis(Referenz) den Inhalt der Verzeichnisstruktur
 *
 * @return	mixed								false im Fehlerfall, ansonsten ein Array mit allen Dateinamen						
 */
 					
function scan_dir($dir, $type=array(),$only=FALSE, $allFiles=FALSE, $recursive=TRUE, $onlyDir="", &$pictures)
{

	$handle = @opendir($dir);
	
	if(!$handle)
		return false;
	
	while ($file = @readdir ($handle))
	{
		if (eregi("^\.{1,2}$",$file))
		{
			continue;
		}
		
		if(!$recursive && $dir != $dir.$file."/")
		{
			if(is_dir($dir.$file))
				continue;
		}
		
		if(is_dir($dir.$file))
		{
			scan_dir($dir.$file."/", $type, $only, $allFiles, $recursive, $file, $pictures);
		}
		else
		{
			if($only)
				$onlyDir = $dir;
			$pictures = buildArray($dir,$file,$onlyDir,$type,$allFiles,$pictures);
		}
	}

	@closedir($handle);

	return $pictures;
  
}


?>