<?PHP

/**
 *	Berechnet den Speicherverbrauch fr Verzeichnisse
 *
 *	Systemvoraussetzung:
 *	Linux, Windows
 *	PHP 3, PHP 4, PHP 5
 *
 *	Berechnet den Speicherverbrauch fr Verzeichnisse und Unterverzeichnisse
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Verzeichnis
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: directory_size.php,v 0.10 2006/04/09 13:33:20 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Durchluft rekursiv das zu durchsuchende Verzeichnis
 *
 * @param		string	$dir 				Pfad zum Verzeichnis
 * @param		integer	&$size			Speichergre
 * @param		bool		$recursive	Durchluft rekursiv alle Verzeichnisse und Unterverzeichnisse
 *															Default:	TRUE
 *
 * @return	bool								false im Fehlerfall						
 */
 					
function dir_size($dir, &$size, $recursive=TRUE)
{

	$handle = @opendir($dir);
	
	if(!$handle)
		return false;
	
	while ($file = @readdir ($handle))
	{
		if (eregi("^\.{1,2}$",$file))
		{
			continue;
		}
		
		if(!$recursive && $dir != $dir.$file."/")
		{
			if(is_dir($dir.$file))
				continue;
		}
		
		if(is_dir($dir.$file))
		{
			dir_size($dir.$file."/", $size, $recursive);
		}
		else
		{
			$size += filesize($dir.$file); 
		}
	}

	@closedir($handle);

}


/**
 * Formatiert den Wert in KiloBytes oder MegaBytes
 *
 * @param		integer	$size				Speichergre in Bytes
 *
 * @return	integer	$size				Formatierte Speichergre						
 */
 
function sizeMath($size)
{
	
	if($size >= 1000000)
	{
		$size = $size / 1000000;
		$size = sprintf("%01.2f", $size) . ' MegaByte';
	}
	else
	{
		$size = $size / 1000;
		$size = sprintf("%01.1f", $size) . ' KiloByte';
	}
	
	return $size;
	
}

$size = 0;

dir_size("bilder/", $size, TRUE);

$sizeD = sizeMath($size);

echo $sizeD;

?>