<?PHP

/**
 *	Dateien und Verzeichnisse mit TAR/BZIP2 komprimieren
 *
 *	Systemvoraussetzung:
 *	Linux 
 *	PHP 3, 4, 5
 *	TAR, BZIP2
 *
 *	Das Skript archiviert zuerst alle angegebenen Dateien und Verzeichnisse(rekursiv) 
 *	mit TAR. Erst im zweiten Schritt wird die erzeugte Archivdatei mit BZIP2 komprimiert 
 *	und die zuvor erstellte Archivdatei gelscht. Zur besseren Darstellung wurde bei der 
 *	Erzeugung des TAR-Archivs die Option "v" gesetzt. Somit wurde gewhrleistet, das die 
 *	Funktion exec() ein Array mit allen archivierten Dateien zurckliefern konnte (siehe Ausgabe).
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Komprimieren
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: bzip2.php,v 0.10 2006/03/12 18:39:00 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 *	Dieses Beispiel wird neben den beiden Textdateien Testdateien1.txt 
 *	und Testdatei2.txt, das komplette Verzeichnis testordner/ incl. 
 *	Unterverzeichnissen komprimieren. Weiterhin werden im testordnerSQL/ 
 *	alle *.sql-Dateien archiviert und komprimiert. Sollten sich in diesem 
 *	Verzeichnis weitere Unterverzeichnisse mit sql-Dateien befinden, so 
 *	werden diese nicht mit in die Archivdatei aufgenommen.
 */
$files[] = 'Testdatei1.txt';
$files[] = 'Testdatei2.txt';
$files[] = 'testordner/';
$files[] = 'testordnerSQL/*.sql';

/**
 *	Jede in unserem Array $files zu sichernde Datei muss durch ein Leerzeichen 
 *	voneinander getrennt werden, damit der Befehl tar einwandfrei funktionieren kann. 
 *	Wir sparen uns einen Schritt und trennen durch && den Archivbefehl tar von dem 
 *	Komprimierungsbefehl bzip2. Wie wir in der Einleitung bereits erklrt haben, 
 *	verzichten wir hier bewusst auf espaceshellcmd(). Zum Schluss fhren wir unser 
 *	Statement mit dem Befehl exec() aus und erhalten, dank unserem Parameter v als 
 *	Rckgabewert die gesicherten Dateinamen und Verzeichnisse.
 */
$implodeFiles = implode(" ", $files);

$tarName = 'backup.tar';

$shellBefehl = "tar -cvf $tarName $implodeFiles && bzip2 $tarName";

exec($shellBefehl,$var);

print_r($var);

?>