<?PHP

/**
 *	MySQL-Backup ber die Shell
 *
 *	Systemvoraussetzung:
 *	Linux 
 *	PHP 4 >= 4.3.0, PHP 5
 *	MySQL
 *	Sed (Stream-Editor)
 *	wahlweise ZIP, BZIP2 oder TARGZ
 *
 *	Erstellt ein Backup Ihrer MySQL-Datenbank (incl. DROP TABLE IF EXISTS 
 *	und CREATE TABLE), komprimiert die Backup-Datei anschliessend wahlweise 
 *	als ZIP, BZIP2 oder TARGZ. 
 *
 *	Lassen Sie dieses Skript stndlich ber ein CronJob laufen
 *	0 * * * * /pfad/zu/php /pfad/zur/backupdatei.php
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Datenbank
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: backupDB.php,v 0.10 2006/02/25 11:28:00 des1 Exp $
 *	@link       http://www.selfphp.de
 */


/**
 *	Konfiguration
 *
 *	Vervollstndigen Sie die bentigten Parameter in der Konfiguration
 *	mit den Werten fr Ihre MySQL-Datenbank. Sie sollten unbedingt fr
 *	die Backup-Dateien ein eigenes Verzeichnis anlegen, damit nicht 
 *	versehentlich andere gepackte Dateien mit gelscht werden.
 * 	Die Integrittsprfung der einzelnen Backupdateien bentigen Sie erst
 *	wieder beim Einlesen der Dateien in die Datenbank. Vielleicht mchten 
 *	Sie ja die Backups auf einen entfernten FTP-Server speichern, diese
 *	dann bei Bedarf automatisch wieder holen und einlesen. Beim Einlesen
 *	wird dann berprft, ob es sich um die Originaldatei handelt.
 */

//	Datenbank Hostname oder IP
$self_config['dbhost']			= 'localhost';

//	Datenbank Username
$self_config['dbuser']			= 'dbuser';

//	Datenbank Passwort
$self_config['dbpassword']	= 'dbpassword';

//	Datenbank Name
$self_config['dbname']			= 'dbname';

//	ZIP-Format ('zip' , 'bzip2' , 'targz')
$self_config['zipformat']		= 'zip';

//	Datei-Prfix der Backupdateien
$self_config['praefix']			= $self_config['dbname'];

// Backupverzeichnis
$self_config['dir']					= 'backup/';

// Alte Backups nach x Tagen lschen
// Lscht alle Backups, die lter als der angegebene Wert sind!
$self_config['delete']			= 14;

// Integrittsprfung vornehmen? - TRUE / FALSE
// Wird beim spaeteren Einlesen der Backupdatei genutzt
$self_config['checkfile']		= TRUE;

// Name der Log-Datei fr Integrittsprfung
$self_config['logfile']			= 'logfile.log';


/**
 *	Programm - ab hier sollten Sie nichts mehr ndern!
 */

$zip_format['zip']		= 'zip';
$zip_format['bzip2']	= 'tar.bz2';
$zip_format['targz']	= 'tar.gz';

/**
 *	Backupverzeichnis erstellen
 *
 *	Um das direkte Auslesen des Verzeichnisses zu verhindern, wird
 *	hier das Backupverzeichnis auf das Recht 700 gesetzt. Dieses
 *	stellt einen Schutz Ihrer Backupdateien dar.
 */
 if(!is_dir($self_config['dir']))
 	mkdir($self_config['dir'], 0700); 

/**
 *	Dateinamen bilden
 *
 *	Der Dateiname wird aus dem Datenbanknamen, gefolgt von dem
 *	aktuellen Datum und der Uhrzeit gebildet.
 *
 *	Beispiel $dateiName:
 *	db152878808_2006-03-07_08-49-48.sql
 *
 *	Beispiel $tarName:
 *	db152878808_2006-03-07_08-49-48.tar.bz2
 *	
 */
$timeBackup		= date("Y-m-d_H-i-s");
$dateiName		= $self_config['dir'] . $self_config['praefix'] . '_' . $timeBackup . '.sql';
$tarName			= $self_config['dir'] . $self_config['praefix'] . '_' . $timeBackup;
$crcpraefix		= $self_config['praefix'] . '_' . $timeBackup . '.';

/**
 *	berprft, ob Sed (Stream-Editor) installiert ist
 */
$sedinstall = TRUE;
exec("whereis sed",$whereis);

if($whereis[0] == "sed:")
	$sedinstall = FALSE;
	

/**
 *	Backup der Datenbank
 *
 *	Fhrt das Backup der Datenbank aus. MySQL hat die	Angewohnheit 
 *	seine eigenen erstellten Kommentare in einem Dump beim Einlesen
 *	als Fehler zu interpretieren. Aus diesem Grund entfernen wir die
 *	Kommentare mittels sed "s/^--.*$//" um unser Backup auch wieder
 *	ohne Probleme einlesen zu knnen. Der Dump wird in das aktuelle
 *	Backupverzeichnis kopiert und nach dem Komprimiervorgang wieder gelscht.
 *	Z.B. als db152878808_2006-03-07_08-49-48.sql
 *
 *	Beispiel der Kommentarzeilen
 *
 *	-- MySQL dump 10.10
 *	--
 *	-- Host: localhost    Database: db152878808
 *	-- ------------------------------------------------------
 *	-- Server version	4.0.25-standard 
 */
$mysqlDump	= 'mysqldump ';
$mysqlDump .= $self_config['dbname'] . ' ';
$mysqlDump .= '--host="' . $self_config['dbhost'] . '" ';
$mysqlDump .= '--user="' . $self_config['dbuser'] . '" ';
$mysqlDump .= '--password="' . $self_config['dbpassword'] . '" ';


/**
 * Ist sed installiert, so werden direkt die Kommentarzeilen entfernt
 * und die *.sql Datei erstellt
 */
if($sedinstall)
	$mysqlDump .= '| sed "s/^--.*$//" > ' . $dateiName;
else
	$mysqlDump .= '> ' . $dateiName;
	
exec($mysqlDump);


/**
 *	Backupdateien komprimieren
 *
 *	Komprimiert die zuvor erstellte Dump-Datei (*.sql) und komprimiert
 *	diese in das in der Konfiguration angegebene Format (zip, bzip2 oder tar.gz)
 *	
 *	-j filtert das Archiv durch bzip2
 *	-z filtert das Archiv durch gzip
 *	-c Erstellt ein neues Archiv
 *	-f Erstellt eine Archivdatei
 */
if($self_config['zipformat'] == "zip")
{
	
	$tarName 		.= '.' . $zip_format[$self_config['zipformat']];
	$shellBefehl = "zip -r $tarName $dateiName";
	exec($shellBefehl);
	
}
else if($self_config['zipformat'] == "bzip2")
{
	
	$tarName 		.= '.' . $zip_format[$self_config['zipformat']];
	$shellBefehl = "tar -jcf $tarName $dateiName && bzip2 $tarName";
	exec($shellBefehl);
	
}
else
{
	
	$tarName 		.= '.' . $zip_format[$self_config['zipformat']];
	$shellBefehl = "tar -zcf $tarName $dateiName && gzip $tarName";
	exec($shellBefehl);
	
}

/**
 *	Lscht die zuvor erstellte nicht komprimierte Backupdatei (*.sql)
 */
unlink($dateiName);


/**
 *	Geht das komplette Backupverzeichnis durch und lscht alle Backups,
 *	die lter als x Tage sind - der Wert fr die Tage wird in der 
 *	Konfiguration festgelegt.
 */
$fileEnd = $zip_format[$self_config['zipformat']];
foreach($zip_format as $fileEnd)
{
	
	foreach (glob($self_config['dir']."*".$fileEnd) as $filename) 
	{
	
		$fileDate = (time() - filectime($filename))/60/60/24;
  	
  	if ($fileDate > $self_config['delete']) 
  		unlink($filename);
	
	}
	
}


/**
 *	Integrittsprfung - Erstellt anhand der komprimierten Backupdatei
 *	eine Prfsumme (MD5-Code) und speichert den 32 Zeichen langen 
 *	Hexadezimalwert in die Log-Datei. Vor dem Einlesen in die Datenbank
 *	kann anhand dieses Wertes geprft werden, ob es sich um die 
 *	Original-Backupdatei handelt.
 *
 *	Form der Backupdatei:
 *
 *	backup/db152878808_2006-03-07_08-49-48.tar.bz2|11d63563dd055a9314f30b4f46893401
 *	backup/db152878808_2006-03-08_17-26-51.tar.bz2|89d9d2a2103ea24885de8c3a639b40ec 
 */
if($self_config['checkfile'])
{

	$crc = md5_file($tarName);
	
	$crcString = $crcpraefix . $zip_format[$self_config['zipformat']] . '|' . $crc . "\n";
	
	$fp = fopen($self_config['logfile'],"a");
  fputs($fp,$crcString);
  fclose($fp);

}

?>
