<?PHP

/**
 *	Prft, ob ein Server oder eine Webseite erreichbar ist
 *
 *	Systemvoraussetzung:
 *	Linux, Windows
 *	PHP 4 >= 4.0.3, PHP 5
 *	curl-Bibliothek
 *
 *	Prft, ob ein Server oder eine Webseite erreichbar ist
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   CURL
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: ping_site.php,v 0.10 2006/04/09 19:38:30 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Prft, ob ein Server oder eine Webseite erreichbar ist
 *
 * @param		array			$webserver	Ein Array mit den URL's
 *
 * @return	array									Das modifizierte Array mit den Statusabfragen						
 */
 
function pingSite($webserver) 
{ 

   foreach ($webserver as $key => $host) 
	{ 
   
		$fp = curl_init($host['url']);
		
		curl_setopt($fp,CURLOPT_TIMEOUT,10);
		
		curl_setopt($fp,CURLOPT_FAILONERROR,1);
		
		curl_setopt($fp,CURLOPT_RETURNTRANSFER,1);
		
		curl_exec($fp);
		
		if (curl_errno($fp) != 0)  
		{ 
			$webserver[$key]['status'] = false;
		} 
		else  
		{ 
			$webserver[$key]['status'] = true;
		} 
		
		curl_close($fp);
   
	}
	
	return $webserver;

}  

$pictureOnline = 'sonne_1.pnp';
$pictureOffline = 'sonne_0.png';

$webserver[0]['name'] = 'SELFPHP';
$webserver[0]['url'] = 'http://www.selfphp.de';

$webserver[1]['name'] = 'SELFPHP Funktionsreferenz';
$webserver[1]['url'] = 'http://www.selfphp.de/funktionsreferenz/index.php';

$webserver[2]['name'] = 'SELFPHP Forum';
$webserver[2]['url'] = 'http://www.selfphp.de/forumXXL';

$webserver[3]['name'] = 'SELFPHP Download';
$webserver[3]['url'] = 'http://downloads.selfphp.de/?file=selfphp_3.0_.tar.gz';

$webserver = pingSite($webserver);
?>
<html>
<head>
<title>Downloads</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link href="formStyle.css" rel="stylesheet" type="text/css">
</head>

<body>
<?PHP
foreach ($webserver as $key => $host) 
{ 
   if(!$host['status'])
   {
    echo '<img src="sonne_0.png"  align="absmiddle">&nbsp;&nbsp;';
    echo 'Name: ' . $host['name'] . '&nbsp;';
    echo '(Offline: ' . $host['url'] . ')<br><br>';
   }
   else
   {
   	echo '<img src="sonne_1.png"  align="absmiddle">&nbsp;&nbsp;';
    echo '<a href="'.$host['url'].'" target="_blank">' . $host['name'] . '</a>&nbsp;';
    echo '<br><br>';
   }
}  

?>
</body>
</html>
