<?PHP

/**
 *	Sendet ein HTTP-Post-Request
 *
 *	Systemvoraussetzung:
 *	Linux, Windows
 *	PHP 4 >= 4.0.3, PHP 5
 *	curl-Bibliothek
 *
 *	Sendet ein HTTP-Post-Request an ein Formular
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   CURL
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: curl_form.php,v 0.10 2006/04/16 21:19:10 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Prft, ob ein Server oder eine Webseite erreichbar ist
 *
 * @param		string			$domain		Die URL zu dem Formular
 * @param		string			$var			Die Variablen
 *
 * @return	bool									TRUE oder FALSE						
 */

function curlStart($domain, $var = false){
	
	$fp = curl_init($domain);
	
	curl_setopt($fp,CURLOPT_TIMEOUT,10);
	
	curl_setopt($fp,CURLOPT_FAILONERROR,1);
	
	curl_setopt($fp,CURLOPT_RETURNTRANSFER,1);
	
	if($var != false)
	{
		curl_setopt($fp,CURLOPT_POST,1);
		curl_setopt ($fp, CURLOPT_POSTFIELDS, $var); 
	}
	
	curl_exec($fp);
	
	if(curl_errno($fp) != 0)
	{
		$send = FALSE;
	}
	else
	{
		$send = TRUE;
	}
	
	curl_close($fp);
	
	return $send;
	
}
 
$formURL = 'http://www.nureinbeispiel4.de/curl_formular.php';
$var = 'vorname=Damir&name=Enseleit';

for($x=0;$x<50;$x++)
{
	$send = curlStart($formURL,$var);
}
?>