<?PHP 

/**
 *	FTP-Upload mit CURL
 *
 *	Systemvoraussetzung:
 *	Linux, Windows
 *	PHP 4 >= 4.0.3, PHP 5
 *	curl-Bibliothek
 *
 *	Kopiert eine Datei vom eigenen Server auf einen anderen Server
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   CURL
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: curl_upload.php,v 0.10 2006/04/16 21:19:10 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 *	Startet den Upload
 *
 *	@param		array			Das Array mit den Zugangsdaten
 *	@param		string		die zu schreibende Datei
 *
 *	@return		array			Enthhaelt Infos zum Upload
 */
function curlUpload($ftp,$ftpFile)
{
	
	$fp		= fopen($ftpFile, "r"); 
	$url	= "ftp://".$ftp['user'].":".$ftp['passwd']."@".$ftp['host'].":21" . $ftp['pfad'].$ftp['file']; 
	
	$handle = curl_init();     
	
	curl_setopt($handle, CURLOPT_URL, $url);  
	curl_setopt($handle, CURLOPT_RETURNTRANSFER, 1);  
	curl_setopt($handle, CURLOPT_UPLOAD, 1);  
	curl_setopt($handle, CURLOPT_INFILE, $fp);  
	curl_setopt($handle, CURLOPT_INFILESIZE, filesize($ftpFile));  

	$result = curl_exec($handle);  

	$info = curl_getinfo ($handle);

	curl_close($handle); 
	
	return $info; 

}


/**
 *	Formatiert die Ausgabe
 *
 *	@param		array			Enthhaelt Infos zum Download
 *
 *	@return		array			Enthhaelt die modifizierten Infos zum Download
 */
function makeInfoUpload($info)
{
	
	if($info['speed_upload'] >= 1000000)
	{
		$speed = $info['speed_upload'] / 1000000;
		$infoF['speed_upload'] = sprintf("%01.2f", $speed) . ' MegaByte/s';
	}
	else
	{
		$speed = $info['speed_upload'] / 1000;
		$infoF['speed_upload'] = sprintf("%01.1f", $speed) . ' KiloByte/s';
	}
	
	if($info['size_upload'] >= 1000000)
	{
		$speed = $info['size_upload'] / 1000000;
		$infoF['size_upload'] = sprintf("%01.2f", $speed) . ' MegaByte/s';
	}
	else
	{
		$speed = $info['size_upload'] / 1000;
		$infoF['size_upload'] = sprintf("%01.1f", $speed) . ' KiloByte/s';
	}
	
	$infoF['total_time'] = sprintf("%01.1f", $info['total_time']) . ' Sek.';
	
	return $infoF;
	
}

$ftp['user'] = 'ftp1042434-test';
$ftp['passwd'] = 'up24TzF';
$ftp['host'] = 'nureinbeispiel4.de';
$ftp['pfad'] = '/www/';
$ftp['file'] = 'curlftp/pecl-5.1.2-Win32.zip';
$ftpFile = 'pecl-5.1.2-Win32.zip';


$info = curlUpload($ftp,$ftpFile);

$infoF = makeInfoUpload($info);

echo 'Dateigre: ' . $infoF['size_upload'] . '<br>';
echo 'Geschwindigkeit: ' . $infoF['speed_upload'] . '<br>';
echo 'Gesamtzeit: ' . $infoF['total_time'] . '<br><br>';
print_r($info);
?> 
