<?php

/**
 *	Passwortgenerierung mit .htaccess und .htpasswd
 *
 *	Systemvoraussetzung:
 *	Linux / Windows 
 *	PHP 3, PHP 4, PHP 5
 *
 *	Schtzt ein komplettes Verzeichnis incl. Unterverzeichnissen mit einem
 *	Benutzernamen und Passwort.
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Verschlsselung
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: crypt.php,v 0.10 2006/04/01 11:32:00 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Baut die Struktur fr die Darstellung auf
 *
 * @param		string		$user					Den Benutzernamen fr den Login
 * @param		string		$authName			Der Text, der angezeigt wird wenn das Login-Fenster
 																		geffnet wird.
 * @param		string		$passwdFile		Den kompletten Pfad zu der Datei .htpasswd
 *																	ohne abschlieenden Slash (/). Lsst man diese
 *																	Variable leer, so wird die Datei im aktuellen
 *																	Verzeichnis erstellt.
 *
 * @return	void										Liefert nichts zurck						
 */
function make_htaccess($user, $authName, $passwdFile="")
{
	
	if(empty($passwdFile))
		$passwdFile=dirname(__FILE__);
	
	$access .=	'AuthType Basic' . "\n";
	$access .=	'AuthName "' . $authName . '"' . "\n";
	$access .=	'AuthUserFile ' . $passwdFile . '/.htpasswd' . "\n";
	$access .=	'require user ' . $user . "\n";
	
	$handle = fopen(".htaccess","w");
	fputs($handle,$access);
	fclose($handle);

}

/**
 * Baut die Struktur fr die Darstellung auf
 *
 * @param		string		$user					Den Benutzernamen fr den Login
 * @param		string		$passwd				Das Passwort fr den Login
 * @param		string		$passwdFile		Den kompletten Pfad zu der Datei .htpasswd
 *																	ohne abschlieenden Slash (/). Lsst man diese
 *																	Variable leer, so wird die Datei im aktuellen
 *																	Verzeichnis erstellt.
 *
 * @return	void										Liefert nichts zurck						
 */
function make_htpasswd($user, $passwd, $passwdFile="")
{
	
	if(empty($passwdFile))
		$passwdFile=dirname(__FILE__);
		
	$passwd = crypt($passwd);
	$htpasswd = $user . ':' . $passwd . "\n";
	
	$handle = fopen($passwdFile . '/.htpasswd',"a");
	fputs($handle,$htpasswd);
	fclose($handle);
	
}

// Den Benutzernamen fr den Login
$user = 'Damir';

// Das Passwort fr den Login
$passwd = 'meinPasswort';

// Der Text, der angezeigt wird wenn das Login-Fenster geffnet wird.
$authName = 'Meine geschtztes Verzeichnis';

//Den kompletten Pfad zu der Datei .htpasswd, ohne abschlieenden Slash (/)
$passwdFile = '';


make_htaccess($user, $authName, $passwdFile);
make_htpasswd($user, $passwd, $passwdFile);

// unlink("crypt.php");

?> 
