<?php

/**
 *	Zyklische Redundanzprfung (CRC)
 *
 *	Systemvoraussetzung:
 *	Linux / Windows 
 *	PHP 4 >= 4.3.0, PHP 5
 *
 *	berprft eine Datei auf eventuelle Beschdigungen. Diese Prfung wird
 *	oftmals bei der Datenbertragung genutzt.
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Verschlsselung
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: crc.php,v 0.10 2006/04/02 09:18:20 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Erstellt eine sfv-Datei mit einer CRC-Prfsumme
 *
 * @param		string		$file					Die Datei, aus der eine Prfsumme erstellt werden soll
 *
 * @return	bool										Liefert true bei Erfolg, ansonsten false						
 */

function createCRC($file)
{
	if(file_exists($file))
	{

		$content = file_get_contents($file);

		$crc = dechex(crc32($content));
				
		$crcText .= "; Erstellt von SELFPHP CRC\n";
		$crcText .= "; " . date("d.m.Y H:i:s") . "\n";
		$crcText .= ";\n";
		$crcText .= basename($file) . " " . $crc . "\n";

		$handle = fopen ($file.".sfv", "w");
		fputs ($handle, $crcText);
		fclose ($handle);
			
		return true;
		
	}
	
	return false;
		
}


/**
 * Prft eine Datei anhand einer sfv-Datei
 *
 * @param		string		$file					Die sfv-Datei in der die Prfsumme (CRC) und die
 *																	zu prfende Datei steht.
 *
 * @return	bool										Liefert true bei Erfolg, ansonsten false						
 */
function checkCRC($file)
{
	
	if(file_exists($file))
	{
		$sfvString = file($file);
		$sfv = explode(" ",	$sfvString[3]);
		
		if(file_exists($sfv[0]))
		{
			$content = file_get_contents($sfv[0]);
			$crc = crc32($content);
			
			if($crc == hexdec($sfv[1]))
				return true;
			else
				return false;
		}
	}
	
	return false;
	
}

// Name der Datei
$fileCRC = 'pecl-5.1.2-Win32.zip';

// Name der sfv-Datei
$fileSFV = 'pecl-5.1.2-Win32.zip.sfv';

if(createCRC($fileCRC))
	echo 'sfv-Datei wurde erstellt<br>';
	
if(checkCRC($fileSFV))
	echo 'Datei ist unbeschdigt<br>';
else
	echo 'Datei ist beschdigt.';
?>