<?php

/**
 *	Kryptographische Hash-Funktionen (MD5)
 *
 *	Systemvoraussetzung:
 *	Linux / Windows 
 *	PHP 4 >= 4.2.0, PHP 5
 *
 *	berprft eine Datei auf Manipulation. Diese Prfung findet anhand einer
 *  kryptographischen Hash-Funktion (MD5) statt. Diese Prfsumme wird oftmals
 *	ei einem Download mit angegeben um Manipulationen an der Datei vorzubeugen.
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Verschlsselung
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: md5.php,v 0.10 2006/04/01 018:22:34 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Erstellt eine sfv-Datei mit einer MD5-Prfsumme
 *
 * @param		string		$file					Die Datei, aus der eine Prfsumme erstellt werden soll
 *
 * @return	mixed										Liefert die Prfsumme als MD5-String, ansonsten false						
 */
function createMD5($file)
{
	if(file_exists($file))
	{

		$md5 = md5_file($file);
				
		$crcText .= "; Erstellt von SELFPHP MD5\n";
		$crcText .= "; " . date("d.m.Y H:i:s") . "\n";
		$crcText .= ";\n";
		$crcText .= basename($file) . " " . $md5 . "\n";

		$handle = fopen ($file.".md5.sfv", "w");
		fputs ($handle, $crcText);
		fclose ($handle);
			
		return $md5;
		
	}
	
	return false;
		
}

/**
 * Prft eine Datei anhand einer sfv-Datei
 *
 * @param		string		$file					Die sfv-Datei, in der die MD5-Prfsumme und die zu prfende
 *																	Datei steht.
 *
 * @return	mixed										Liefert true bei Erfolg, ansonsten false						
 */
function checkMD5($file)
{
	
	if(file_exists($file))
	{
		
		$sfvString = file($file);
		$sfv = explode(" ",	$sfvString[3]);
		
		if(file_exists($sfv[0]))
		{

			$md5 = md5_file($sfv[0]);
			
			if(settype($md5, "string") == $sfv[1])
				return true;
			else
				return false;
				
		}
		
	}
	
	return false;
	
}

// Name der Datei
$fileCRC = 'pecl-5.1.2-Win32.zip';

// Name der sfv-Datei
$fileSFV = 'pecl-5.1.2-Win32.zip.md5.sfv';

$md5Sum = createMD5($fileCRC);
	echo $md5Sum . '<br>';
	
if(checkMD5($fileSFV))
	echo 'Datei ist unbeschdigt<br>';
else
	echo 'Datei ist beschdigt.';
	
?>