<?php

/**
 *	Symmetrische Textverschlsselung mit Rijndael (AES)
 *
 *	Systemvoraussetzung:
 *	Linux / Windows 
 *	PHP 4 >= 4.3.0, PHP 5
 *	libmcrypt 2.4.x oder 2.5.x
 *
 *	Entschlsselt einen Text mit Rijndael
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Verschlsselung
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: aes_decrypt.php,v 0.10 2006/04/04 14:22:10 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Entschlsselt einen Text mit Rijndael
 *
 * @param		string		$file					Die Datei, die entschlsselt werden soll
 * @param		string		$key					Das Passwort fr die Entschlsselung
 * @param		string		$aes					Die Verschlsselungsart
 *																		128 Bit
 *																		192 Bit
 *																		256 Bit
 * @param		string		$ivFile				Die Datei, mit dem IV-Tag
 *
 * @return	mixed										Liefert den entschlsselten Text, ansonsten false						
 */

function decryptAES($file,$key,$aes,$ivFile)
{
	
	// berprft, ob die Datei vorhanden ist und liest sie ein
	if(file_exists($file) && file_exists($ivFile))
	{
		$content = file_get_contents($file);
		$iv = file_get_contents($ivFile);
	}
	else
		return false;
	
	// Setzt den Algorithmus
	switch ($aes) 
	{
		case 128:
   		$rijndael = 'rijndael-128';
   		break;
		case 192:
   		$rijndael = 'rijndael-192';
   		break;
		default:
   		$rijndael = 'rijndael-256';
	}

	// Setzt den Verschlsselungsalgorithmus
	// und setzt den Output Feedback (OFB) Modus
	$cp = mcrypt_module_open($rijndael, '', 'ofb', '');
	
	// Ermittelt die Anzahl der Bits, welche die Schlssellnge des Keys festlegen
  $ks = mcrypt_enc_get_key_size($cp);
  
  // Erstellt den Schlssel, der fr die Verschlsselung genutzt wird
  $key = substr(md5($key), 0, $ks);
  
  // Initialisiert die Verschlsselung
  mcrypt_generic_init($cp, $key, $iv);

  // Entschlsselt die Daten
  $decrypted = mdecrypt_generic($cp, $content);
   
  // Beendet die Verschlsselung 
  mcrypt_generic_deinit($cp);
  
  // Schliet das Modul
  mcrypt_module_close($cp);
  
  return trim($decrypted);
	
}

$decrypted = decryptAES("aestext.txt.aes","MeinPasswort",256,"aestext.txt.iv");

echo $decrypted;
?> 

