<?php

/**
 *	Symmetrische Textverschlsselung mit Rijndael (AES)
 *
 *	Systemvoraussetzung:
 *	Linux / Windows 
 *	PHP 4 >= 4.3.0, PHP 5
 *	libmcrypt 2.4.x oder 2.5.x
 *
 *	Verschlsselt einen Text mit Rijndael
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Verschlsselung
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: aes_encrypt.php,v 0.10 2006/04/04 11:15:30 des1 Exp $
 *	@link       http://www.selfphp.de
 */

/**
 * Verschlsselt einen Text mit Rijndael
 *
 * @param		string		$file					Die Datei, die verschlsselt werden soll
 * @param		string		$key					Das Passwort fr die Verschlsselung
 * @param		string		$aes					Die Verschlsselungsart
 *																		128 Bit
 *																		192 Bit
 *																		256 Bit
 *
 * @return	bool										Liefert true bei Erfolg, ansonsten false						
 */

function encryptAES($file,$key,$aes)
{
	
	// berprft, ob die Datei vorhanden ist und liest sie ein
	if(file_exists($file))
		$content = file_get_contents($file);
	else
		return false;
	
	// Setzt den Algorithmus
	switch ($aes) 
	{
		case 128:
   		$rijndael = 'rijndael-128';
   		break;
		case 192:
   		$rijndael = 'rijndael-192';
   		break;
		default:
   		$rijndael = 'rijndael-256';
	}

	// Setzt den Verschlsselungsalgorithmus
	// und setzt den Output Feedback (OFB) Modus
	$cp = mcrypt_module_open($rijndael, '', 'ofb', '');
	
	// Ermittelt den Initialisierungsvector, der fr die Modi CBC, CFB und OFB bentigt wird. 
	// Der Initialisierungsvector muss beim Entschlsseln den selben Wert wie beim Verschlsseln haben.
	// Windows untersttzt nur MCRYPT_RAND
	if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
		$iv = mcrypt_create_iv(mcrypt_enc_get_iv_size($cp), MCRYPT_RAND);
	else
		$iv = mcrypt_create_iv(mcrypt_enc_get_iv_size($cp), MCRYPT_DEV_RANDOM);
		
	// Ermittelt die Anzahl der Bits, welche die Schlssellnge des Keys festlegen
  $ks = mcrypt_enc_get_key_size($cp);
  
  // Erstellt den Schlssel, der fr die Verschlsselung genutzt wird
  $key = substr(md5($key), 0, $ks);
  
  // Initialisiert die Verschlsselung
  mcrypt_generic_init($cp, $key, $iv);

  // Verschlsselt die Daten
  $encrypted = mcrypt_generic($cp, $content);
  
  // Extrahiert den Dateinamen 
  $fileName = basename($file);
  
  // Speichert die verschlsselten Daten
  $fp = fopen($fileName.".aes","w");
  fputs($fp,$encrypted);
  fclose($fp);
  
  // Speichert den IV-Tag 
  $fp = fopen($fileName.".iv","w");
  fputs($fp,$iv);
  fclose($fp);
   
  // Deinitialisiert die Verschlsselung 
  mcrypt_generic_deinit($cp);
  
  // Schliet das Modul
  mcrypt_module_close($cp);
  
  return true;
	
}

encryptAES("aestext.txt","MeinPasswort",192);
?> 