<?php

/**
 *	Graustufen-Vorschaubilder erstellen
 *
 *	Systemvoraussetzung:
 *	Linux
 *	PHP 5
 *	GDlib
 *
 *	Graustufen-Vorschaubilder erstellen
 *
 * 	LICENSE: GNU General Public License (GPL)
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2,
 *	as published by the Free Software Foundation.
 *
 *	@category   Grafik
 *	@author     Damir Enseleit <info@selfphp.de>
 *	@copyright  2001-2006 SELFPHP
 *	@version    $Id: create_gray_thumb.php,v 0.10 2006/09/11 18:25:30 des1 Exp $
 *	@link       http://www.selfphp.de
 */
 
function resizePicture($file, $width, $height, $color = false)
{

	if(!file_exists($file))
		return false;
	
	header('Content-type: image/jpeg');

	$info = getimagesize($file);

	if($info[2] == 1)
	{
		$image = imagecreatefromgif($file);
	}
	elseif($info[2] == 2)
	{
		$image = imagecreatefromjpeg($file);
	}
	elseif($info[2] == 3)
	{
		$image = imagecreatefrompng($file);
	}
	else
	{
			return false;
	}
	
	if ($width && ($info[0] < $info[1])) 
	{
		$width = ($height / $info[1]) * $info[0];
	} 
	else 
	{
		$height = ($width / $info[0]) * $info[1];
	}

	if(!$color)
		imagefilter($image, IMG_FILTER_GRAYSCALE);
		
	$imagetc = imagecreatetruecolor($width, $height);

	imagecopyresampled($imagetc, $image, 0, 0, 0, 0, $width, $height, $info[0], $info[1]);

	imagejpeg($imagetc, null, 100);	
	
}	

$file = 'vorschaubilder/DSC_0110.jpg';

$width = 250;
$height = 100;
$color = true;

resizePicture($file, $width, $height, $color);

?> 